/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.widgets;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.model.creation.ExposedPropertyCreationSupport;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.ExposedPropertyVariableSupport;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.ShellInfo;
import org.eclipse.wb.internal.swt.model.widgets.WidgetInfo;
import org.eclipse.wb.tests.designer.core.PreferencesRepairer;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class WidgetTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getStyle() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new Text(this, SWT.BORDER);", "  }", "}");
        shell.refresh();
        WidgetInfo text = (WidgetInfo)shell.getChildrenControls().get(0);
        int actualStyle = text.getStyle();
        WidgetTest.assertTrue(((actualStyle & 0x800) == 2048 ? 1 : 0) != 0, (String)("SWT.BORDER bit expected, but " + Integer.toHexString(actualStyle) + " found."));
        ControlInfo checkButton = (ControlInfo)WidgetTest.createJavaInfo("org.eclipse.swt.widgets.Button", "check");
        actualStyle = checkButton.getStyle();
        WidgetTest.assertTrue(((actualStyle & 0x20) == 32 ? 1 : 0) != 0, (String)("SWT.CHECK bit expected, but " + Integer.toHexString(actualStyle) + " found."));
    }

    @Test
    public void test_description_setData() throws Exception {
        ShellInfo shell = (ShellInfo)this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setData('1');", "    setData('key', '2');", "  }", "}");
        shell.refresh();
        Shell shellObject = shell.getWidget();
        WidgetTest.assertEquals((Object)"1", (Object)shellObject.getData());
        WidgetTest.assertEquals((Object)"2", (Object)shellObject.getData("key"));
        WidgetTest.assertNull((Object)shellObject.getData("no-such-key"));
    }

    @Test
    public void test_exposedControls() throws Exception {
        WidgetTest.setFileContentSrc("test/ExposedComposite.java", this.getTestSource("public class ExposedComposite extends Composite {", "  private Button m_button;", "  //", "  public ExposedComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    m_button = new Button(this, SWT.NONE);", "    m_button.setText('button');", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        WidgetTest.waitForAutoBuild();
        CompositeInfo mainComposite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    Label label = new Label(this, SWT.NONE);", "    label.setText('label');", "    ExposedComposite composite = new ExposedComposite(this, SWT.NONE);", "  }", "}");
        WidgetTest.assertEquals((int)2, (int)mainComposite.getChildrenControls().size());
        WidgetTest.assertInstanceOf(ControlInfo.class, mainComposite.getChildrenControls().get(0));
        CompositeInfo composite = (CompositeInfo)mainComposite.getChildrenControls().get(1);
        WidgetTest.assertEquals((int)1, (int)composite.getChildrenControls().size());
        ControlInfo exposedButton = (ControlInfo)composite.getChildrenControls().get(0);
        WidgetTest.assertNotNull((Object)exposedButton);
        WidgetTest.assertInstanceOf(ExposedPropertyCreationSupport.class, (Object)exposedButton.getCreationSupport());
        WidgetTest.assertInstanceOf(ExposedPropertyVariableSupport.class, (Object)exposedButton.getVariableSupport());
        Property property = exposedButton.getPropertyByTitle("text");
        WidgetTest.assertNotNull((Object)property);
        WidgetTest.assertEquals((Object)"button", (Object)property.getValue());
    }

    @Test
    public void test_exposedControl_bounds() throws Exception {
        WidgetTest.setFileContentSrc("test/ExposedComposite.java", this.getTestSource("public class ExposedComposite extends Composite {", "  private Button m_button;", "  public ExposedComposite(Composite parent, int style) {", "    super(parent, style);", "    //", "    Composite innerComposite = new Composite(this, SWT.NONE);", "    innerComposite.setBounds(10, 20, 100, 100);", "    //", "    m_button = new Button(innerComposite, SWT.NONE);", "    m_button.setBounds(30, 40, 100, 20);", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        WidgetTest.waitForAutoBuild();
        CompositeInfo mainComposite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    ExposedComposite exposedComposite = new ExposedComposite(this, SWT.NONE);", "  }", "}");
        mainComposite.refresh();
        WidgetTest.assertEquals((int)1, (int)mainComposite.getChildrenControls().size());
        CompositeInfo exposedComposite = (CompositeInfo)mainComposite.getChildrenControls().get(0);
        WidgetTest.assertEquals((int)1, (int)exposedComposite.getChildrenControls().size());
        ControlInfo exposedButton = (ControlInfo)exposedComposite.getChildrenControls().get(0);
        WidgetTest.assertInstanceOf(ExposedPropertyCreationSupport.class, (Object)exposedButton.getCreationSupport());
        WidgetTest.assertInstanceOf(ExposedPropertyVariableSupport.class, (Object)exposedButton.getVariableSupport());
        WidgetTest.assertEquals((Object)new Rectangle(30, 40, 100, 20), (Object)exposedButton.getModelBounds());
        WidgetTest.assertEquals((Object)new Rectangle(40, 60, 100, 20), (Object)exposedButton.getBounds());
    }

    @Test
    public void test_variableName_setData() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        button.getVariableSupport().setName("button2");
        shell.refresh();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Button button2 = new Button(this, SWT.NONE);", "  }", "}");
        PreferencesRepairer preferences = new PreferencesRepairer(shell.getDescription().getToolkit().getPreferences());
        try {
            preferences.setValue("putNameIntoComponent", true);
            button.getVariableSupport().setName("button3");
            shell.refresh();
            this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Button button3 = new Button(this, SWT.NONE);", "    button3.setData('name', 'button3');", "  }", "}");
            button.getVariableSupport().setName("button4");
            shell.refresh();
            this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Button button4 = new Button(this, SWT.NONE);", "    button4.setData('name', 'button4');", "  }", "}");
        }
        finally {
            preferences.restore();
        }
    }

    @Test
    public void test_variableName_setData_onCreate() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "  }", "}");
        RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        ControlInfo button = BTestUtils.createButton();
        PreferencesRepairer preferences = new PreferencesRepairer(shell.getDescription().getToolkit().getPreferences());
        try {
            preferences.setValue("putNameIntoComponent", true);
            rowLayout.command_CREATE(button, null);
            this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setData('name', 'button');", "    }", "  }", "}");
        }
        finally {
            preferences.restore();
        }
    }
}

