/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.RowInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.jupiter.api.Test;

public class GridBagRowTest
extends AbstractGridBagLayoutTest {
    @Test
    public void test_getAlignment_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.rowHeights = new int[]{0};", "    setLayout(layout);", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)1, (int)layout.getRows().size());
        GridBagRowTest.assertSame((Object)RowInfo.Alignment.UNKNOWN, (Object)((RowInfo)layout.getRows().get(0)).getAlignment());
    }

    @Test
    public void test_getAlignment_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.anchor = GridBagConstraints.NORTH;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)1, (int)layout.getRows().size());
        GridBagRowTest.assertSame((Object)RowInfo.Alignment.TOP, (Object)((RowInfo)layout.getRows().get(0)).getAlignment());
    }

    @Test
    public void test_getAlignment_3() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.anchor = GridBagConstraints.NORTH;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      gbc.anchor = GridBagConstraints.SOUTH;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)1, (int)layout.getRows().size());
        RowInfo row = (RowInfo)layout.getRows().get(0);
        GridBagRowTest.assertSame((Object)RowInfo.Alignment.UNKNOWN, (Object)row.getAlignment());
        row.setAlignment(RowInfo.Alignment.BOTTOM);
        GridBagRowTest.assertSame((Object)RowInfo.Alignment.BOTTOM, (Object)row.getAlignment());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.anchor = GridBagConstraints.SOUTH;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      gbc.anchor = GridBagConstraints.SOUTH;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_DELETE_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3};", "    layout.rowHeights = new int[] {1, 2, 3};", "    layout.columnWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_2, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagRowTest.assertEquals((int)2, (int)layout.getRows().size());
        layout.getRowOperations().delete(0);
        GridBagRowTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagRowTest.assertEquals((int)1, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3};", "    layout.rowHeights = new int[] {2, 3};", "    layout.columnWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.2, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button_2, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_DELETE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3};", "    layout.rowHeights = new int[] {1, 2, 3};", "    layout.columnWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.gridheight = 2;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagRowTest.assertEquals((int)2, (int)layout.getRows().size());
        layout.getRowOperations().delete(1);
        GridBagRowTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagRowTest.assertEquals((int)1, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3};", "    layout.rowHeights = new int[] {1, 3};", "    layout.columnWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_backward() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3, 4};", "    layout.rowHeights = new int[] {1, 2, 3, 4};", "    layout.columnWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 2;", "      gbc.gridy = 2;", "      add(button_2, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)3, (int)layout.getRows().size());
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getRowOperations().move(2, 0);
            }
        });
        GridBagRowTest.assertEquals((int)3, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3, 4};", "    layout.rowHeights = new int[] {3, 1, 2, 4};", "    layout.columnWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.3, 0.1, 0.2, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 0);", "      gbc.gridx = 2;", "      gbc.gridy = 0;", "      add(button_2, gbc);", "    }", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 1;", "      gbc.gridy = 2;", "      add(button_1, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_forward() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3, 4};", "    layout.rowHeights = new int[] {1, 2, 3, 4};", "    layout.columnWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 2;", "      gbc.gridy = 2;", "      add(button_2, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)3, (int)layout.getRows().size());
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getRowOperations().move(0, 3);
            }
        });
        GridBagRowTest.assertEquals((int)3, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {1, 2, 3, 4};", "    layout.rowHeights = new int[] {2, 3, 1, 4};", "    layout.columnWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.2, 0.3, 0.1, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 0);", "      gbc.gridx = 2;", "      gbc.gridy = 1;", "      add(button_2, gbc);", "    }", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 2;", "      add(button_0, gbc);", "    }", "  }", "}");
    }
}

