/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.vue;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.NotificationMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.jsts.JSTSLanguageServerAPI;
import org.eclipse.wildwebdeveloper.jsts.request.ExecuteInfo;
import org.eclipse.wildwebdeveloper.vue.VueLanguageServerAPI;

public class VueLanguageServer
extends ProcessStreamConnectionProvider {
    private static String vuePath = null;
    private static String TS_REQUEST = "tsserver/request";

    public VueLanguageServer() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(NodeJSManager.getNodeJsLocation().getAbsolutePath());
        try {
            if (vuePath == null) {
                this.resolvePaths();
            }
            commands.add(vuePath);
            commands.add("--stdio");
            this.setCommands(commands);
        }
        catch (IOException e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
        }
    }

    private void resolvePaths() throws IOException {
        URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/node_modules/@vue/language-server/bin/vue-language-server.js"));
        vuePath = new File(url.getPath()).getAbsolutePath();
    }

    protected ProcessBuilder createProcessBuilder() {
        ProcessBuilder builder = super.createProcessBuilder();
        builder.environment().put("VUE_NONPOLLING_WATCHER", Boolean.toString(true));
        builder.environment().put("NODE_ENV", "production");
        return builder;
    }

    public String toString() {
        return "VUE Language Server: " + super.toString();
    }

    public void handleMessage(Message message, LanguageServer languageServer, URI rootURI) {
        NotificationMessage msg;
        if (message instanceof NotificationMessage && (msg = (NotificationMessage)message).getMethod().equals(TS_REQUEST)) {
            this.forwardTS((Object[])msg.getParams(), (VueLanguageServerAPI)languageServer, rootURI);
        }
        super.handleMessage(message, languageServer, rootURI);
    }

    private void forwardTS(Object[] params, VueLanguageServerAPI languageServer, URI rootURI) {
        Object requestId = params[0];
        String commandId = (String)params[1];
        Object args = params.length > 2 ? params[2] : null;
        LanguageServers.forProject((IProject)LSPEclipseUtils.findResourceFor((URI)rootURI).getProject()).collectAll((w, ls) -> CompletableFuture.completedFuture(ls)).thenAccept(lss -> lss.stream().filter(JSTSLanguageServerAPI.class::isInstance).map(JSTSLanguageServerAPI.class::cast).findAny().ifPresent(jsts -> jsts.getWorkspaceService().executeCommand(new ExecuteCommandParams("typescript.tsserverRequest", Arrays.asList(commandId, args, new ExecuteInfo()))).whenComplete((result, e) -> {
            Object body = null;
            if (result instanceof Map) {
                body = ((Map)result).get("body");
            }
            languageServer.tsserverResponse(new Object[]{requestId, body});
        })));
    }
}

