/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.GitSubscriberResourceMappingContext;
import org.eclipse.egit.core.synchronize.IgnoreInGitSynchronizations;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;

public class GitChangeSetModelProvider
extends ModelProvider
implements IgnoreInGitSynchronizations {
    public static final String ID = "org.eclipse.egit.ui.changeSetModel";
    private static GitChangeSetModelProvider provider;

    public static GitChangeSetModelProvider getProvider() {
        if (provider == null) {
            try {
                ModelProvider modelProvider = ModelProvider.getModelProviderDescriptor((String)ID).getModelProvider();
                provider = (GitChangeSetModelProvider)modelProvider;
            }
            catch (CoreException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        return provider;
    }

    public ResourceMapping[] getMappings(IResource resource, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        GitSubscriberResourceMappingContext gitContext;
        GitSynchronizeDataSet gsds;
        GitSynchronizeData data;
        if (context instanceof GitSubscriberResourceMappingContext && (data = (gsds = (gitContext = (GitSubscriberResourceMappingContext)context).getSyncData()).getData(resource.getProject())) != null) {
            GitModelObject object = null;
            try {
                object = GitModelObject.createRoot(data);
            }
            catch (IOException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
            if (object != null) {
                ResourceMapping rm = (ResourceMapping)Adapters.adapt((Object)((Object)object), ResourceMapping.class);
                return new ResourceMapping[]{rm};
            }
        }
        return super.getMappings(resource, context, monitor);
    }
}

