/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.xerces.dom.TreeWalkerImpl;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.xml.core.internal.commentelement.impl.CommentElementRegistry;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMEntityDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.CDATASectionImpl;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.core.internal.document.DOMMessages;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentFragmentImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.EntityImpl;
import org.eclipse.wst.xml.core.internal.document.EntityReferenceImpl;
import org.eclipse.wst.xml.core.internal.document.NodeContainer;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.NodeIteratorImpl;
import org.eclipse.wst.xml.core.internal.document.NodeListImpl;
import org.eclipse.wst.xml.core.internal.document.NotationImpl;
import org.eclipse.wst.xml.core.internal.document.ProcessingInstructionImpl;
import org.eclipse.wst.xml.core.internal.document.RangeImpl;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.NameValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class DocumentImpl
extends NodeContainer
implements IDOMDocument,
DocumentRange,
DocumentTraversal {
    private static int maxDocTypeSearch = 500;
    private static int noMaxSearch = -1;
    private static final boolean usetagnamecache = true;
    private DOMModelImpl model = null;
    private TagNameCache tagNameCache = new TagNameCache();
    private Map fCMCache = Collections.synchronizedMap(new LimitedCache());
    static /* synthetic */ Class class$0;

    protected DocumentImpl() {
    }

    protected DocumentImpl(DocumentImpl that) {
        super(that);
    }

    void activateTagNameCache(boolean b) {
        this.tagNameCache.activate(b);
    }

    public Node adoptNode(Node source) throws DOMException {
        return null;
    }

    protected void checkTagNameValidity(String tagName) {
        if (!this.isValidName(tagName)) {
            throw new DOMException(5, this.createDOMExceptionMessage((short)5, tagName));
        }
    }

    public Node cloneNode(boolean deep) {
        DocumentImpl cloned = new DocumentImpl(this);
        if (deep) {
            cloned.importChildNodes(this, true);
        }
        return cloned;
    }

    public Attr createAttribute(String name) throws DOMException {
        this.checkTagNameValidity(name);
        AttrImpl attr = new AttrImpl();
        attr.setOwnerDocument(this);
        attr.setName(name);
        return attr;
    }

    public Attr createAttributeNS(String uri, String name) throws DOMException {
        this.checkTagNameValidity(name);
        AttrImpl attr = new AttrImpl();
        attr.setOwnerDocument(this);
        attr.setName(name);
        attr.setNamespaceURI(uri);
        return attr;
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        CDATASectionImpl cdata = new CDATASectionImpl();
        cdata.setOwnerDocument(this);
        if (data != null) {
            cdata.setData(data);
        }
        return cdata;
    }

    public Comment createComment(String data) {
        CommentImpl comment = new CommentImpl();
        comment.setOwnerDocument(this);
        if (data != null) {
            comment.setData(data);
        }
        return comment;
    }

    public Element createCommentElement(String tagName, boolean isJSPTag) throws DOMException {
        ElementImpl result = null;
        if (!this.isJSPType() && isJSPTag) {
            throw new DOMException(13, DOMMessages.INVALID_MODIFICATION_ERR);
        }
        ElementImpl element = (ElementImpl)this.createElement(tagName);
        element.setJSPTag(isJSPTag);
        CommentElementRegistry registry = CommentElementRegistry.getInstance();
        if (!registry.setupCommentElement(element)) {
            throw new DOMException(5, DOMMessages.INVALID_CHARACTER_ERR);
        }
        result = element;
        return result;
    }

    public DocumentType createDoctype(String name) {
        DocumentTypeImpl docType = new DocumentTypeImpl();
        docType.setOwnerDocument(this);
        docType.setName(name);
        return docType;
    }

    public DocumentFragment createDocumentFragment() {
        DocumentFragmentImpl fragment = new DocumentFragmentImpl();
        fragment.setOwnerDocument(this);
        return fragment;
    }

    public Element createElement(String tagName) throws DOMException {
        this.checkTagNameValidity(tagName);
        ElementImpl element = new ElementImpl();
        element.setOwnerDocument(this);
        element.setTagName(tagName);
        return element;
    }

    public Element createElementNS(String uri, String tagName) throws DOMException {
        if (!this.isValidName(tagName)) {
            throw new DOMException(5, DOMMessages.INVALID_CHARACTER_ERR);
        }
        ElementImpl element = (ElementImpl)this.createElement(tagName);
        element.setNamespaceURI(uri);
        return element;
    }

    public Entity createEntity(String name) {
        EntityImpl entity = new EntityImpl();
        entity.setOwnerDocument(this);
        entity.setName(name);
        return entity;
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        if (!this.isXMLType()) {
            throw new DOMException(9, DOMMessages.NOT_SUPPORTED_ERR);
        }
        EntityReferenceImpl ref = new EntityReferenceImpl();
        ref.setOwnerDocument(this);
        ref.setName(name);
        return ref;
    }

    public NodeIterator createNodeIterator(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) {
        if (root == null) {
            root = this;
        }
        return new NodeIteratorImpl(root, whatToShow, filter);
    }

    public Notation createNotation(String name) {
        NotationImpl notation = new NotationImpl();
        notation.setOwnerDocument(this);
        notation.setName(name);
        return notation;
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        ProcessingInstructionImpl pi = new ProcessingInstructionImpl();
        pi.setOwnerDocument(this);
        pi.setTarget(target);
        if (data != null) {
            pi.setData(data);
        }
        return pi;
    }

    public Range createRange() {
        return new RangeImpl();
    }

    public Text createTextNode(String data) {
        TextImpl text = new TextImpl();
        text.setOwnerDocument(this);
        text.setData(data);
        return text;
    }

    public TreeWalker createTreeWalker(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) {
        if (root == null) {
            String msg = String.valueOf(DOMMessages.NOT_SUPPORTED_ERR) + " - Program Error: root node can not be null for TreeWalker";
            throw new DOMException(9, msg);
        }
        return new TreeWalkerImpl(root, whatToShow, filter, entityReferenceExpansion);
    }

    private DocumentType findDoctype(Node node) {
        int countSearch = 0;
        Node child = node.getFirstChild();
        while (child != null) {
            DocumentType docType;
            if (countSearch++ > maxDocTypeSearch) break;
            if (child.getNodeType() == 10 && child instanceof DocumentType) {
                return (DocumentType)child;
            }
            if (child.getNodeType() == 1 && ((IDOMElement)child).isCommentTag() && (docType = this.findDoctype(child)) != null) {
                return docType;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private Element findDocumentElement(String docName, Node node, Node[] firstFound, int max) {
        int countSearch = 0;
        Node child = node.getFirstChild();
        while (child != null) {
            if (max != noMaxSearch && countSearch++ > max) break;
            if (child.getNodeType() == 1) {
                ElementImpl element = (ElementImpl)child;
                if (element.isCommentTag()) {
                    Element docElement = this.findDocumentElement(docName, element, firstFound, max);
                    if (docElement != null) {
                        return docElement;
                    }
                } else if (!element.isJSPTag()) {
                    if (docName == null) {
                        return element;
                    }
                    String localName = element.getLocalName();
                    if (localName != null) {
                        if (this.isXMLType() ? localName.equals(docName) : localName.equalsIgnoreCase(docName)) {
                            return element;
                        }
                        if (firstFound[0] == null) {
                            firstFound[0] = element;
                        }
                    }
                }
            }
            child = child.getNextSibling();
        }
        return null;
    }

    protected String getCharValue(String name) {
        CMEntityDeclaration decl;
        CMNamedNodeMap map;
        if (name == null) {
            return null;
        }
        int length = name.length();
        if (length == 0) {
            return null;
        }
        if (name.charAt(0) == '#') {
            if (length == 1) {
                return null;
            }
            int radix = 10;
            String s = null;
            if (name.charAt(1) == 'x') {
                radix = 16;
                s = name.substring(2);
            } else {
                s = name.substring(1);
            }
            if (s == null || s.length() == 0) {
                return null;
            }
            if (s.charAt(0) == '-') {
                return null;
            }
            char c = '\u0000';
            try {
                c = (char)Integer.parseInt(s, radix);
            }
            catch (NumberFormatException numberFormatException) {}
            if (c == '\u0000') {
                return null;
            }
            return String.valueOf(c);
        }
        if (name.equals("lt")) {
            return "<";
        }
        if (name.equals("gt")) {
            return ">";
        }
        if (name.equals("amp")) {
            return "&";
        }
        if (name.equals("quot")) {
            return "\"";
        }
        if (this.isXMLType() && name.equals("apos")) {
            return "'";
        }
        CMDocument cm = this.getCMDocument();
        if (cm != null && (map = cm.getEntities()) != null && (decl = (CMEntityDeclaration)map.getNamedItem(name)) != null) {
            String value = decl.getValue();
            if (value == null) {
                return null;
            }
            int valueLength = value.length();
            if (valueLength > 1 && value.charAt(0) == '&' && value.charAt(1) == '#' && value.charAt(valueLength - 1) == ';') {
                return this.getCharValue(value.substring(1, valueLength - 1));
            }
            return value;
        }
        return null;
    }

    protected CMDocument getCMDocument() {
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery(this);
        if (modelQuery == null) {
            return null;
        }
        return modelQuery.getCorrespondingCMDocument(this);
    }

    public DocumentType getDoctype() {
        return this.findDoctype(this);
    }

    public Element getDocumentElement() {
        Node[] first;
        Node docElement;
        String name = null;
        DocumentType docType = this.getDocumentType();
        if (docType != null) {
            name = docType.getName();
        }
        if ((docElement = this.findDocumentElement(name, this, first = new Element[1], noMaxSearch)) == null) {
            docElement = first[0];
        }
        return docElement;
    }

    protected DocumentType getDocumentType() {
        DocumentTypeAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (DocumentTypeAdapter)this.getAdapterFor(clazz)) == null) {
            return this.getDoctype();
        }
        return adapter.getDocumentType();
    }

    public String getDocumentTypeId() {
        DocumentType docType = this.getDocumentType();
        if (docType == null) {
            return null;
        }
        String id = docType.getPublicId();
        if (id == null) {
            id = docType.getSystemId();
        }
        return id;
    }

    public Element getElementById(String id) {
        if (id == null) {
            return null;
        }
        NodeIterator it = this.createNodeIterator(this, -1, null, false);
        if (it == null) {
            return null;
        }
        Node node = it.nextNode();
        while (node != null) {
            ElementImpl element;
            if (node.getNodeType() == 1 && (element = (ElementImpl)node).hasAttribute("id") && id.equals(element.getAttribute("id"))) {
                return element;
            }
            node = it.nextNode();
        }
        return null;
    }

    public NodeList getElementsByTagName(String tagName) {
        if (tagName == null) {
            return new NodeListImpl();
        }
        NodeListImpl elements = null;
        elements = this.tagNameCache.getItem(tagName);
        if (elements == null) {
            elements = this.internalGetElementsByTagName(tagName);
        }
        return elements;
    }

    public NodeList getElementsByTagNameNS(String uri, String tagName) {
        if (tagName == null) {
            return new NodeListImpl();
        }
        NodeIterator it = this.createNodeIterator(this, -1, null, false);
        if (it == null) {
            return new NodeListImpl();
        }
        NodeListImpl elements = new NodeListImpl();
        if (uri != null && uri.length() == 1 && uri.charAt(0) == '*') {
            uri = null;
        }
        if (tagName.length() == 1 && tagName.charAt(0) == '*') {
            tagName = null;
        }
        Node node = it.nextNode();
        while (node != null) {
            if (node.getNodeType() == 1) {
                String nsURI;
                String localName;
                ElementImpl element = (ElementImpl)node;
                if ((tagName == null || (localName = element.getLocalName()) != null && localName.equals(tagName)) && (uri == null || (nsURI = element.getNamespaceURI()) != null && nsURI.equals(uri))) {
                    elements.appendNode(element);
                }
            }
            node = it.nextNode();
        }
        return elements;
    }

    public String getEncoding() {
        return null;
    }

    public DOMImplementation getImplementation() {
        return this.model;
    }

    public IDOMModel getModel() {
        return this.model;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public boolean getStandalone() {
        return false;
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public String getVersion() {
        return null;
    }

    protected boolean ignoreCase() {
        DocumentTypeAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (DocumentTypeAdapter)this.getAdapterFor(clazz)) == null) {
            return false;
        }
        return adapter.getTagNameCase() != 0;
    }

    protected void importChildNodes(Node parent, boolean deep) {
        if (parent == null) {
            return;
        }
        this.removeChildNodes();
        Node child = parent.getFirstChild();
        while (child != null) {
            Node imported = this.importNode(child, deep);
            if (imported != null) {
                this.appendChild(imported);
            }
            child = child.getNextSibling();
        }
    }

    public Node importNode(Node node, boolean deep) throws DOMException {
        if (node == null) {
            return null;
        }
        NodeImpl imported = (NodeImpl)node.cloneNode(deep);
        if (imported == null) {
            return null;
        }
        NodeImpl nodeToNotify = (NodeImpl)node;
        nodeToNotify.notifyUserDataHandlers((short)2, null);
        imported.setOwnerDocument(this, deep);
        return imported;
    }

    private NodeListImpl internalGetElementsByTagName(String tagName) {
        NodeIterator it = this.createNodeIterator(this, -1, null, false);
        if (it == null) {
            return new NodeListImpl();
        }
        NodeListImpl elements = new NodeListImpl();
        if (tagName.length() == 1 && tagName.charAt(0) == '*') {
            tagName = null;
        }
        Node node = it.nextNode();
        while (node != null) {
            ElementImpl element;
            if (node.getNodeType() == 1 && (tagName == null || (element = (ElementImpl)node).matchTagName(tagName))) {
                elements.appendNode(node);
            }
            node = it.nextNode();
        }
        this.tagNameCache.addItem(tagName, elements);
        return elements;
    }

    public boolean isJSPDocument() {
        Element element = this.getDocumentElement();
        if (element == null) {
            return false;
        }
        String tagName = element.getTagName();
        if (tagName == null) {
            return false;
        }
        return tagName.equals("jsp:root");
    }

    public boolean isJSPType() {
        if (this.model == null) {
            return false;
        }
        IModelHandler handler = this.model.getModelHandler();
        if (handler == null) {
            return false;
        }
        String id = handler.getAssociatedContentTypeId();
        if (id == null) {
            return false;
        }
        return id.equals("org.eclipse.jst.jsp.core.jspsource");
    }

    protected boolean isValidName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (NameValidator.isValid(name)) {
            return true;
        }
        if (name.length() == 1 && name.charAt(0) == '!') {
            return true;
        }
        return name.startsWith("<%");
    }

    public boolean isXMLType() {
        DocumentTypeAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (DocumentTypeAdapter)this.getAdapterFor(clazz)) == null) {
            return true;
        }
        return adapter.isXMLType();
    }

    public void setEncoding(String encoding) {
    }

    protected void setModel(IDOMModel model) {
        this.model = (DOMModelImpl)model;
    }

    CMNamedNodeMap getCMAttributes(Element element) {
        CMElementDeclaration decl;
        CMNamedNodeMap map = (CMNamedNodeMap)this.fCMCache.get(element);
        if (map == null && (decl = ModelQueryUtil.getModelQuery(this).getCMElementDeclaration(element)) != null) {
            map = decl.getAttributes();
            this.fCMCache.put(element, map);
        }
        return map;
    }

    public void setStandalone(boolean standalone) {
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    public void setVersion(String version) {
    }

    public String getInputEncoding() {
        throw new DOMException(9, "Not implemented in this version");
    }

    public String getXmlEncoding() {
        throw new DOMException(9, "Not implemented in this version");
    }

    public boolean getXmlStandalone() {
        throw new DOMException(9, "Not implemented in this version");
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new DOMException(9, "Not implemented in this version");
    }

    public String getXmlVersion() {
        throw new DOMException(9, "Not implemented in this version");
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new DOMException(9, "Not implemented in this version");
    }

    public String getDocumentURI() {
        throw new DOMException(9, "Not implemented in this version");
    }

    public void setDocumentURI(String documentURI) {
        throw new DOMException(9, "Not implemented in this version");
    }

    public DOMConfiguration getDomConfig() {
        throw new DOMException(9, "Not implemented in this version");
    }

    public void normalizeDocument() {
        throw new DOMException(9, "Not implemented in this version");
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "Not implemented in this version");
    }

    private class LimitedCache
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private static final int MAX_SIZE = 10;

        public LimitedCache() {
            super(0, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 10;
        }
    }

    class TagNameCache {
        private boolean active = true;
        private Map cache = new HashMap();

        public void activate(boolean b) {
            this.active = b;
            if (!b) {
                this.clear();
            }
        }

        public void addItem(String tagname, NodeListImpl nodelist) {
            if (tagname == null || nodelist == null) {
                return;
            }
            this.cache.put(tagname, nodelist);
        }

        public void clear() {
            this.cache.clear();
        }

        public NodeListImpl getItem(String tagName) {
            NodeListImpl result = null;
            if (this.active) {
                result = (NodeListImpl)this.cache.get(tagName);
            }
            return result;
        }
    }
}

