/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptFunctionBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.ui.SWTFactory;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.Messages;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.editors.StandardJavaScriptBreakpointEditor;

public class FunctionBreakpointEditor
extends StandardJavaScriptBreakpointEditor {
    private Button fEntry;
    private Button fExit;
    public static final int PROP_ENTRY = 4114;
    public static final int PROP_EXIT = 4115;

    public Control createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 2, 1, 0, 0, 0);
        super.createStandardControls(composite);
        Composite watchComp = SWTFactory.createComposite(composite, parent.getFont(), 3, 1, 0, 0, 0);
        this.fEntry = this.createSusupendPropertyEditor(watchComp, this.processMnemonics(Messages.entry), 4114);
        this.fExit = this.createSusupendPropertyEditor(watchComp, this.processMnemonics(Messages.exit), 4115);
        return composite;
    }

    protected void setBreakpoint(IJavaScriptBreakpoint breakpoint) throws CoreException {
        super.setBreakpoint(breakpoint);
        if (breakpoint instanceof IJavaScriptFunctionBreakpoint) {
            IJavaScriptFunctionBreakpoint fbp = (IJavaScriptFunctionBreakpoint)breakpoint;
            this.fEntry.setEnabled(true);
            this.fExit.setEnabled(true);
            this.fEntry.setSelection(fbp.isEntry());
            this.fExit.setSelection(fbp.isExit());
        } else {
            this.fEntry.setEnabled(false);
            this.fExit.setEnabled(false);
            this.fEntry.setSelection(false);
            this.fExit.setSelection(false);
        }
    }

    public void doSave() throws CoreException {
        super.doSave();
        IJavaScriptBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint instanceof IJavaScriptFunctionBreakpoint) {
            IJavaScriptFunctionBreakpoint fpb = (IJavaScriptFunctionBreakpoint)breakpoint;
            fpb.setEntry(this.fEntry.getSelection());
            fpb.setExit(this.fExit.getSelection());
        }
    }
}

