/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlMutable;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkMutable;
import org.eclipse.jpt.nosql.eclipselink.core.context.java.JavaEclipseLinkPersistentAttribute;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;

public class OrmEclipseLinkMutable
extends AbstractOrmXmlContextNode
implements EclipseLinkMutable {
    protected Boolean specifiedMutable = this.buildSpecifiedMutable();
    protected boolean defaultMutable;

    public OrmEclipseLinkMutable(OrmAttributeMapping parent) {
        super((JpaContextNode)parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedMutable_(this.buildSpecifiedMutable());
    }

    public void update() {
        super.update();
        this.setDefaultMutable(this.buildDefaultMutable());
    }

    public boolean isMutable() {
        return this.specifiedMutable != null ? this.specifiedMutable : this.defaultMutable;
    }

    public Boolean getSpecifiedMutable() {
        return this.specifiedMutable;
    }

    public void setSpecifiedMutable(Boolean mutable) {
        this.setSpecifiedMutable_(mutable);
        this.getXmlMutable().setMutable(mutable);
    }

    protected void setSpecifiedMutable_(Boolean mutable) {
        Boolean old = this.specifiedMutable;
        this.specifiedMutable = mutable;
        this.firePropertyChanged("specifiedMutable", old, mutable);
    }

    protected Boolean buildSpecifiedMutable() {
        return this.getXmlMutable().getMutable();
    }

    public boolean isDefaultMutable() {
        return this.defaultMutable;
    }

    protected void setDefaultMutable(boolean mutable) {
        boolean old = this.defaultMutable;
        this.defaultMutable = mutable;
        this.firePropertyChanged("defaultMutable", old, mutable);
    }

    protected boolean buildDefaultMutable() {
        JavaEclipseLinkPersistentAttribute javaAttribute = this.getJavaPersistentAttribute();
        if (javaAttribute == null) {
            return false;
        }
        if (javaAttribute.typeIsDateOrCalendar()) {
            Boolean puTemporalMutable = this.getPersistenceUnit().getOptions().getTemporalMutable();
            return puTemporalMutable == null ? false : puTemporalMutable;
        }
        return javaAttribute.typeIsSerializable();
    }

    public OrmAttributeMapping getParent() {
        return (OrmAttributeMapping)super.getParent();
    }

    protected OrmAttributeMapping getAttributeMapping() {
        return this.getParent();
    }

    protected XmlMutable getXmlMutable() {
        return (XmlMutable)this.getAttributeMapping().getXmlAttributeMapping();
    }

    protected JavaEclipseLinkPersistentAttribute getJavaPersistentAttribute() {
        return (JavaEclipseLinkPersistentAttribute)this.getAttributeMapping().getPersistentAttribute().getJavaPersistentAttribute();
    }

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlValidationTextRange();
        return textRange != null ? textRange : this.getAttributeMapping().getValidationTextRange();
    }

    protected TextRange getXmlValidationTextRange() {
        return this.getXmlMutable().getMutableTextRange();
    }
}

