/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.eclipse.wst.jsdt.chromium.CallbackSemaphore;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.browserfixture.AbstractAttachedTest;
import org.eclipse.wst.jsdt.chromium.internal.transport.FakeConnection;
import org.junit.Assert;
import org.junit.Test;

public class LoadValueTest
extends AbstractAttachedTest<FakeConnection> {
    @Test
    public void testLoadFullValue() throws Exception {
        CountDownLatch latch = this.expectSuspend();
        this.messageResponder.hitBreakpoints(Collections.emptyList());
        latch.await();
        final JsValue[] expressionResult = new JsValue[1];
        JsEvaluateContext.EvaluateCallback evaluateCallback = new JsEvaluateContext.EvaluateCallback(){

            public void success(JsEvaluateContext.ResultOrException result) {
                result.accept((JsEvaluateContext.ResultOrException.Visitor)new JsEvaluateContext.ResultOrException.Visitor<Void>(){

                    public Void visitResult(JsValue value) {
                        expressionResult[0] = value;
                        return null;
                    }

                    public Void visitException(JsValue exception) {
                        return null;
                    }
                });
            }

            public void failure(Exception cause) {
            }
        };
        this.suspendContext.getGlobalEvaluateContext().evaluateSync("#long_value", null, evaluateCallback);
        Assert.assertNotNull((Object)expressionResult[0]);
        JsValue value = expressionResult[0];
        Assert.assertTrue((boolean)value.isTruncated());
        String shortValue = value.getValueString();
        final boolean[] reloadResult = new boolean[1];
        JsValue.ReloadBiggerCallback callback = new JsValue.ReloadBiggerCallback(){

            public void done() {
                reloadResult[0] = true;
            }
        };
        CallbackSemaphore semaphore = new CallbackSemaphore();
        RelayOk relayOk = value.reloadHeavyValue(callback, (SyncCallback)semaphore);
        semaphore.acquireDefault(relayOk);
        Assert.assertTrue((boolean)reloadResult[0]);
        String reloadedValue = value.getValueString();
        Assert.assertTrue((shortValue.length() < reloadedValue.length() ? 1 : 0) != 0);
    }

    @Override
    protected FakeConnection createConnection() {
        return new FakeConnection(this.messageResponder);
    }
}

