/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.spelling.ISpellcheckDelegate;
import org.eclipse.wst.xml.ui.internal.spelling.SpellcheckDelegateAdapterFactory;
import org.eclipse.wst.xml.ui.tests.ProjectUtil;

public class TestSpellcheckDelegateAdapaterFactory
extends TestCase {
    public TestSpellcheckDelegateAdapaterFactory() {
        super("Test Spellcheck Delegate AdapaterFactory");
    }

    public TestSpellcheckDelegateAdapaterFactory(String name) {
        super(name);
    }

    public void testSpellcheckDelegateAdapaterFactory() throws IOException, CoreException {
        String projectName = "TestSpellcheckDelegateAdapaterFactory";
        IProject project = ProjectUtil.createProject(projectName, null, null);
        IStructuredModel structuredModel = null;
        try {
            ProjectUtil.copyBundleEntriesIntoWorkspace("testresources/spellcheck", projectName);
            IFile testFile = project.getFile("spellcheck_comment_element.xml");
            TestSpellcheckDelegateAdapaterFactory.assertTrue((String)("Test file " + testFile + " does not exist"), (boolean)testFile.exists());
            structuredModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(testFile);
            SpellcheckDelegateAdapterFactory factory = new SpellcheckDelegateAdapterFactory();
            ISpellcheckDelegate delegate = (ISpellcheckDelegate)factory.getAdapter((Object)structuredModel, ISpellcheckDelegate.class);
            TestSpellcheckDelegateAdapaterFactory.assertNotNull((String)"Could not get spellcheck delegate", (Object)delegate);
            boolean shouldSpellcheckCommentElement = delegate.shouldSpellcheck(54, structuredModel);
            TestSpellcheckDelegateAdapaterFactory.assertFalse((String)"Should not be spellchecking comment elements", (boolean)shouldSpellcheckCommentElement);
            boolean shouldSpellcheckComment = delegate.shouldSpellcheck(80, structuredModel);
            TestSpellcheckDelegateAdapaterFactory.assertTrue((String)"Should be spellchecking comment regions", (boolean)shouldSpellcheckComment);
        }
        finally {
            project.delete(true, null);
        }
    }
}

