/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import com.ibm.wsdl.util.xml.XPathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ImportHolder;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.LocationHolder;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ReaderError;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.InlineSchemaValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.ElementLocation;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLDocument {
    private static final List STYLE_ONE_WAY = Arrays.asList("input");
    private static final List STYLE_REQUEST_RESPONSE = Arrays.asList("input", "output");
    private static final List STYLE_SOLICIT_RESPONSE = Arrays.asList("output", "input");
    private static final List STYLE_NOTIFICATION = Arrays.asList("output");
    private static final String _ERROR_MULTIPLE_TYPES_DEFINED = "_ERROR_MULTIPLE_TYPES_DEFINED";
    private static final String _UNABLE_TO_IMPORT_NO_LOCATION = "_UNABLE_TO_IMPORT_NO_LOCATION";
    protected ExtensionRegistry extReg = null;
    protected String factoryImplName = null;
    protected Hashtable elementLocations = new Hashtable();
    protected List readerErrors = new ArrayList();
    protected List readerWarnings = new ArrayList();
    protected MessageGenerator messagegenerator;
    private Definition def = null;
    private Set importedDefs = new TreeSet();
    private Element typesEl = null;
    private List messages = new ArrayList();
    private List porttypes = new ArrayList();
    private List bindings = new ArrayList();
    private List services = new ArrayList();
    private List extelements = new ArrayList();
    private int depth;
    private List schemas = new ArrayList();
    private IWSDL11ValidationInfo valinfo;

    public WSDLDocument(String documentBaseURI, Element defEl, int depth, MessageGenerator messagegenerator, IWSDL11ValidationInfo valinfo) throws WSDLException {
        this.messagegenerator = messagegenerator;
        this.valinfo = valinfo;
        this.depth = depth;
        WSDLDocument.checkElementName(defEl, Constants.Q_ELEM_DEFINITIONS);
        WSDLFactory factory = this.factoryImplName != null ? WSDLFactory.newInstance((String)this.factoryImplName) : WSDLFactory.newInstance();
        this.def = factory.newDefinition();
        if (this.def.getNamespace("") != null) {
            this.def.getNamespaces().remove("");
        }
        if (this.extReg != null) {
            this.def.setExtensionRegistry(this.extReg);
        }
        String name = DOMUtils.getAttribute((Element)defEl, (String)"name");
        String targetNamespace = DOMUtils.getAttribute((Element)defEl, (String)"targetNamespace");
        NamedNodeMap attrs = defEl.getAttributes();
        if (documentBaseURI != null) {
            this.def.setDocumentBaseURI(documentBaseURI);
        }
        if (name != null) {
            this.def.setQName(new QName(targetNamespace, name));
        }
        if (targetNamespace != null) {
            this.def.setTargetNamespace(targetNamespace);
        }
        int size = attrs.getLength();
        int i = 0;
        while (i < size) {
            Attr attr = (Attr)attrs.item(i);
            String namespaceURI = attr.getNamespaceURI();
            String localPart = attr.getLocalName();
            String value = attr.getValue();
            if (namespaceURI != null && namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                if (localPart != null && !localPart.equals("xmlns")) {
                    this.def.addNamespace(localPart, value);
                } else {
                    this.def.addNamespace(null, value);
                }
            }
            ++i;
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)defEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_IMPORT, (Node)tempEl)) {
                String namespaceURI = DOMUtils.getAttribute((Element)tempEl, (String)"namespace");
                String locationURI = DOMUtils.getAttribute((Element)tempEl, (String)"location");
                if (locationURI == null || locationURI.equals("")) {
                    this.addReaderError(this.def, tempEl, messagegenerator.getString(_UNABLE_TO_IMPORT_NO_LOCATION));
                } else {
                    ImportHolder ih = new ImportHolder(namespaceURI, locationURI, this.def.getDocumentBaseURI(), this, depth + 1, tempEl, messagegenerator, valinfo);
                    if (!documentBaseURI.equals(ih.getLocation())) {
                        this.importedDefs.add(ih);
                    }
                }
                this.setLocation(tempEl, tempEl);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                this.def.setDocumentationElement(tempEl);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_TYPES, (Node)tempEl)) {
                if (this.typesEl != null) {
                    this.setLocation(tempEl, tempEl);
                    this.addReaderError(this.def, tempEl, messagegenerator.getString(_ERROR_MULTIPLE_TYPES_DEFINED));
                } else {
                    this.typesEl = tempEl;
                    this.parseTypes();
                }
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_MESSAGE, (Node)tempEl)) {
                this.messages.add(tempEl);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_PORT_TYPE, (Node)tempEl)) {
                this.porttypes.add(tempEl);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_BINDING, (Node)tempEl)) {
                this.bindings.add(tempEl);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_SERVICE, (Node)tempEl)) {
                this.services.add(tempEl);
            } else {
                this.extelements.add(tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
    }

    public Definition getDefinition() {
        return this.def;
    }

    public Set getImports() {
        return this.importedDefs;
    }

    public void parseTypes() {
        Types types = this.def.createTypes();
        Element tempEl = DOMUtils.getFirstChildElement((Element)this.typesEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                types.setDocumentationElement(tempEl);
            } else if (tempEl.getLocalName().equalsIgnoreCase("import")) {
                String namespaceURI = DOMUtils.getAttribute((Element)tempEl, (String)"namespace");
                String locationURI = DOMUtils.getAttribute((Element)tempEl, (String)"schemaLocation");
                this.importedDefs.add(new ImportHolder(namespaceURI, locationURI, this.def.getDocumentBaseURI(), this, this.depth + 1, tempEl, this.messagegenerator, this.valinfo));
                try {
                    types.addExtensibilityElement(this.parseExtensibilityElement(Types.class, tempEl, this.def));
                }
                catch (WSDLException wSDLException) {}
            } else {
                try {
                    ExtensibilityElement extElem = this.parseExtensibilityElement(Types.class, tempEl, this.def);
                    types.addExtensibilityElement(extElem);
                }
                catch (WSDLException wSDLException) {}
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.def.setTypes(types);
        this.valinfo.setElementLocations(this.elementLocations);
        List typesElems = types.getExtensibilityElements();
        if (typesElems != null) {
            for (ExtensibilityElement typeElement : typesElems) {
                InlineSchemaValidator xsdVal = new InlineSchemaValidator();
                xsdVal.setMessageGenerator(this.messagegenerator);
                ArrayList<Object> parents = new ArrayList<Object>();
                parents.add(this.def);
                parents.add(0, types);
                xsdVal.validate(typeElement, parents, this.valinfo);
                XSModel[] typesSchemas = this.valinfo.getSchemas();
                ArrayList<XSModel> typesSchemaList = new ArrayList<XSModel>();
                int i = 0;
                while (i < typesSchemas.length) {
                    typesSchemaList.add(typesSchemas[i]);
                    ++i;
                }
                this.schemas.addAll(typesSchemaList);
                this.valinfo.clearSchemas();
            }
        }
        this.valinfo.setElementLocations(null);
    }

    public void parseMessages() {
        int i = 0;
        while (i < this.messages.size()) {
            try {
                this.def.addMessage(this.parseMessage((Element)this.messages.get(i), this.def));
            }
            catch (WSDLException wSDLException) {}
            ++i;
        }
    }

    public void parsePorttypes() {
        int i = 0;
        while (i < this.porttypes.size()) {
            try {
                PortType pt = this.parsePortType((Element)this.porttypes.get(i), this.def);
                if (pt != null) {
                    this.def.addPortType(pt);
                }
            }
            catch (WSDLException wSDLException) {}
            ++i;
        }
    }

    public void parseBindings() {
        int i = 0;
        while (i < this.bindings.size()) {
            try {
                this.def.addBinding(this.parseBinding((Element)this.bindings.get(i), this.def));
            }
            catch (WSDLException wSDLException) {}
            ++i;
        }
    }

    public void parseServices() {
        int i = 0;
        while (i < this.services.size()) {
            try {
                this.def.addService(this.parseService((Element)this.services.get(i), this.def));
            }
            catch (WSDLException wSDLException) {}
            ++i;
        }
    }

    public void parseExtensibilityElements() {
        int i = 0;
        while (i < this.extelements.size()) {
            try {
                this.def.addExtensibilityElement(this.parseExtensibilityElement(Definition.class, (Element)this.extelements.get(i), this.def));
            }
            catch (WSDLException wSDLException) {}
            ++i;
        }
    }

    public void addSchemas(List schemas) {
        this.schemas.addAll(schemas);
    }

    public List getSchemas() {
        return this.schemas;
    }

    protected Binding parseBinding(Element bindingEl, Definition def) throws WSDLException {
        QName portTypeName;
        Binding binding = null;
        String name = DOMUtils.getAttribute((Element)bindingEl, (String)"name");
        try {
            portTypeName = DOMUtils.getQualifiedAttributeValue((Element)bindingEl, (String)"type", (String)"binding", (boolean)false, (Definition)def);
        }
        catch (Exception exception) {
            portTypeName = new QName(null, DOMUtils.getAttribute((Element)bindingEl, (String)"type"));
        }
        PortType portType = null;
        if (name != null) {
            QName bindingName = new QName(def.getTargetNamespace(), name);
            binding = def.getBinding(bindingName);
            if (binding == null) {
                binding = def.createBinding();
                binding.setQName(bindingName);
            } else if (!binding.isUndefined()) {
                this.addReaderError(def, bindingEl, this.messagegenerator.getString("_BINDING_NAME_ALREADY_DEFINED", "'" + binding.getQName().getLocalPart() + "'"));
            }
        } else {
            binding = def.createBinding();
        }
        binding.setUndefined(false);
        if (portTypeName != null) {
            portType = def.getPortType(portTypeName);
            if (portType == null) {
                portType = def.createPortType();
                portType.setQName(portTypeName);
                def.addPortType(portType);
            }
            binding.setPortType(portType);
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)bindingEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                binding.setDocumentationElement(tempEl);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_OPERATION, (Node)tempEl)) {
                binding.addBindingOperation(this.parseBindingOperation(tempEl, portType, def));
            } else {
                binding.addExtensibilityElement(this.parseExtensibilityElement(Binding.class, tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.setLocation(binding, bindingEl);
        return binding;
    }

    protected BindingOperation parseBindingOperation(Element bindingOperationEl, PortType portType, Definition def) throws WSDLException {
        BindingOperation bindingOperation = def.createBindingOperation();
        String name = DOMUtils.getAttribute((Element)bindingOperationEl, (String)"name");
        if (name != null) {
            bindingOperation.setName(name);
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)bindingOperationEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                bindingOperation.setDocumentationElement(tempEl);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_INPUT, (Node)tempEl)) {
                bindingOperation.setBindingInput(this.parseBindingInput(tempEl, def));
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_OUTPUT, (Node)tempEl)) {
                bindingOperation.setBindingOutput(this.parseBindingOutput(tempEl, def));
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_FAULT, (Node)tempEl)) {
                bindingOperation.addBindingFault(this.parseBindingFault(tempEl, def));
            } else {
                bindingOperation.addExtensibilityElement(this.parseExtensibilityElement(BindingOperation.class, tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        if (portType != null) {
            BindingInput bindingInput = bindingOperation.getBindingInput();
            BindingOutput bindingOutput = bindingOperation.getBindingOutput();
            Operation op = null;
            List operations = portType.getOperations();
            Vector<Operation> matchingOperations = new Vector<Operation>();
            for (Operation oper : operations) {
                if (!oper.getName().equalsIgnoreCase(bindingOperation.getName())) continue;
                matchingOperations.add(oper);
            }
            if (matchingOperations != null) {
                if (matchingOperations.size() == 1) {
                    Operation tempOp = (Operation)matchingOperations.get(0);
                    boolean inputOK = false;
                    boolean outputOK = false;
                    Input tempInput = tempOp.getInput();
                    Output tempOutput = tempOp.getOutput();
                    if (tempInput == null && bindingInput == null) {
                        inputOK = true;
                    } else if (bindingInput == null || bindingInput.getName() == null) {
                        inputOK = true;
                    } else if (tempInput != null && bindingInput.getName().equals(tempInput.getName())) {
                        inputOK = true;
                    }
                    if (tempOutput == null && bindingOutput == null) {
                        outputOK = true;
                    } else if (bindingOutput == null || bindingOutput.getName() == null) {
                        outputOK = true;
                    } else if (tempOutput != null && bindingOutput.getName().equals(tempOutput.getName())) {
                        outputOK = true;
                    }
                    if (inputOK && outputOK) {
                        op = tempOp;
                    }
                }
                if (matchingOperations != null && op == null) {
                    Iterator iMatchingOperations = matchingOperations.iterator();
                    while (iMatchingOperations.hasNext()) {
                        boolean inputNamesEqual = false;
                        boolean outputNamesEqual = false;
                        Operation oper = (Operation)iMatchingOperations.next();
                        Input opInput = oper.getInput();
                        if (opInput != null && bindingInput != null) {
                            String opInputName = opInput.getName();
                            String bindingInputName = bindingInput.getName();
                            if (opInputName != null && opInputName.equalsIgnoreCase(bindingInputName)) {
                                inputNamesEqual = true;
                            } else if (opInputName == null && bindingInputName == null) {
                                inputNamesEqual = true;
                            }
                        } else if (opInput == null && bindingInput == null) {
                            inputNamesEqual = true;
                        }
                        Output opOutput = oper.getOutput();
                        if (opOutput != null && bindingOutput != null) {
                            String opOutputName = opOutput.getName();
                            String bindingOutputName = bindingOutput.getName();
                            if (opOutputName != null && opOutputName.equalsIgnoreCase(bindingOutputName)) {
                                outputNamesEqual = true;
                            } else if (opOutputName == null && bindingOutputName == null) {
                                outputNamesEqual = true;
                            }
                        } else if (opOutput == null && bindingOutput == null) {
                            outputNamesEqual = true;
                        }
                        if (!inputNamesEqual || !outputNamesEqual) continue;
                        op = oper;
                        break;
                    }
                }
            }
            if (op == null) {
                op = def.createOperation();
                op.setName(name);
                portType.addOperation(op);
            }
            bindingOperation.setOperation(op);
        }
        this.setLocation(bindingOperation, bindingOperationEl);
        return bindingOperation;
    }

    protected BindingInput parseBindingInput(Element bindingInputEl, Definition def) throws WSDLException {
        BindingInput bindingInput = def.createBindingInput();
        String name = DOMUtils.getAttribute((Element)bindingInputEl, (String)"name");
        if (name != null) {
            bindingInput.setName(name);
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)bindingInputEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                bindingInput.setDocumentationElement(tempEl);
            } else {
                bindingInput.addExtensibilityElement(this.parseExtensibilityElement(BindingInput.class, tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.setLocation(bindingInput, bindingInputEl);
        return bindingInput;
    }

    protected BindingOutput parseBindingOutput(Element bindingOutputEl, Definition def) throws WSDLException {
        BindingOutput bindingOutput = def.createBindingOutput();
        String name = DOMUtils.getAttribute((Element)bindingOutputEl, (String)"name");
        if (name != null) {
            bindingOutput.setName(name);
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)bindingOutputEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                bindingOutput.setDocumentationElement(tempEl);
            } else {
                bindingOutput.addExtensibilityElement(this.parseExtensibilityElement(BindingOutput.class, tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.setLocation(bindingOutput, bindingOutputEl);
        return bindingOutput;
    }

    protected BindingFault parseBindingFault(Element bindingFaultEl, Definition def) throws WSDLException {
        BindingFault bindingFault = def.createBindingFault();
        String name = DOMUtils.getAttribute((Element)bindingFaultEl, (String)"name");
        if (name != null) {
            bindingFault.setName(name);
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)bindingFaultEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                bindingFault.setDocumentationElement(tempEl);
            } else {
                bindingFault.addExtensibilityElement(this.parseExtensibilityElement(BindingFault.class, tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.setLocation(bindingFault, bindingFaultEl);
        return bindingFault;
    }

    protected Message parseMessage(Element msgEl, Definition def) throws WSDLException {
        Message msg = null;
        String name = DOMUtils.getAttribute((Element)msgEl, (String)"name");
        if (name != null) {
            QName messageName = new QName(def.getTargetNamespace(), name);
            msg = def.getMessage(messageName);
            if (msg == null) {
                msg = def.createMessage();
                msg.setQName(messageName);
            } else if (!msg.isUndefined()) {
                this.addReaderError(def, msgEl, this.messagegenerator.getString("_MESSAGE_NAME_ALREADY_DEFINED", "'" + msg.getQName().getLocalPart() + "'"));
            }
        } else {
            msg = def.createMessage();
        }
        msg.setUndefined(false);
        Element tempEl = DOMUtils.getFirstChildElement((Element)msgEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                msg.setDocumentationElement(tempEl);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_PART, (Node)tempEl)) {
                msg.addPart(this.parsePart(tempEl, def));
            } else {
                msg.addExtensibilityElement(this.parseExtensibilityElement(Message.class, tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.setLocation(msg, msgEl);
        return msg;
    }

    protected Part parsePart(Element partEl, Definition def) throws WSDLException {
        QName typeName;
        QName elementName;
        Part part = def.createPart();
        String name = DOMUtils.getAttribute((Element)partEl, (String)"name");
        try {
            elementName = DOMUtils.getQualifiedAttributeValue((Element)partEl, (String)"element", (String)"message", (boolean)false, (Definition)def);
        }
        catch (Exception exception) {
            elementName = new QName(null, DOMUtils.getAttribute((Element)partEl, (String)"element"));
        }
        try {
            typeName = DOMUtils.getQualifiedAttributeValue((Element)partEl, (String)"type", (String)"message", (boolean)false, (Definition)def);
        }
        catch (Exception exception) {
            typeName = new QName(null, DOMUtils.getAttribute((Element)partEl, (String)"type"));
        }
        if (name != null) {
            part.setName(name);
        }
        if (elementName != null) {
            part.setElementName(elementName);
        }
        if (typeName != null) {
            part.setTypeName(typeName);
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)partEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                part.setDocumentationElement(tempEl);
            } else {
                DOMUtils.throwWSDLException((Element)tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        Map extensionAttributes = part.getExtensionAttributes();
        extensionAttributes.putAll(this.getPartAttributes(partEl, def));
        this.setLocation(part, partEl);
        return part;
    }

    protected Map getPartAttributes(Element el, Definition def) throws WSDLException {
        HashMap<QName, QName> attributes = new HashMap<QName, QName>();
        NamedNodeMap nodeMap = el.getAttributes();
        int atts = nodeMap.getLength();
        int a = 0;
        while (a < atts) {
            Attr attribute = (Attr)nodeMap.item(a);
            String lName = attribute.getLocalName();
            String nSpace = attribute.getNamespaceURI();
            String prefix = attribute.getPrefix();
            QName name = new QName(nSpace, lName);
            if (nSpace != null && !nSpace.equals("http://schemas.xmlsoap.org/wsdl/")) {
                if (!nSpace.equals("http://www.w3.org/2000/xmlns/")) {
                    String strValue = attribute.getValue();
                    QName qValue = null;
                    try {
                        qValue = DOMUtils.getQName((String)strValue, (Element)el, (Definition)def);
                    }
                    catch (WSDLException wSDLException) {
                        qValue = new QName(strValue);
                    }
                    attributes.put(name, qValue);
                    String tempNSUri = def.getNamespace(prefix);
                    while (tempNSUri != null && !tempNSUri.equals(nSpace)) {
                        prefix = String.valueOf(prefix) + "_";
                        tempNSUri = def.getNamespace(prefix);
                    }
                    def.addNamespace(prefix, nSpace);
                }
            } else if (!(lName.equals("name") || lName.equals("element") || lName.equals("type"))) {
                WSDLException wsdlExc = new WSDLException("INVALID_WSDL", "Encountered illegal part extension attribute '" + name + "'. Extension " + "attributes must be in " + "a namespace other than " + "WSDL's.");
                wsdlExc.setLocation(XPathUtils.getXPathExprFromNode((Node)el));
            }
            ++a;
        }
        this.setLocation(attributes, el);
        return attributes;
    }

    protected PortType parsePortType(Element portTypeEl, Definition def) throws WSDLException {
        PortType portType = null;
        String name = DOMUtils.getAttribute((Element)portTypeEl, (String)"name");
        if (name != null) {
            QName portTypeName = new QName(def.getTargetNamespace(), name);
            portType = def.getPortType(portTypeName);
            if (portType == null) {
                portType = def.createPortType();
                portType.setQName(portTypeName);
            } else if (!portType.isUndefined()) {
                this.addReaderError(def, portTypeEl, this.messagegenerator.getString("_PORTTYPE_NAME_ALREADY_DEFINED", "'" + portType.getQName().getLocalPart() + "'"));
                return null;
            }
        } else {
            portType = def.createPortType();
        }
        portType.setUndefined(false);
        Element tempEl = DOMUtils.getFirstChildElement((Element)portTypeEl);
        while (tempEl != null) {
            Operation op;
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                portType.setDocumentationElement(tempEl);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_OPERATION, (Node)tempEl) && (op = this.parseOperation(tempEl, portType, def)) != null) {
                portType.addOperation(op);
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.setLocation(portType, portTypeEl);
        return portType;
    }

    protected Operation parseOperation(Element opEl, PortType portType, Definition def) throws WSDLException {
        Operation op = null;
        String name = DOMUtils.getAttribute((Element)opEl, (String)"name");
        String parameterOrderStr = DOMUtils.getAttribute((Element)opEl, (String)"parameterOrder");
        Element tempEl = DOMUtils.getFirstChildElement((Element)opEl);
        Vector<String> messageOrder = new Vector<String>();
        Element docEl = null;
        Input input = null;
        Output output = null;
        Vector<Fault> faults = new Vector<Fault>();
        ArrayList<ExtensibilityElement> extElements = new ArrayList<ExtensibilityElement>();
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                docEl = tempEl;
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_INPUT, (Node)tempEl)) {
                input = this.parseInput(tempEl, def);
                messageOrder.add("input");
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_OUTPUT, (Node)tempEl)) {
                output = this.parseOutput(tempEl, def);
                messageOrder.add("output");
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_FAULT, (Node)tempEl)) {
                faults.add(this.parseFault(tempEl, def));
            } else {
                extElements.add(this.parseExtensibilityElement(Operation.class, tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        if (name != null) {
            Output tempOut;
            Input tempIn;
            boolean opDefined;
            String outputName;
            String inputName;
            block48: {
                inputName = input != null ? input.getName() : null;
                outputName = output != null ? output.getName() : null;
                opDefined = false;
                try {
                    List operations = portType.getOperations();
                    if (operations == null) break block48;
                    Iterator iOperations = operations.iterator();
                    while (iOperations.hasNext()) {
                        boolean inputNamesEqual = false;
                        boolean outputNamesEqual = false;
                        Operation oper = (Operation)iOperations.next();
                        if (!oper.getName().equals(name)) continue;
                        Input opInput = oper.getInput();
                        if (opInput != null && input != null) {
                            String opInputName = opInput.getName();
                            if (opInputName != null && inputName != null && opInputName.equals(inputName)) {
                                inputNamesEqual = true;
                            } else if (opInputName == null && inputName == null) {
                                inputNamesEqual = true;
                            }
                        } else if (opInput == null && input == null) {
                            inputNamesEqual = true;
                        }
                        Output opOutput = oper.getOutput();
                        if (opOutput != null && output != null) {
                            String opOutputName = opOutput.getName();
                            if (opOutputName != null && outputName != null && opOutputName.equals(outputName)) {
                                outputNamesEqual = true;
                            } else if (opOutputName == null && outputName == null) {
                                outputNamesEqual = true;
                            }
                        } else if (opOutput == null && output == null) {
                            outputNamesEqual = true;
                        }
                        if (!inputNamesEqual || !outputNamesEqual) continue;
                        op = oper;
                        break;
                    }
                }
                catch (Exception exception) {
                    opDefined = true;
                }
            }
            if (op != null) {
                opDefined = true;
            }
            if (op != null && !opDefined && inputName == null && (tempIn = op.getInput()) != null && tempIn.getName() != null) {
                opDefined = true;
            }
            if (op != null && !opDefined && outputName == null && (tempOut = op.getOutput()) != null && tempOut.getName() != null) {
                opDefined = true;
            }
            if (opDefined) {
                this.setLocation(op, opEl);
                this.addReaderError(portType, op, this.messagegenerator.getString("_DUPLICATE_OPERATION_FOR_PORTTYPE", "'" + op.getName() + "'", "'" + portType.getQName().getLocalPart() + "'"));
                return null;
            }
            if (op == null) {
                op = def.createOperation();
                op.setName(name);
            }
        } else {
            op = def.createOperation();
        }
        op.setUndefined(false);
        if (parameterOrderStr != null) {
            op.setParameterOrdering(StringUtils.parseNMTokens((String)parameterOrderStr));
        }
        if (docEl != null) {
            op.setDocumentationElement(docEl);
        }
        if (input != null) {
            op.setInput(input);
        }
        if (output != null) {
            op.setOutput(output);
        }
        if (faults.size() > 0) {
            for (Fault f : faults) {
                if (op.getFault(f.getName()) == null) {
                    op.addFault(f);
                    continue;
                }
                this.addReaderError(op, f, this.messagegenerator.getString("_DUPLICATE_FAULT_NAME", "'" + f.getName() + "'", "'" + op.getName() + "'"));
            }
        }
        if (extElements.size() > 0) {
            Iterator extElementsIterator = extElements.iterator();
            while (extElementsIterator.hasNext()) {
                op.addExtensibilityElement((ExtensibilityElement)extElementsIterator.next());
            }
        }
        OperationType style = null;
        if (messageOrder.equals(STYLE_ONE_WAY)) {
            style = OperationType.ONE_WAY;
        } else if (messageOrder.equals(STYLE_REQUEST_RESPONSE)) {
            style = OperationType.REQUEST_RESPONSE;
        } else if (messageOrder.equals(STYLE_SOLICIT_RESPONSE)) {
            style = OperationType.SOLICIT_RESPONSE;
        } else if (messageOrder.equals(STYLE_NOTIFICATION)) {
            style = OperationType.NOTIFICATION;
        }
        if (style != null) {
            op.setStyle(style);
        }
        this.setLocation(op, opEl);
        return op;
    }

    protected Service parseService(Element serviceEl, Definition def) throws WSDLException {
        Service s;
        Service service = def.createService();
        String name = DOMUtils.getAttribute((Element)serviceEl, (String)"name");
        if (name != null) {
            service.setQName(new QName(def.getTargetNamespace(), name));
        }
        if ((s = def.getService(service.getQName())) != null) {
            this.addReaderError(def, serviceEl, this.messagegenerator.getString("_SERVICE_NAME_ALREADY_DEFINED", "'" + s.getQName().getLocalPart() + "'"));
            return s;
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)serviceEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                service.setDocumentationElement(tempEl);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_PORT, (Node)tempEl)) {
                service.addPort(this.parsePort(tempEl, def));
            } else {
                service.addExtensibilityElement(this.parseExtensibilityElement(Service.class, tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.setLocation(service, serviceEl);
        return service;
    }

    protected Port parsePort(Element portEl, Definition def) throws WSDLException {
        QName bindingStr;
        Port port = def.createPort();
        String name = DOMUtils.getAttribute((Element)portEl, (String)"name");
        try {
            bindingStr = DOMUtils.getQualifiedAttributeValue((Element)portEl, (String)"binding", (String)"port", (boolean)false, (Definition)def);
        }
        catch (Exception exception) {
            bindingStr = new QName(null, DOMUtils.getAttribute((Element)portEl, (String)"binding"));
        }
        if (name != null) {
            port.setName(name);
        }
        if (bindingStr != null) {
            Binding binding = def.getBinding(bindingStr);
            if (binding == null) {
                binding = def.createBinding();
                binding.setQName(bindingStr);
                def.addBinding(binding);
            }
            port.setBinding(binding);
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)portEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                port.setDocumentationElement(tempEl);
            } else {
                port.addExtensibilityElement(this.parseExtensibilityElement(Port.class, tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.setLocation(port, portEl);
        return port;
    }

    protected ExtensibilityElement parseExtensibilityElement(Class parentType, Element el, Definition def) throws WSDLException {
        QName elementType = QNameUtils.newQName((Node)el);
        try {
            ExtensionRegistry extReg = def.getExtensionRegistry();
            if (extReg == null) {
                throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionRegistry set for this Definition, so unable to deserialize a '" + elementType + "' element in the " + "context of a '" + parentType.getName() + "'.");
            }
            ExtensionDeserializer extDS = extReg.queryDeserializer(parentType, elementType);
            ExtensibilityElement extElem = extDS.unmarshall(parentType, elementType, el, def, extReg);
            this.setLocation(extElem, el);
            this.registerChildElements(extElem);
            return extElem;
        }
        catch (WSDLException e) {
            if (e.getLocation() == null) {
                e.setLocation(XPathUtils.getXPathExprFromNode((Node)el));
            }
            throw e;
        }
    }

    protected Input parseInput(Element inputEl, Definition def) throws WSDLException {
        Input input = def.createInput();
        String name = DOMUtils.getAttribute((Element)inputEl, (String)"name");
        QName messageName = null;
        try {
            messageName = DOMUtils.getQualifiedAttributeValue((Element)inputEl, (String)"message", (String)"input", (boolean)false, (Definition)def);
        }
        catch (Exception exception) {
            messageName = new QName(null, DOMUtils.getAttribute((Element)inputEl, (String)"message"));
        }
        if (name != null) {
            input.setName(name);
        }
        if (messageName != null) {
            Message message = def.getMessage(messageName);
            if (message == null) {
                message = def.createMessage();
                message.setQName(messageName);
                def.addMessage(message);
            }
            input.setMessage(message);
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)inputEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                input.setDocumentationElement(tempEl);
            } else {
                DOMUtils.throwWSDLException((Element)tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.setLocation(input, inputEl);
        return input;
    }

    protected Output parseOutput(Element outputEl, Definition def) throws WSDLException {
        Output output = def.createOutput();
        String name = DOMUtils.getAttribute((Element)outputEl, (String)"name");
        QName messageName = null;
        try {
            messageName = DOMUtils.getQualifiedAttributeValue((Element)outputEl, (String)"message", (String)"output", (boolean)false, (Definition)def);
        }
        catch (Exception exception) {
            messageName = new QName(null, DOMUtils.getAttribute((Element)outputEl, (String)"message"));
        }
        if (name != null) {
            output.setName(name);
        }
        if (messageName != null) {
            Message message = def.getMessage(messageName);
            if (message == null) {
                message = def.createMessage();
                message.setQName(messageName);
                def.addMessage(message);
            }
            output.setMessage(message);
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)outputEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                output.setDocumentationElement(tempEl);
            } else {
                DOMUtils.throwWSDLException((Element)tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.setLocation(output, outputEl);
        return output;
    }

    protected Fault parseFault(Element faultEl, Definition def) throws WSDLException {
        Fault fault = def.createFault();
        String name = DOMUtils.getAttribute((Element)faultEl, (String)"name");
        QName messageName = null;
        try {
            messageName = DOMUtils.getQualifiedAttributeValue((Element)faultEl, (String)"message", (String)"input", (boolean)false, (Definition)def);
        }
        catch (Exception exception) {
            messageName = new QName(null, DOMUtils.getAttribute((Element)faultEl, (String)"message"));
        }
        if (name != null) {
            fault.setName(name);
        }
        if (messageName != null) {
            Message message = def.getMessage(messageName);
            if (message == null) {
                message = def.createMessage();
                message.setQName(messageName);
                def.addMessage(message);
            }
            fault.setMessage(message);
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)faultEl);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)tempEl)) {
                fault.setDocumentationElement(tempEl);
            } else {
                DOMUtils.throwWSDLException((Element)tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        this.setLocation(fault, faultEl);
        return fault;
    }

    public void setMessageGenerator(MessageGenerator mg) {
        this.messagegenerator = mg;
    }

    protected void setLocation(Object refObject, Element element) {
        try {
            ElementLocation elementLocation = (ElementLocation)element.getUserData("location");
            if (elementLocation != null) {
                this.elementLocations.put(refObject, new LocationHolder(elementLocation.getLineNumber(), elementLocation.getColumnNumber(), this.def.getDocumentBaseURI()));
            }
        }
        catch (ClassCastException classCastException) {}
    }

    protected void addReaderError(Object parentobject, Object object, String error) {
        this.readerErrors.add(new ReaderError(parentobject, object, error));
    }

    protected void addReaderWarning(Object parentobject, Object object, String warning) {
        this.readerWarnings.add(new ReaderError(parentobject, object, warning));
    }

    protected void registerChildElements(ExtensibilityElement extElem) {
        if (extElem instanceof UnknownExtensibilityElement) {
            Element elem = ((UnknownExtensibilityElement)extElem).getElement();
            this.registerChildElementsRecursively(elem);
        } else if (extElem instanceof Schema) {
            Element elem = ((Schema)extElem).getElement();
            this.registerChildElementsRecursively(elem);
        }
    }

    protected void registerChildElementsRecursively(Element elem) {
        if (elem instanceof ElementNSImpl) {
            this.setLocation(elem, elem);
            NodeList childNodes = elem.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength() || i < 5) {
                Node n = childNodes.item(i);
                if (n instanceof Element) {
                    Element child = (Element)n;
                    this.registerChildElementsRecursively(child);
                }
                ++i;
            }
        }
    }

    private static void checkElementName(Element el, QName qname) throws WSDLException {
        if (!QNameUtils.matches((QName)qname, (Node)el)) {
            WSDLException wsdlExc = new WSDLException("INVALID_WSDL", "Expected element '" + qname + "'.");
            wsdlExc.setLocation(XPathUtils.getXPathExprFromNode((Node)el));
            throw wsdlExc;
        }
    }

    public Hashtable getElementLocations() {
        return this.elementLocations;
    }

    public List getReaderErrors() {
        return this.readerErrors;
    }

    public List getReaderWarnings() {
        return this.readerWarnings;
    }
}

