/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal.dnd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.navigator.ui.Messages;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.provider.J2EEItemProvider;
import org.eclipse.jst.j2ee.navigator.internal.plugin.J2EENavigatorPlugin;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class AddProjectToEARDropAssistant
extends CommonDropAdapterAssistant {
    private static final Class IPROJECT_CLASS = IProject.class;

    public boolean isSupportedType(TransferData aTransferType) {
        return LocalSelectionTransfer.getTransfer().isSupportedType(aTransferType);
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, final Object aTarget) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(aDropAdapter.getCurrentTransfer())) {
            final IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            IProject earProject = AddProjectToEARDropAssistant.getProject(aTarget);
            IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
            Job addProjectToEarJob = new Job(this.getJobTitle(earComponent)){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = null;
                    try {
                        IProject earProject = AddProjectToEARDropAssistant.getProject(aTarget);
                        ArrayList<IProject> projects = new ArrayList<IProject>();
                        for (Object sourceObject : selection) {
                            IProject projectToAdd = AddProjectToEARDropAssistant.getProject(sourceObject);
                            if (projectToAdd == null) continue;
                            projects.add(projectToAdd);
                        }
                        IDataModel dataModel = AddProjectToEARDropAssistant.this.getAddModuleDataModel(earProject, projects);
                        IDataModelOperation dropOperation = dataModel.getDefaultOperation();
                        status = dropOperation.execute(monitor, null);
                        if (!status.isOK()) {
                            return status;
                        }
                    }
                    catch (ExecutionException e) {
                        String msg = e.getMessage() != null ? e.getMessage() : e.toString();
                        status = J2EENavigatorPlugin.createErrorStatus(0, msg, e);
                    }
                    return status;
                }
            };
            service.showInDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), addProjectToEarJob);
            addProjectToEarJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            addProjectToEarJob.schedule();
        }
        return Status.OK_STATUS;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        ISelection selection;
        if ((LocalSelectionTransfer.getTransfer().isSupportedType(transferType) || PluginTransfer.getInstance().isSupportedType(transferType)) && (selection = LocalSelectionTransfer.getTransfer().getSelection()) != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            IProject earProject = AddProjectToEARDropAssistant.getProject(target);
            int earVersion = this.getEarVersion(earProject);
            IStatus status = null;
            for (Object next : structuredSelection) {
                IProject projectToAdd = AddProjectToEARDropAssistant.getProject(next);
                status = this.validateProjectMayBeAdded(earProject, projectToAdd, earVersion);
                if (!status.isOK()) continue;
                return status;
            }
        }
        return Status.CANCEL_STATUS;
    }

    private IStatus validateProjectMayBeAdded(IProject earProject, IProject projectToAdd, int earVersion) {
        if (earProject == null || projectToAdd == null || earVersion < 0) {
            return J2EENavigatorPlugin.createErrorStatus(0, Messages.AddProjectToEARDropAssistant_Could_not_add_module_to_Enterprise_, null);
        }
        if (!earProject.isAccessible()) {
            return J2EENavigatorPlugin.createErrorStatus(0, NLS.bind((String)Messages.AddProjectToEARDropAssistant_The_project_0_cannot_be_accesse_, (Object)earProject.getName()), null);
        }
        if (!projectToAdd.isAccessible()) {
            return J2EENavigatorPlugin.createErrorStatus(0, Messages.AddProjectToEARDropAssistant_The_dragged_project_cannot_be_added_, null);
        }
        if (earVersion > 14) {
            return J2EENavigatorPlugin.createErrorStatus(0, Messages.AddProjectToEARDropAssistant_Could_not_add_module_to_Enterprise_, null);
        }
        IStatus isValid = this.validateProjectToAdd(projectToAdd, earVersion);
        if (!isValid.isOK()) {
            return isValid;
        }
        return Status.OK_STATUS;
    }

    protected final int getEarVersion(IProject earProject) {
        int earVersion = -1;
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)earProject);
            IProjectFacetVersion version = facetedProject.getProjectFacetVersion(EarUtilities.ENTERPRISE_APPLICATION_FACET);
            earVersion = J2EEVersionUtil.convertVersionStringToInt((String)version.getVersionString());
        }
        catch (CoreException e) {
            J2EENavigatorPlugin.logError(0, e.getMessage(), e);
        }
        return earVersion;
    }

    protected final boolean hasEarFacet(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {}
        return facetedProject != null && facetedProject.hasProjectFacet(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET);
    }

    protected final String calculateValidProjectName(String originalName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String validName = originalName;
        int count = 1;
        while (root.getProject(validName).exists()) {
            validName = String.valueOf(originalName) + count++;
        }
        return validName;
    }

    protected IDataModel getAddModuleDataModel(IProject earProject, List projects) {
        IDataModel datamodel = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
        HashMap<IVirtualComponent, String> componentToURIMap = new HashMap<IVirtualComponent, String>();
        ArrayList<IVirtualComponent> components = new ArrayList<IVirtualComponent>();
        IVirtualComponent moduleComponent = null;
        Iterator itr = projects.iterator();
        while (itr.hasNext()) {
            moduleComponent = ComponentCore.createComponent((IProject)((IProject)itr.next()));
            components.add(moduleComponent);
            componentToURIMap.put(moduleComponent, AddProjectToEARDropAssistant.getDefaultURI(moduleComponent));
        }
        datamodel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComponent);
        datamodel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", components);
        datamodel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", componentToURIMap);
        return datamodel;
    }

    protected String getJobTitle(IVirtualComponent earComponent) {
        return NLS.bind((String)Messages.AddModuleToEarDropAssistant_Adding_module_to_ea_, (Object)earComponent.getName());
    }

    protected IStatus validateProjectToAdd(IProject projectToAdd, int earVersion) {
        try {
            int version;
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)projectToAdd);
            if (facetedProject.hasProjectFacet(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET)) {
                return Status.CANCEL_STATUS;
            }
            String verStr = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)projectToAdd);
            if (verStr != null && (version = JavaEEProjectUtilities.isApplicationClientProject((IProject)projectToAdd) ? J2EEVersionUtil.convertAppClientVersionStringToJ2EEVersionID((String)verStr) : (JavaEEProjectUtilities.isEJBProject((IProject)projectToAdd) ? J2EEVersionUtil.convertEJBVersionStringToJ2EEVersionID((String)verStr) : (JavaEEProjectUtilities.isDynamicWebProject((IProject)projectToAdd) ? J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)verStr) : (JavaEEProjectUtilities.isJCAProject((IProject)projectToAdd) ? J2EEVersionUtil.convertConnectorVersionStringToJ2EEVersionID((String)verStr) : J2EEVersionUtil.convertVersionStringToInt((String)verStr))))) > earVersion) {
                return Status.CANCEL_STATUS;
            }
        }
        catch (CoreException e) {
            String msg = e.getMessage() != null ? e.getMessage() : e.toString();
            return J2EENavigatorPlugin.createErrorStatus(0, msg, e);
        }
        return Status.OK_STATUS;
    }

    protected static IProject getProject(Object element) {
        if (element == null) {
            return null;
        }
        IProject project = null;
        project = element instanceof IAdaptable ? (IProject)((IAdaptable)element).getAdapter(IPROJECT_CLASS) : (IProject)Platform.getAdapterManager().getAdapter(element, IPROJECT_CLASS);
        if (project == null) {
            IFile associatedFile;
            if (element instanceof EObject) {
                project = ProjectUtilities.getProject((EObject)((EObject)element));
            } else if (element instanceof J2EEItemProvider && (associatedFile = ((J2EEItemProvider)element).getAssociatedFile()) != null) {
                project = associatedFile.getProject();
            }
        }
        return project;
    }

    protected static String getDefaultURI(IVirtualComponent component) {
        IProject project = component.getProject();
        String name = component.getName();
        name = JavaEEProjectUtilities.isDynamicWebProject((IProject)project) ? String.valueOf(name) + ".war" : (JavaEEProjectUtilities.isEARProject((IProject)project) ? String.valueOf(name) + ".ear" : (JavaEEProjectUtilities.isJCAProject((IProject)project) ? String.valueOf(name) + ".rar" : String.valueOf(name) + ".jar"));
        return name;
    }
}

