/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;

public class ListCharsets {
    private final String tab = "\t";

    public static void main(String[] args) {
        ListCharsets thisApp = new ListCharsets();
        System.out.println();
        System.out.println("Current Locale: " + Locale.getDefault());
        System.out.println();
        String name = System.getProperty("java.fullversion");
        if (name == null) {
            name = String.valueOf(System.getProperty("java.version")) + " (" + System.getProperty("java.runtime.version") + ")";
        }
        System.out.println("JRE version: " + name);
        System.getProperties().list(System.out);
        thisApp.listOfLocales();
        System.out.println("file.encoding.pkg: " + System.getProperty("file.encoding.pkg"));
        System.out.println("file.encoding: " + System.getProperty("file.encoding"));
        System.out.println();
        int i = 0;
        while (i < args.length) {
            System.out.println(args[i]);
            ++i;
        }
        System.out.println();
        thisApp.listOfCharsets();
    }

    private void listOfLocales() {
        System.out.println("Available Locales");
        Locale[] locales = Locale.getAvailableLocales();
        int i = 0;
        while (i < locales.length) {
            System.out.println(locales[i]);
            ++i;
        }
    }

    private void listOfCharsets() {
        System.out.println("Available Charsets");
        int count = 0;
        SortedMap<String, Charset> map = Charset.availableCharsets();
        for (String charsetName : map.keySet()) {
            System.out.println(String.valueOf(++count) + ". " + " Charsetname: " + charsetName);
            Charset charset = Charset.forName(charsetName);
            System.out.println("\tdisplayName: " + charset.displayName(Locale.getDefault()));
            Set<String> set = charset.aliases();
            System.out.println("\taliases: " + set);
        }
    }
}

