/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.tests.encoding.html;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.html.core.internal.contenttype.HTMLHeadTokenizer;
import org.eclipse.wst.html.core.internal.contenttype.HeadParserToken;
import org.eclipse.wst.html.tests.encoding.HTMLEncodingTestsPlugin;
import org.eclipse.wst.xml.tests.encoding.ZippedTest;

public class HTMLHeadTokenizerTester
extends TestCase {
    boolean DEBUG = false;
    private String fCharset;
    private String fContentTypeValue;
    private final String fileDir = "html/";
    private final String fileHome = "testfiles/";
    private final String fileLocation = String.valueOf("testfiles/") + "html/";
    private String fPageEncodingValue = null;
    private String fXMLDecEncodingName;

    private void doTestFile(String filename, String expectedName) throws IOException {
        this.doTestFile(filename, expectedName, null);
    }

    private void doTestFile(String filename, String expectedName, String finalTokenType) {
        try {
            this.doTestFile(HTMLEncodingTestsPlugin.getTestReader(filename), expectedName, finalTokenType);
        }
        catch (IOException iOException) {
            System.out.println("Error opening file \"" + filename + "\"");
        }
    }

    private void doTestFile(Reader fileReader, String expectedName, String finalTokenType) throws IOException {
        HTMLHeadTokenizer tokenizer = null;
        tokenizer = new HTMLHeadTokenizer(fileReader);
        Object resultToken = null;
        HeadParserToken token = this.parseHeader(tokenizer);
        String resultValue = this.getAppropriateEncoding();
        fileReader.close();
        if (finalTokenType != null) {
            HTMLHeadTokenizerTester.assertTrue((String)("did not end as expected. found:  " + token.getType()), (boolean)finalTokenType.equals(token.getType()));
        } else if (expectedName == null) {
            HTMLHeadTokenizerTester.assertTrue((String)("expected no encoding, but found: " + resultValue), (resultToken == null ? 1 : 0) != 0);
        } else {
            HTMLHeadTokenizerTester.assertTrue((String)("expected " + expectedName + " but found " + resultValue), (boolean)expectedName.equals(resultValue.toUpperCase()));
        }
    }

    private String getAppropriateEncoding() {
        String result = null;
        if (this.fXMLDecEncodingName != null) {
            result = this.fXMLDecEncodingName;
        } else if (this.fPageEncodingValue != null) {
            result = this.fPageEncodingValue;
        } else if (this.fCharset != null) {
            result = this.fCharset;
        }
        return result;
    }

    private boolean isLegalString(String tokenType) {
        boolean result = false;
        result = tokenType == null ? false : tokenType.equals("strval") || tokenType.equals("UnDelimitedStringValue") || tokenType.equals("InvalidTerminatedStringValue") || tokenType.equals("InvalidTermintatedUnDelimitedStringValue");
        return result;
    }

    private void parseContentTypeValue(String contentType) {
        String checkForCharset;
        Pattern pattern = Pattern.compile(";\\s*charset\\s*=\\s*");
        String[] parts = pattern.split(contentType);
        if (parts.length > 0 && parts.length == 1 && parts[0].length() > 6 && (checkForCharset = parts[0].substring(0, 7)).equalsIgnoreCase("charset")) {
            int eqpos = parts[0].indexOf(61);
            if (++eqpos < parts[0].length()) {
                this.fCharset = parts[0].substring(eqpos);
                this.fCharset = this.fCharset.trim();
            }
        }
        if (parts.length > 1) {
            this.fCharset = parts[1];
        }
    }

    private HeadParserToken parseHeader(HTMLHeadTokenizer tokenizer) throws IOException {
        this.fPageEncodingValue = null;
        this.fCharset = null;
        HeadParserToken token = null;
        HeadParserToken finalToken = null;
        do {
            String valueTokenType;
            token = tokenizer.getNextToken();
            if (this.DEBUG) {
                System.out.println(token);
            }
            String tokenType = token.getType();
            this.canHandleAsUnicodeStream(tokenType);
            if (tokenType != "MetaTagContentType" || !tokenizer.hasMoreTokens()) continue;
            HeadParserToken valueToken = tokenizer.getNextToken();
            if (this.DEBUG) {
                System.out.println(valueToken);
            }
            if (!this.isLegalString(valueTokenType = valueToken.getType())) continue;
            this.fContentTypeValue = valueToken.getText();
        } while (tokenizer.hasMoreTokens());
        if (this.fContentTypeValue != null) {
            this.parseContentTypeValue(this.fContentTypeValue);
        }
        finalToken = token;
        return finalToken;
    }

    private boolean canHandleAsUnicodeStream(String tokenType) {
        boolean canHandleAsUnicode = false;
        if (tokenType == "UTF83ByteBOM") {
            canHandleAsUnicode = true;
            this.fCharset = "UTF-8";
        } else if (tokenType == "UTF16BE" || tokenType == "UTF16LE") {
            canHandleAsUnicode = true;
            this.fCharset = "UTF-16";
        }
        return canHandleAsUnicode;
    }

    public void testBestCase() throws IOException {
        String filename = String.valueOf(this.fileLocation) + "NormalNonDefault.html";
        this.doTestFile(filename, "UTF-8");
    }

    public void testEmptyFile() throws IOException {
        String filename = String.valueOf(this.fileLocation) + "EmptyFile.html";
        this.doTestFile(filename, null);
    }

    public void testIllFormedNormalNonDefault() throws IOException {
        String filename = String.valueOf(this.fileLocation) + "IllformedNormalNonDefault.html";
        this.doTestFile(filename, "UTF-8");
    }

    public void testLargeCase() throws IOException {
        String filename = String.valueOf(this.fileLocation) + "LargeNonDefault.html";
        this.doTestFile(filename, "ISO-8859-1");
    }

    public void testLargeNoEncoding() throws IOException {
        String filename = String.valueOf(this.fileLocation) + "LargeNoEncoding.html";
        this.doTestFile(filename, null, "MAX_CHARS_REACHED");
    }

    public void testMultiNonDefault() throws IOException {
        String filename = String.valueOf(this.fileLocation) + "MultiNonDefault.html";
        this.doTestFile(filename, "ISO-8859-6");
    }

    public void testNoEncoding() throws IOException {
        String filename = String.valueOf(this.fileLocation) + "NoEncoding.html";
        this.doTestFile(filename, null);
    }

    public void testnoquotes() throws IOException {
        String filename = String.valueOf(this.fileLocation) + "noquotes.html";
        this.doTestFile(filename, "UTF-8");
    }

    public void testnoquotesUTF16le() throws IOException {
        String filename = String.valueOf(this.fileLocation) + "noquotesUTF16le.html";
        this.doTestFile(filename, "UTF-16LE");
    }

    public void testUTF16le() throws IOException {
        String filename = String.valueOf(this.fileLocation) + "utf16le.html";
        this.doTestFile(filename, "UTF-16LE");
    }

    public void testUTF16be() throws IOException {
        String filename = String.valueOf(this.fileLocation) + "utf16be.html";
        this.doTestFile(filename, "UTF-16BE");
    }

    public void testUTF16BOM() throws Exception {
        String filename = String.valueOf(this.fileLocation) + "utf16BOM.html";
        ZippedTest test = new ZippedTest();
        test.setUp();
        IFile file = test.getFile(filename);
        HTMLHeadTokenizerTester.assertNotNull((Object)file);
        FileReader fileReader = new FileReader(file.getLocationURI().getPath());
        this.doTestFile(fileReader, "UTF-16", null);
        test.shutDown();
    }
}

