/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.dataprovider;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.VirtualTableQueryFilter;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@NonNullByDefault
public class FetchParametersTest {
    private static List<Long> fTimeList = Arrays.asList(1L, 2L, 3L);
    private static List<Long> fItemList = Arrays.asList(0L, 1L, 2L);
    private static final int TABLE_COUNT = 5;
    private static final long TABLE_INDEX = 0L;
    private static Map<String, Object> fExpectedTimeQueryMap = new HashMap<String, Object>();
    private static Map<String, Object> fExpectedSelectionTimeQueryMap = new HashMap<String, Object>();
    private static Map<String, Object> fExpectedVirtualTableQueryMap = new HashMap<String, Object>();
    private TimeQueryFilter fExpectedTimeQuery = new TimeQueryFilter(fTimeList);
    private SelectionTimeQueryFilter fExpectedSelectionTimeQuery = new SelectionTimeQueryFilter(fTimeList, fItemList);
    private VirtualTableQueryFilter fExpectedVirtualTableQuery = new VirtualTableQueryFilter(fItemList, 0L, 5);

    @BeforeClass
    public static void setUp() {
        fExpectedTimeQueryMap.put("requested_times", fTimeList);
        fExpectedSelectionTimeQueryMap.put("requested_times", fTimeList);
        fExpectedSelectionTimeQueryMap.put("requested_items", fItemList);
        fExpectedVirtualTableQueryMap.put("requested_table_column_ids", fItemList);
        fExpectedVirtualTableQueryMap.put("requested_table_index", 0L);
        fExpectedVirtualTableQueryMap.put("requested_table_count", 5);
    }

    @Test
    public void testTimeQuery() {
        TimeQueryFilter timeQuery = FetchParametersUtils.createTimeQuery(fExpectedTimeQueryMap);
        Assert.assertNotNull((Object)timeQuery);
        Assert.assertEquals((Object)this.fExpectedTimeQuery, (Object)timeQuery);
        Map timeQueryMap = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)this.fExpectedTimeQuery);
        Assert.assertFalse((boolean)timeQueryMap.isEmpty());
        Assert.assertEquals(fExpectedTimeQueryMap, (Object)timeQueryMap);
    }

    @Test
    public void testSelectionTimeQuery() {
        SelectionTimeQueryFilter selectionTimeQuery = FetchParametersUtils.createSelectionTimeQuery(fExpectedSelectionTimeQueryMap);
        Assert.assertNotNull((Object)selectionTimeQuery);
        Assert.assertEquals((Object)this.fExpectedSelectionTimeQuery, (Object)selectionTimeQuery);
        Map selectionTimeQueryMap = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)this.fExpectedSelectionTimeQuery);
        Assert.assertFalse((boolean)selectionTimeQueryMap.isEmpty());
        Assert.assertEquals(fExpectedSelectionTimeQueryMap, (Object)selectionTimeQueryMap);
    }

    @Test
    public void testVirtualTableQuery() {
        VirtualTableQueryFilter virtualTableQuery = FetchParametersUtils.createVirtualTableQueryFilter(fExpectedVirtualTableQueryMap);
        Assert.assertNotNull((Object)virtualTableQuery);
        Assert.assertEquals((Object)this.fExpectedVirtualTableQuery, (Object)virtualTableQuery);
        Map virtualTableQueryMap = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)this.fExpectedVirtualTableQuery);
        Assert.assertFalse((boolean)virtualTableQueryMap.isEmpty());
        Assert.assertEquals((Object)fExpectedVirtualTableQueryMap.get("requested_table_column_ids"), virtualTableQueryMap.get("requested_table_column_ids"));
        Assert.assertEquals((Object)fExpectedVirtualTableQueryMap.get("requested_table_index"), virtualTableQueryMap.get("requested_table_index"));
        Assert.assertEquals((Object)fExpectedVirtualTableQueryMap.get("requested_table_count"), virtualTableQueryMap.get("requested_table_count"));
    }
}

