/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.chart.core.tests.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.AbstractLongResolver;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubObject;
import org.junit.Assert;
import org.junit.Test;

public class LongResolverTest {
    private static final AbstractLongResolver<StubObject> LONG_RESOLVER = new AbstractLongResolver<StubObject>(){

        public @NonNull Function<StubObject, @Nullable Long> getMapper() {
            return o -> o.getLong();
        }
    };

    @Test
    public void testLimitValues() {
        Assert.assertEquals((Object)Long.MIN_VALUE, (Object)LONG_RESOLVER.getMinValue());
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)LONG_RESOLVER.getMaxValue());
        Assert.assertEquals((Object)0L, (Object)LONG_RESOLVER.getZeroValue());
    }

    @Test
    public void testComparator() {
        ArrayList<@NonNull Long> list = new ArrayList<Long>();
        list.add(0L);
        list.add(1234L);
        list.add(-1234L);
        Collections.sort(list, LONG_RESOLVER.getComparator());
        Assert.assertEquals((Object)-1234L, list.get(0));
        Assert.assertEquals((Object)0L, list.get(1));
        Assert.assertEquals((Object)1234L, list.get(2));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testMapper() {
        @Nullable Function mapper = LONG_RESOLVER.getMapper();
        StubObject obj = new StubObject("str", 1, -1234L, 0.0);
        Assert.assertEquals((Object)-1234L, mapper.apply(obj));
        obj = new StubObject("str", 1, 0L, 0.0);
        Assert.assertEquals((Object)0L, mapper.apply(obj));
        obj = new StubObject("str", 1, 1234L, 0.0);
        Assert.assertEquals((Object)1234L, mapper.apply(obj));
    }
}

