/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem;

import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem.StateSystemTest;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class PartialStateSystemTest
extends StateSystemTest {
    private static final @NonNull String TEST_FILE_NAME = "test-partial";
    private static CtfTmfTrace fTrace;
    private static File fStateFile;
    private static TestLttngKernelAnalysisModule fModule;

    @BeforeClass
    public static void initialize() {
        fTrace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)testTrace);
        fStateFile = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)fTrace) + TEST_FILE_NAME);
        if (fStateFile.exists()) {
            fStateFile.delete();
        }
        fModule = new TestLttngKernelAnalysisModule(TEST_FILE_NAME);
        try {
            Assert.assertTrue((boolean)fModule.setTrace((ITmfTrace)fTrace));
        }
        catch (TmfAnalysisException e) {
            Assert.fail();
        }
        fModule.schedule();
        Assert.assertTrue((boolean)fModule.waitForCompletion());
        fixture = fModule.getStateSystem();
    }

    @AfterClass
    public static void cleanup() {
        if (fModule != null) {
            fModule.dispose();
        }
        if (fStateFile != null) {
            fStateFile.delete();
        }
        if (fixture != null) {
            fixture.dispose();
        }
        if (fTrace != null) {
            fTrace.dispose();
        }
        fModule = null;
        fixture = null;
        fTrace = null;
    }

    @Override
    @Test
    @Ignore
    public void testRangeQuery1() {
        super.testRangeQuery1();
    }

    @Override
    @Test
    @Ignore
    public void testRangeQuery3() {
        super.testRangeQuery3();
    }

    @Override
    @Test
    public void testFullQueryThorough() {
        super.testFullQueryThorough();
    }

    @NonNullByDefault
    private static class TestLttngKernelAnalysisModule
    extends KernelAnalysisModule {
        private final String htFileName;

        public TestLttngKernelAnalysisModule(String htFileName) {
            this.htFileName = htFileName;
        }

        public boolean setTrace(@Nullable ITmfTrace trace) throws TmfAnalysisException {
            if (!(trace instanceof CtfTmfTrace)) {
                return false;
            }
            return super.setTrace(trace);
        }

        protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
            return TmfStateSystemAnalysisModule.StateSystemBackendType.PARTIAL;
        }

        protected String getSsFileName() {
            return this.htFileName;
        }
    }
}

