/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.model.component;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.CreateSessionDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.DestroyConfirmDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.service.TestRemoteSystemProxy;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IConfirmDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ICreateSessionDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.TargetNodeConnectedCondition;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.TraceControlTestFacility;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.eclipse.tracecompass.tmf.ui.tests.shared.IWaitCondition;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TraceControlCreateSessionTest {
    private static final String TEST_STREAM = "CreateSessionTest.cfg";
    private static final String SCEN_SCENARIO_FILE_PROTO_TEST = "CreateSessionFileProto";
    private static final String SCEN_SCENARIO_CONTROL_DATA_TEST = "CreateSessionControlData";
    private static final String SCEN_SCENARIO_NETWORK_TEST = "CreateSessionNetwork";
    private static final String SCEN_SCENARIO_NETWORK2_TEST = "CreateSessionNetwork2";
    private static final String SESSION = "mysession";
    private TraceControlTestFacility fFacility;
    private IRemoteConnection fHost = TmfRemoteConnectionFactory.getLocalConnection();
    private @NonNull TestRemoteSystemProxy fProxy = new TestRemoteSystemProxy(this.fHost);
    private String fTestFile;

    @Before
    public void setUp() throws Exception {
        this.fFacility = TraceControlTestFacility.getInstance();
        this.fFacility.init();
        URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path("testfiles" + File.separator + this.getTestStream()), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        this.fTestFile = testfile.getAbsolutePath();
    }

    protected String getTestStream() {
        return TEST_STREAM;
    }

    @After
    public void tearDown() {
        this.fFacility.dispose();
    }

    @Test
    public void testTraceSessionTree() throws Exception {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        ITraceControlComponent root = this.fFacility.getControlView().getTraceControlRoot();
        TargetNodeComponent node = new TargetNodeComponent("myNode", root, (RemoteSystemProxy)this.fProxy);
        root.addChild((ITraceControlComponent)node);
        this.fFacility.waitForJobs();
        this.fFacility.executeCommand((ITraceControlComponent)node, "connect");
        WaitUtils.waitUntil((IWaitCondition)new TargetNodeConnectedCondition(node));
        Assert.assertEquals((Object)TargetNodeState.CONNECTED, (Object)node.getTargetNodeState());
        ILttngControlService controleService = node.getControlService();
        ITraceControlComponent[] groups = node.getChildren();
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)2L, (long)groups.length);
        CreateSessionDialogStub sessionDialogStub = new CreateSessionDialogStub();
        TraceControlDialogFactory.getInstance().setCreateSessionDialog((ICreateSessionDialog)sessionDialogStub);
        TraceControlDialogFactory.getInstance().setConfirmDialog((IConfirmDialog)new DestroyConfirmDialogStub());
        this.fProxy.setScenario(SCEN_SCENARIO_FILE_PROTO_TEST);
        sessionDialogStub.setNetworkUrl("file:///tmp");
        sessionDialogStub.setStreamedTrace(true);
        TraceSessionComponent session = this.fFacility.createSession(groups[1]);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)TraceControlCreateSessionTest.getSessionName(), (Object)session.getName());
        if (controleService.isVersionSupported("2.6.0")) {
            Assert.assertEquals((Object)"/tmp", (Object)session.getSessionPath());
        } else {
            Assert.assertEquals((Object)"file:///tmp", (Object)session.getSessionPath());
        }
        Assert.assertTrue((!session.isStreamedTrace() ? 1 : 0) != 0);
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
        sessionDialogStub.setNetworkUrl(null);
        sessionDialogStub.setStreamedTrace(false);
        this.fFacility.destroySession(session);
        Assert.assertEquals((long)0L, (long)groups[1].getChildren().length);
        this.fProxy.setScenario(SCEN_SCENARIO_CONTROL_DATA_TEST);
        sessionDialogStub.setControlUrl("tcp://172.0.0.1");
        sessionDialogStub.setDataUrl("tcp://172.0.0.1:5343");
        sessionDialogStub.setStreamedTrace(true);
        session = this.fFacility.createSession(groups[1]);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)TraceControlCreateSessionTest.getSessionName(), (Object)session.getName());
        if (controleService.isVersionSupported("2.6.0")) {
            Assert.assertEquals((Object)"tcp4://172.0.0.1:5342/ [data: 5343]", (Object)session.getSessionPath());
        } else {
            Assert.assertEquals((Object)"tcp://172.0.0.1:5342 [data: 5343]", (Object)session.getSessionPath());
        }
        Assert.assertTrue((boolean)session.isStreamedTrace());
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
        sessionDialogStub.setControlUrl(null);
        sessionDialogStub.setDataUrl(null);
        sessionDialogStub.setStreamedTrace(false);
        this.fFacility.destroySession(session);
        Assert.assertEquals((long)0L, (long)groups[1].getChildren().length);
        this.fProxy.setScenario(SCEN_SCENARIO_NETWORK_TEST);
        sessionDialogStub.setNetworkUrl("net://172.0.0.1:1234:2345");
        sessionDialogStub.setStreamedTrace(true);
        session = this.fFacility.createSession(groups[1]);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)TraceControlCreateSessionTest.getSessionName(), (Object)session.getName());
        if (controleService.isVersionSupported("2.6.0")) {
            Assert.assertEquals((Object)"tcp4://172.0.0.1:1234/mysession-20140820-153527 [data: 2345]", (Object)session.getSessionPath());
        } else {
            Assert.assertEquals((Object)"net://172.0.0.1:1234 [data: 2345]", (Object)session.getSessionPath());
        }
        Assert.assertTrue((boolean)session.isStreamedTrace());
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
        sessionDialogStub.setNetworkUrl(null);
        this.fFacility.destroySession(session);
        Assert.assertEquals((long)0L, (long)groups[1].getChildren().length);
        this.fProxy.setScenario(SCEN_SCENARIO_NETWORK2_TEST);
        sessionDialogStub.setNetworkUrl("net6://[ffff::eeee:dddd:cccc:0]");
        sessionDialogStub.setStreamedTrace(true);
        session = this.fFacility.createSession(groups[1]);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)TraceControlCreateSessionTest.getSessionName(), (Object)session.getName());
        if (controleService.isVersionSupported("2.6.0")) {
            Assert.assertEquals((Object)"tcp6://[ffff::eeee:dddd:cccc:0]:5342/mysession-20140820-153801 [data: 5343]", (Object)session.getSessionPath());
        } else {
            Assert.assertEquals((Object)"net://[ffff::eeee:dddd:cccc:0]:5342/mysession-20130221-144451 [data: 5343]", (Object)session.getSessionPath());
        }
        Assert.assertTrue((boolean)session.isStreamedTrace());
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
        sessionDialogStub.setNetworkUrl(null);
        this.fFacility.destroySession(session);
        Assert.assertEquals((long)0L, (long)groups[1].getChildren().length);
        this.fFacility.executeCommand((ITraceControlComponent)node, "disconnect");
        Assert.assertEquals((Object)TargetNodeState.DISCONNECTED, (Object)node.getTargetNodeState());
        this.fFacility.executeCommand((ITraceControlComponent)node, "delete");
        Assert.assertEquals((long)0L, (long)this.fFacility.getControlView().getTraceControlRoot().getChildren().length);
    }

    private static String getSessionName() {
        return SESSION;
    }
}

