/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.historytree;

import java.io.File;
import java.io.IOException;
import org.eclipse.tracecompass.datastore.core.interval.HTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.tests.historytree.AbstractHistoryTreeTestBase;
import org.eclipse.tracecompass.datastore.core.tests.stubs.historytree.HistoryTreeStub;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTNode;

public class HistoryTreeStubTest
extends AbstractHistoryTreeTestBase<HTInterval, HTNode<HTInterval>> {
    private static final HTInterval DEFAULT_OBJECT = new HTInterval(10L, 20L);

    protected HistoryTreeStub createHistoryTree(File stateHistoryFile, int blockSize, int maxChildren, int providerVersion, long treeStart) throws IOException {
        return new HistoryTreeStub(stateHistoryFile, blockSize, maxChildren, providerVersion, treeStart);
    }

    protected HistoryTreeStub createHistoryTree(File existingStateFile, int expProviderVersion) throws IOException {
        return new HistoryTreeStub(existingStateFile, expProviderVersion);
    }

    @Override
    protected long fillValues(AbstractHistoryTree<HTInterval, HTNode<HTInterval>> ht, int sizeLimit, long start) {
        int objectSize = DEFAULT_OBJECT.getSizeOnDisk();
        int nbValues = sizeLimit / objectSize;
        int i = 0;
        while (i < nbValues) {
            ht.insert((IHTInterval)new HTInterval(start + (long)i, start + (long)i + 1L));
            ++i;
        }
        return start + (long)nbValues;
    }

    @Override
    protected HTInterval createInterval(long start, long end) {
        return new HTInterval(start, end);
    }
}

