/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.compress;

public class CompressConfig {
    private long widthInPixels;
    private long heightInPixels;
    private double xLowerValue;
    private double xUpperValue;
    private double yLowerValue;
    private double yUpperValue;
    private boolean xLogScale;
    private boolean yLogScale;

    public CompressConfig() {
        this.widthInPixels = 1024L;
        this.heightInPixels = 512L;
        this.xLogScale = false;
        this.yLogScale = false;
    }

    public CompressConfig(CompressConfig config) {
        this.widthInPixels = config.getWidthInPixel();
        this.heightInPixels = config.getHeightInPixel();
        this.xLowerValue = config.getXLowerValue();
        this.xUpperValue = config.getXUpperValue();
        this.yLowerValue = config.getYLowerValue();
        this.yUpperValue = config.getYUpperValue();
        this.xLogScale = config.isXLogScale();
        this.yLogScale = config.isYLogScale();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CompressConfig)) {
            return false;
        }
        CompressConfig config = (CompressConfig)obj;
        if (this.widthInPixels != config.getWidthInPixel() || this.heightInPixels != config.getHeightInPixel()) {
            return false;
        }
        double diff = Math.abs(this.xLowerValue - config.getXLowerValue()) / (this.xUpperValue - this.xLowerValue);
        if (diff > 1.0 / (double)this.widthInPixels) {
            return false;
        }
        diff = Math.abs(this.xUpperValue - config.getXUpperValue()) / (this.xUpperValue - this.xLowerValue);
        if (diff > 1.0 / (double)this.widthInPixels) {
            return false;
        }
        diff = Math.abs(this.yLowerValue - config.getYLowerValue()) / (this.yUpperValue - this.yLowerValue);
        if (diff > 1.0 / (double)this.heightInPixels) {
            return false;
        }
        diff = Math.abs(this.yUpperValue - config.getYUpperValue()) / (this.yUpperValue - this.yLowerValue);
        if (diff > 1.0 / (double)this.heightInPixels) {
            return false;
        }
        if (config.isXLogScale() != this.xLogScale) {
            return false;
        }
        return config.isYLogScale() == this.yLogScale;
    }

    public int hashCode() {
        return 0;
    }

    public void setSizeInPixel(long width, long height) {
        this.widthInPixels = width;
        this.heightInPixels = height;
    }

    public long getWidthInPixel() {
        return this.widthInPixels;
    }

    public long getHeightInPixel() {
        return this.heightInPixels;
    }

    public void setXRange(double lower, double upper) {
        this.xLowerValue = lower;
        this.xUpperValue = upper;
    }

    public void setYRange(double lower, double upper) {
        this.yLowerValue = lower;
        this.yUpperValue = upper;
    }

    public double getXLowerValue() {
        return this.xLowerValue;
    }

    public double getXUpperValue() {
        return this.xUpperValue;
    }

    public double getYLowerValue() {
        return this.yLowerValue;
    }

    public double getYUpperValue() {
        return this.yUpperValue;
    }

    public boolean isXLogScale() {
        return this.xLogScale;
    }

    public void setXLogScale(boolean value) {
        this.xLogScale = value;
    }

    public boolean isYLogScale() {
        return this.yLogScale;
    }

    public void setYLogScale(boolean value) {
        this.yLogScale = value;
    }

    public String toString() {
        return "pixelWidth = " + this.widthInPixels + ", " + "pixelHeight = " + this.heightInPixels + ", " + "xLowerValue = " + this.xLowerValue + ", " + "xUpperValue = " + this.xUpperValue + ", " + "yLowerValue = " + this.yLowerValue + ", " + "yUpperValue = " + this.yUpperValue + ", " + this.yLogScale;
    }
}

