/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeDeclarationStringParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class TypeAliasAliasParser
implements ICommonTreeParser {
    public static final TypeAliasAliasParser INSTANCE = new TypeAliasAliasParser();

    private TypeAliasAliasParser() {
    }

    @Override
    public String parse(ICTFMetadataNode typeSpecifier, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        List<ICTFMetadataNode> children = typeSpecifier.getChildren();
        ICTFMetadataNode typeSpecifierList = null;
        ICTFMetadataNode typeDeclaratorList = null;
        ICTFMetadataNode typeDeclarator = null;
        LinkedList<ICTFMetadataNode> pointers = new LinkedList<ICTFMetadataNode>();
        for (ICTFMetadataNode child : children) {
            String type = child.getType();
            if (CTFParser.tokenNames[117].equals(type)) {
                typeSpecifierList = child;
                continue;
            }
            if (CTFParser.tokenNames[116].equals(type)) {
                typeDeclaratorList = child;
                continue;
            }
            throw TsdlUtils.childTypeError(child);
        }
        if (typeDeclaratorList != null) {
            if (typeDeclaratorList.getChildCount() != 1) {
                throw new ParseException("Only one type declarator is allowed in the typealias alias");
            }
            typeDeclarator = typeDeclaratorList.getChild(0);
            List<ICTFMetadataNode> typeDeclaratorChildren = typeDeclarator.getChildren();
            for (ICTFMetadataNode child : typeDeclaratorChildren) {
                String type = child.getType();
                if (CTFParser.tokenNames[58].equals(type)) {
                    pointers.add(child);
                    continue;
                }
                if (CTFParser.tokenNames[38].equals(type)) {
                    throw new ParseException("Identifier (" + child.getText() + ") not expected in the typealias target");
                }
                throw TsdlUtils.childTypeError(child);
            }
        }
        return TypeDeclarationStringParser.INSTANCE.parse(typeSpecifierList, new TypeDeclarationStringParser.Param(pointers));
    }
}

