/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.parser;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.core.InitializerElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceFieldElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceMethodElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;

public class SourceTypeConverter {
    public static final int FIELD = 1;
    public static final int CONSTRUCTOR = 2;
    public static final int METHOD = 4;
    public static final int MEMBER_TYPE = 8;
    public static final int FIELD_INITIALIZATION = 16;
    public static final int FIELD_AND_METHOD = 7;
    public static final int LOCAL_TYPE = 32;
    public static final int NONE = 0;
    private int flags;
    private CompilationUnitDeclaration unit;
    private Parser parser;
    private ProblemReporter problemReporter;
    private ICompilationUnit cu;
    private char[] source;
    private boolean has1_5Compliance;
    int namePos;

    private SourceTypeConverter(int flags, ProblemReporter problemReporter) {
        this.flags = flags;
        this.problemReporter = problemReporter;
        this.has1_5Compliance = problemReporter.options.complianceLevel >= 0x310000L;
    }

    public static CompilationUnitDeclaration buildCompilationUnit(ISourceType[] sourceTypes, int flags, ProblemReporter problemReporter, CompilationResult compilationResult) {
        SourceTypeConverter converter = new SourceTypeConverter(flags, problemReporter);
        try {
            return converter.convert(sourceTypes, compilationResult);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    private CompilationUnitDeclaration convert(ISourceType[] sourceTypes, CompilationResult compilationResult) throws JavaScriptModelException {
        this.unit = new CompilationUnitDeclaration(this.problemReporter, compilationResult, 0);
        if (sourceTypes.length == 0) {
            return this.unit;
        }
        SourceTypeElementInfo topLevelTypeInfo = (SourceTypeElementInfo)sourceTypes[0];
        IJavaScriptUnit cuHandle = topLevelTypeInfo.getHandle().getJavaScriptUnit();
        this.cu = (ICompilationUnit)((Object)cuHandle);
        return new Parser(this.problemReporter, true).dietParse(this.cu, compilationResult);
    }

    private void addIdentifiers(String typeSignature, int start, int endExclusive, int identCount, ArrayList fragments) {
        if (identCount == 1) {
            char[] identifier = new char[endExclusive - start];
            typeSignature.getChars(start, endExclusive, identifier, 0);
            fragments.add(identifier);
        } else {
            fragments.add(this.extractIdentifiers(typeSignature, start, endExclusive - 1, identCount));
        }
    }

    private Initializer convert(InitializerElementInfo initializerInfo, CompilationResult compilationResult) throws JavaScriptModelException {
        Block block = new Block(0);
        Initializer initializer = new Initializer(block, 0);
        int start = initializerInfo.getDeclarationSourceStart();
        int end = initializerInfo.getDeclarationSourceEnd();
        initializer.sourceStart = initializer.declarationSourceStart = start;
        initializer.sourceEnd = initializer.declarationSourceEnd = end;
        initializer.modifiers = initializerInfo.getModifiers();
        IJavaScriptElement[] children = initializerInfo.getChildren();
        int typesLength = children.length;
        if (typesLength > 0) {
            Statement[] statements = new Statement[typesLength];
            int i = 0;
            while (i < typesLength) {
                SourceType type = (SourceType)children[i];
                TypeDeclaration localType = this.convert(type, compilationResult);
                if ((localType.bits & 0x200) != 0) {
                    QualifiedAllocationExpression expression = new QualifiedAllocationExpression(localType);
                    expression.type = localType.superclass;
                    localType.superclass = null;
                    localType.allocation = expression;
                    statements[i] = expression;
                } else {
                    statements[i] = localType;
                }
                ++i;
            }
            block.statements = statements;
        }
        return initializer;
    }

    private FieldDeclaration convert(SourceField fieldHandle, TypeDeclaration type, CompilationResult compilationResult) throws JavaScriptModelException {
        char[] initializationSource;
        int modifiers;
        SourceFieldElementInfo fieldInfo = (SourceFieldElementInfo)fieldHandle.getElementInfo();
        FieldDeclaration field = new FieldDeclaration();
        int start = fieldInfo.getNameSourceStart();
        int end = fieldInfo.getNameSourceEnd();
        field.name = fieldHandle.getElementName().toCharArray();
        field.sourceStart = start;
        field.sourceEnd = end;
        field.declarationSourceStart = fieldInfo.getDeclarationSourceStart();
        field.declarationSourceEnd = fieldInfo.getDeclarationSourceEnd();
        field.modifiers = modifiers = fieldInfo.getModifiers();
        field.type = this.createTypeReference(fieldInfo.getTypeName(), start, end);
        if ((this.flags & 0x10) != 0 && (initializationSource = fieldInfo.getInitializationSource()) != null) {
            if (this.parser == null) {
                this.parser = new Parser(this.problemReporter, true);
            }
            this.parser.parse(field, type, this.unit, initializationSource);
        }
        if ((this.flags & 0x20) != 0) {
            IJavaScriptElement[] children = fieldInfo.getChildren();
            int childrenLength = children.length;
            if (childrenLength == 1) {
                field.initialization = this.convert(children[0], null, compilationResult);
            } else if (childrenLength > 1) {
                ArrayInitializer initializer = new ArrayInitializer();
                field.initialization = initializer;
                Expression[] expressions = new Expression[childrenLength];
                initializer.expressions = expressions;
                int i = 0;
                while (i < childrenLength) {
                    expressions[i] = this.convert(children[i], null, compilationResult);
                    ++i;
                }
            }
        }
        return field;
    }

    private QualifiedAllocationExpression convert(IJavaScriptElement localType, FieldDeclaration enumConstant, CompilationResult compilationResult) throws JavaScriptModelException {
        TypeDeclaration anonymousLocalTypeDeclaration = this.convert((SourceType)localType, compilationResult);
        QualifiedAllocationExpression expression = new QualifiedAllocationExpression(anonymousLocalTypeDeclaration);
        expression.type = anonymousLocalTypeDeclaration.superclass;
        anonymousLocalTypeDeclaration.superclass = null;
        anonymousLocalTypeDeclaration.allocation = expression;
        if (enumConstant != null) {
            expression.type = null;
        }
        return expression;
    }

    private AbstractMethodDeclaration convert(SourceMethod methodHandle, SourceMethodElementInfo methodInfo, CompilationResult compilationResult) throws JavaScriptModelException {
        IJavaScriptElement[] children;
        int typesLength;
        int argumentCount;
        AbstractMethodDeclaration method;
        AbstractMethodDeclaration decl;
        int start = methodInfo.getNameSourceStart();
        int end = methodInfo.getNameSourceEnd();
        int modifiers = methodInfo.getModifiers();
        if (methodInfo.isConstructor()) {
            decl = new ConstructorDeclaration(compilationResult);
            ((ConstructorDeclaration)decl).isDefaultConstructor = false;
            method = decl;
        } else {
            decl = new MethodDeclaration(compilationResult);
            ((MethodDeclaration)decl).returnType = this.createTypeReference(methodInfo.getReturnTypeName(), start, end);
            method = decl;
        }
        method.setSelector(methodHandle.getElementName().toCharArray());
        boolean isVarargs = (modifiers & 0x80) != 0;
        method.modifiers = modifiers & 0xFFFFFF7F;
        method.sourceStart = start;
        method.sourceEnd = end;
        method.declarationSourceStart = methodInfo.getDeclarationSourceStart();
        method.declarationSourceEnd = methodInfo.getDeclarationSourceEnd();
        String[] argumentTypeSignatures = methodHandle.getParameterTypes();
        char[][] argumentNames = methodInfo.getArgumentNames();
        int n = argumentCount = argumentTypeSignatures == null ? 0 : argumentTypeSignatures.length;
        if (argumentCount > 0) {
            long position = ((long)start << 32) + (long)end;
            method.arguments = new Argument[argumentCount];
            int i = 0;
            while (i < argumentCount) {
                TypeReference typeReference = this.createTypeReference(argumentTypeSignatures[i], start, end);
                if (isVarargs && i == argumentCount - 1) {
                    typeReference.bits |= 0x4000;
                }
                method.arguments[i] = new Argument(argumentNames[i], position, typeReference, 0);
                ++i;
            }
        }
        if ((this.flags & 0x20) != 0 && (typesLength = (children = methodInfo.getChildren()).length) != 0) {
            Statement[] statements = new Statement[typesLength];
            int i = 0;
            while (i < typesLength) {
                SourceType type = (SourceType)children[i];
                TypeDeclaration localType = this.convert(type, compilationResult);
                if ((localType.bits & 0x200) != 0) {
                    QualifiedAllocationExpression expression = new QualifiedAllocationExpression(localType);
                    expression.type = localType.superclass;
                    localType.superclass = null;
                    localType.allocation = expression;
                    statements[i] = expression;
                } else {
                    statements[i] = localType;
                }
                ++i;
            }
            method.statements = statements;
        }
        return method;
    }

    private TypeDeclaration convert(SourceType typeHandle, CompilationResult compilationResult) throws JavaScriptModelException {
        boolean needMethod;
        int length;
        int end;
        int start;
        SourceTypeElementInfo typeInfo = (SourceTypeElementInfo)typeHandle.getElementInfo();
        if (typeInfo.isAnonymousMember()) {
            throw new AnonymousMemberFound();
        }
        TypeDeclaration type = new TypeDeclaration(compilationResult);
        if (typeInfo.getEnclosingType() == null) {
            if (typeHandle.isAnonymous()) {
                type.name = CharOperation.NO_CHAR;
                type.bits |= 0x300;
            } else if (typeHandle.isLocal()) {
                type.bits |= 0x100;
            }
        } else {
            type.bits |= 0x400;
        }
        if ((type.bits & 0x200) == 0) {
            type.name = typeInfo.getName();
        }
        type.name = typeInfo.getName();
        type.sourceStart = start = typeInfo.getNameSourceStart();
        type.sourceEnd = end = typeInfo.getNameSourceEnd();
        type.modifiers = typeInfo.getModifiers();
        type.declarationSourceStart = typeInfo.getDeclarationSourceStart();
        type.bodyEnd = type.declarationSourceEnd = typeInfo.getDeclarationSourceEnd();
        if (typeInfo.getSuperclassName() != null) {
            type.superclass = this.createTypeReference(typeInfo.getSuperclassName(), start, end);
            type.superclass.bits |= 0x10;
        }
        if ((this.flags & 8) != 0) {
            SourceType[] sourceMemberTypes = typeInfo.getMemberTypeHandles();
            int sourceMemberTypeCount = sourceMemberTypes.length;
            type.memberTypes = new TypeDeclaration[sourceMemberTypeCount];
            int i = 0;
            while (i < sourceMemberTypeCount) {
                type.memberTypes[i] = this.convert(sourceMemberTypes[i], compilationResult);
                ++i;
            }
        }
        InitializerElementInfo[] initializers = null;
        int initializerCount = 0;
        if ((this.flags & 0x20) != 0) {
            initializers = typeInfo.getInitializers();
            initializerCount = initializers.length;
        }
        SourceField[] sourceFields = null;
        int sourceFieldCount = 0;
        if ((this.flags & 1) != 0) {
            sourceFields = typeInfo.getFieldHandles();
            sourceFieldCount = sourceFields.length;
        }
        if ((length = initializerCount + sourceFieldCount) > 0) {
            type.fields = new FieldDeclaration[length];
            int i = 0;
            while (i < initializerCount) {
                type.fields[i] = this.convert(initializers[i], compilationResult);
                ++i;
            }
            int index = 0;
            int i2 = initializerCount;
            while (i2 < length) {
                type.fields[i2] = this.convert(sourceFields[index++], type, compilationResult);
                ++i2;
            }
        }
        boolean needConstructor = (this.flags & 2) != 0;
        boolean bl = needMethod = (this.flags & 4) != 0;
        if (needConstructor || needMethod) {
            SourceMethod[] sourceMethods = typeInfo.getMethodHandles();
            int sourceMethodCount = sourceMethods.length;
            int extraConstructor = 0;
            int methodCount = 0;
            TypeDeclaration.kind(type.modifiers);
            extraConstructor = needConstructor ? 1 : 0;
            int i = 0;
            while (i < sourceMethodCount) {
                if (sourceMethods[i].isConstructor()) {
                    if (needConstructor) {
                        extraConstructor = 0;
                        ++methodCount;
                    }
                } else if (needMethod) {
                    ++methodCount;
                }
                ++i;
            }
            type.methods = new AbstractMethodDeclaration[methodCount + extraConstructor];
            if (extraConstructor != 0) {
                type.methods[0] = type.createDefaultConstructor(false, false);
            }
            int index = 0;
            boolean hasAbstractMethods = false;
            int i3 = 0;
            while (i3 < sourceMethodCount) {
                SourceMethod sourceMethod = sourceMethods[i3];
                SourceMethodElementInfo methodInfo = (SourceMethodElementInfo)sourceMethod.getElementInfo();
                boolean isConstructor = methodInfo.isConstructor();
                if ((methodInfo.getModifiers() & 0x400) != 0) {
                    hasAbstractMethods = true;
                }
                if (isConstructor && needConstructor || !isConstructor && needMethod) {
                    AbstractMethodDeclaration method = this.convert(sourceMethod, methodInfo, compilationResult);
                    if (method.isAbstract()) {
                        method.modifiers |= 0x1000000;
                    }
                    type.methods[extraConstructor + index++] = method;
                }
                ++i3;
            }
            if (hasAbstractMethods) {
                type.bits |= 0x800;
            }
        }
        return type;
    }

    private ImportReference createImportReference(String[] importName, int start, int end, boolean onDemand) {
        int length = importName.length;
        long[] positions = new long[length];
        long position = ((long)start << 32) + (long)end;
        char[][] qImportName = new char[length][];
        int i = 0;
        while (i < length) {
            qImportName[i] = importName[i].toCharArray();
            positions[i] = position;
            ++i;
        }
        return new ImportReference(qImportName, positions, onDemand);
    }

    private TypeReference createTypeReference(char[] typeName, int start, int end) {
        int length = typeName.length;
        this.namePos = 0;
        return this.decodeType(typeName, length, start, end);
    }

    private TypeReference createTypeReference(String typeSignature, int start, int end) {
        int length = typeSignature.length();
        this.namePos = 0;
        return this.decodeType(typeSignature, length, start, end);
    }

    /*
     * Unable to fully structure code
     */
    private TypeReference decodeType(String typeSignature, int length, int start, int end) {
        identCount = 1;
        dim = 0;
        nameFragmentStart = this.namePos;
        nameFragmentEnd = -1;
        nameStarted = false;
        fragments = null;
        block7: while (this.namePos < length) {
            currentChar = typeSignature.charAt(this.namePos);
            switch (currentChar) {
                case 'V': {
                    if (!nameStarted) {
                        ++this.namePos;
                        new SingleTypeReference(TypeBinding.VOID.simpleName, ((long)start << 32) + (long)end);
                    }
                    ** GOTO lbl34
                }
                case 'L': 
                case 'Q': {
                    if (!nameStarted) {
                        nameFragmentStart = this.namePos + 1;
                        nameStarted = true;
                    }
                    ** GOTO lbl34
                }
                case '[': {
                    ++dim;
                    ** GOTO lbl34
                }
                case ';': {
                    nameFragmentEnd = this.namePos - 1;
                    ++this.namePos;
                    break block7;
                }
                case '$': 
                case '.': {
                    if (nameStarted) ** GOTO lbl32
                    nameFragmentStart = this.namePos + 1;
                    nameStarted = true;
                    ** GOTO lbl34
lbl32:
                    // 1 sources

                    if (this.namePos > nameFragmentStart) {
                        ++identCount;
                    }
                }
lbl34:
                // 8 sources

                default: {
                    ++this.namePos;
                }
            }
        }
        if (fragments == null) {
            if (identCount == 1) {
                if (dim == 0) {
                    nameFragment = new char[nameFragmentEnd - nameFragmentStart + 1];
                    typeSignature.getChars(nameFragmentStart, nameFragmentEnd + 1, nameFragment, 0);
                    return new SingleTypeReference(nameFragment, ((long)start << 32) + (long)end);
                }
                nameFragment = new char[nameFragmentEnd - nameFragmentStart + 1];
                typeSignature.getChars(nameFragmentStart, nameFragmentEnd + 1, nameFragment, 0);
                return new ArrayTypeReference(nameFragment, dim, ((long)start << 32) + (long)end);
            }
            positions = new long[identCount];
            pos = ((long)start << 32) + (long)end;
            i = 0;
            while (i < identCount) {
                positions[i] = pos;
                ++i;
            }
            identifiers = this.extractIdentifiers(typeSignature, nameFragmentStart, nameFragmentEnd, identCount);
            if (dim == 0) {
                return new QualifiedTypeReference(identifiers, positions);
            }
            return new ArrayQualifiedTypeReference(identifiers, dim, positions);
        }
        if (nameStarted) {
            this.addIdentifiers(typeSignature, nameFragmentStart, nameFragmentEnd + 1, identCount, fragments);
        }
        if ((fragmentLength = fragments.size()) == 2 && (firstFragment = fragments.get(0)) instanceof char[]) {
            return null;
        }
        identCount = 0;
        i = 0;
        while (i < fragmentLength) {
            element = fragments.get(i);
            if (element instanceof char[][]) {
                identCount += ((char[][])element).length;
            } else if (element instanceof char[]) {
                ++identCount;
            }
            ++i;
        }
        tokens = new char[identCount][];
        arguments = new TypeReference[identCount][];
        index = 0;
        i = 0;
        while (i < fragmentLength) {
            element = fragments.get(i);
            if (element instanceof char[][]) {
                fragmentTokens = (char[][])element;
                fragmentTokenLength = fragmentTokens.length;
                System.arraycopy(fragmentTokens, 0, tokens, index, fragmentTokenLength);
                index += fragmentTokenLength;
            } else if (element instanceof char[]) {
                tokens[index++] = (char[])element;
            } else {
                arguments[index - 1] = (TypeReference[])element;
            }
            ++i;
        }
        positions = new long[identCount];
        pos = ((long)start << 32) + (long)end;
        i = 0;
        while (i < identCount) {
            positions[i] = pos;
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private TypeReference decodeType(char[] typeName, int length, int start, int end) {
        identCount = 1;
        dim = 0;
        nameFragmentStart = this.namePos;
        nameFragmentEnd = -1;
        fragments = null;
        block11: while (this.namePos < length) {
            currentChar = typeName[this.namePos];
            switch (currentChar) {
                case '?': {
                    ++this.namePos;
                    while (typeName[this.namePos] == ' ') {
                        ++this.namePos;
                    }
                    switch (typeName[this.namePos]) {
                        case 's': {
                            break;
                        }
                    }
                }
                case '[': {
                    if (dim == 0) {
                        nameFragmentEnd = this.namePos - 1;
                    }
                    ++dim;
                    ** GOTO lbl46
                }
                case ']': {
                    ** GOTO lbl46
                }
                case ',': 
                case '>': {
                    break block11;
                }
                case '.': {
                    if (nameFragmentStart < 0) {
                        nameFragmentStart = this.namePos + 1;
                    }
                    ++identCount;
                    ** GOTO lbl46
                }
                case '<': {
                    if (!this.has1_5Compliance) break block11;
                    if (fragments == null) {
                        fragments = new ArrayList<Object>(2);
                    }
                    nameFragmentEnd = this.namePos - 1;
                    identifiers = CharOperation.splitOn('.', typeName, nameFragmentStart, this.namePos);
                    fragments.add(identifiers);
                    ++this.namePos;
                    arguments = this.decodeTypeArguments(typeName, length, start, end);
                    fragments.add(arguments);
                    identCount = 0;
                    nameFragmentStart = -1;
                    nameFragmentEnd = -1;
                }
lbl46:
                // 5 sources

                default: {
                    ++this.namePos;
                }
            }
        }
        if (nameFragmentEnd < 0) {
            nameFragmentEnd = this.namePos - 1;
        }
        if (fragments == null) {
            if (identCount == 1) {
                if (dim == 0) {
                    if (nameFragmentStart != 0 || nameFragmentEnd >= 0) {
                        nameFragmentLength = nameFragmentEnd - nameFragmentStart + 1;
                        nameFragment = new char[nameFragmentLength];
                        System.arraycopy(typeName, nameFragmentStart, nameFragment, 0, nameFragmentLength);
                    } else {
                        nameFragment = typeName;
                    }
                    return new SingleTypeReference(nameFragment, ((long)start << 32) + (long)end);
                }
                nameFragmentLength = nameFragmentEnd - nameFragmentStart + 1;
                nameFragment = new char[nameFragmentLength];
                System.arraycopy(typeName, nameFragmentStart, nameFragment, 0, nameFragmentLength);
                return new ArrayTypeReference(nameFragment, dim, ((long)start << 32) + (long)end);
            }
            positions = new long[identCount];
            pos = ((long)start << 32) + (long)end;
            i = 0;
            while (i < identCount) {
                positions[i] = pos;
                ++i;
            }
            identifiers = CharOperation.splitOn('.', typeName, nameFragmentStart, nameFragmentEnd + 1);
            if (dim == 0) {
                return new QualifiedTypeReference(identifiers, positions);
            }
            return new ArrayQualifiedTypeReference(identifiers, dim, positions);
        }
        if (nameFragmentStart > 0 && nameFragmentStart < length) {
            identifiers = CharOperation.splitOn('.', typeName, nameFragmentStart, nameFragmentEnd + 1);
            fragments.add(identifiers);
        }
        if ((fragmentLength = fragments.size()) == 2 && (firstFragment = (char[][])fragments.get(0)).length == 1) {
            return null;
        }
        identCount = 0;
        i = 0;
        while (i < fragmentLength) {
            element = fragments.get(i);
            if (element instanceof char[][]) {
                identCount += ((char[][])element).length;
            }
            ++i;
        }
        tokens = new char[identCount][];
        arguments = new TypeReference[identCount][];
        index = 0;
        i = 0;
        while (i < fragmentLength) {
            element = fragments.get(i);
            if (element instanceof char[][]) {
                fragmentTokens = (char[][])element;
                fragmentTokenLength = fragmentTokens.length;
                System.arraycopy(fragmentTokens, 0, tokens, index, fragmentTokenLength);
                index += fragmentTokenLength;
            } else {
                arguments[index - 1] = (TypeReference[])element;
            }
            ++i;
        }
        positions = new long[identCount];
        pos = ((long)start << 32) + (long)end;
        i = 0;
        while (i < identCount) {
            positions[i] = pos;
            ++i;
        }
        return null;
    }

    private TypeReference[] decodeTypeArguments(char[] typeName, int length, int start, int end) {
        ArrayList<TypeReference> argumentList = new ArrayList<TypeReference>(1);
        int count = 0;
        while (this.namePos < length) {
            TypeReference argument = this.decodeType(typeName, length, start, end);
            ++count;
            argumentList.add(argument);
            if (this.namePos >= length || typeName[this.namePos] == '>') break;
            ++this.namePos;
        }
        TypeReference[] typeArguments = new TypeReference[count];
        argumentList.toArray(typeArguments);
        return typeArguments;
    }

    private TypeReference[] decodeTypeArguments(String typeSignature, int length, int start, int end) {
        ArrayList<TypeReference> argumentList = new ArrayList<TypeReference>(1);
        int count = 0;
        while (this.namePos < length) {
            TypeReference argument = this.decodeType(typeSignature, length, start, end);
            ++count;
            argumentList.add(argument);
            if (this.namePos >= length || typeSignature.charAt(this.namePos) == '>') break;
        }
        TypeReference[] typeArguments = new TypeReference[count];
        argumentList.toArray(typeArguments);
        return typeArguments;
    }

    private char[][] extractIdentifiers(String typeSignature, int start, int endInclusive, int identCount) {
        char[][] result = new char[identCount][];
        int charIndex = start;
        int i = 0;
        while (charIndex < endInclusive) {
            if (typeSignature.charAt(charIndex) == '.') {
                int n = i++;
                char[] cArray = new char[charIndex - start];
                result[n] = cArray;
                typeSignature.getChars(start, charIndex, cArray, 0);
                start = ++charIndex;
                continue;
            }
            ++charIndex;
        }
        int n = i++;
        char[] cArray = new char[charIndex - start + 1];
        result[n] = cArray;
        typeSignature.getChars(start, charIndex + 1, cArray, 0);
        return result;
    }

    private char[] getSource() {
        if (this.source == null) {
            this.source = this.cu.getContents();
        }
        return this.source;
    }

    private Expression parseMemberValue(char[] memberValue) {
        if (this.parser == null) {
            this.parser = new Parser(this.problemReporter, true);
        }
        return this.parser.parseMemberValue(memberValue, 0, memberValue.length, this.unit);
    }

    static class AnonymousMemberFound
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        AnonymousMemberFound() {
        }
    }
}

