/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.stickyscroll;

import java.time.Duration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Throttler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.stickyscroll.DefaultStickyLinesProvider;
import org.eclipse.ui.internal.texteditor.stickyscroll.IStickyLine;
import org.eclipse.ui.internal.texteditor.stickyscroll.IStickyLinesProvider;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyScrollingControl;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyScrollingControlSettings;

public class StickyScrollingHandler
implements IViewportListener {
    private static final int THROTTLER_DELAY = 100;
    private ISourceViewer sourceViewer;
    private StickyScrollingControl stickyScrollingControl;
    private IPropertyChangeListener propertyChangeListener;
    private IPreferenceStore preferenceStore;
    private IStickyLinesProvider stickyLinesProvider;
    private IStickyLinesProvider.StickyLinesProperties stickyLinesProperties;
    private Throttler throttler;
    private int verticalOffset;

    public StickyScrollingHandler(ISourceViewer sourceViewer, IVerticalRuler verticalRuler, IPreferenceStore preferenceStore) {
        this(sourceViewer, verticalRuler, preferenceStore, new DefaultStickyLinesProvider());
    }

    public StickyScrollingHandler(ISourceViewer sourceViewer, IVerticalRuler verticalRuler, IPreferenceStore preferenceStore, IStickyLinesProvider stickyLinesProvider) {
        this.sourceViewer = sourceViewer;
        this.throttler = new Throttler(sourceViewer.getTextWidget().getDisplay(), Duration.ofMillis(100L), this::calculateAndShowStickyLines);
        this.stickyLinesProvider = stickyLinesProvider;
        this.listenForPropertiesChanges(preferenceStore);
        this.stickyLinesProperties = this.loadStickyLinesProperties(preferenceStore);
        StickyScrollingControlSettings settings = this.loadControlSettings(preferenceStore);
        this.stickyScrollingControl = new StickyScrollingControl(sourceViewer, verticalRuler, settings, this);
        sourceViewer.addViewportListener((IViewportListener)this);
    }

    private void listenForPropertiesChanges(IPreferenceStore store) {
        this.preferenceStore = store;
        this.propertyChangeListener = e -> {
            if ((e.getProperty().equals("tabWidth") || e.getProperty().equals("stickyScrollingMaximumCount") || e.getProperty().equals("currentLineColor") || e.getProperty().equals("lineNumberRuler") || e.getProperty().equals("org.eclipse.ui.editors.stickyLinesSeparatorColor")) && this.stickyScrollingControl != null && !this.sourceViewer.getTextWidget().isDisposed()) {
                StickyScrollingControlSettings settings = this.loadControlSettings(this.preferenceStore);
                this.stickyScrollingControl.applySettings(settings);
                this.stickyLinesProperties = this.loadStickyLinesProperties(this.preferenceStore);
            }
        };
        store.addPropertyChangeListener(this.propertyChangeListener);
    }

    private StickyScrollingControlSettings loadControlSettings(IPreferenceStore store) {
        int stickyScrollingMaxCount = store.getInt("stickyScrollingMaximumCount");
        Color lineNumberColor = new Color(PreferenceConverter.getColor((IPreferenceStore)store, (String)"lineNumberColor"));
        Color stickyLineHoverColor = new Color(PreferenceConverter.getColor((IPreferenceStore)store, (String)"currentLineColor"));
        Color stickyLineBackgroundColor = this.sourceViewer.getTextWidget().getBackground();
        boolean showLineNumbers = store.getBoolean("lineNumberRuler");
        Color stickyLineSeparatorColor = null;
        if (EditorsPlugin.getDefault() != null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"org.eclipse.ui.editors.stickyLinesSeparatorColor");
            ISharedTextColors sharedTextColors = EditorsPlugin.getDefault().getSharedTextColors();
            stickyLineSeparatorColor = sharedTextColors.getColor(rgb);
        }
        return new StickyScrollingControlSettings(stickyScrollingMaxCount, lineNumberColor, stickyLineHoverColor, stickyLineBackgroundColor, stickyLineSeparatorColor, showLineNumbers);
    }

    private IStickyLinesProvider.StickyLinesProperties loadStickyLinesProperties(IPreferenceStore store) {
        int tabWidth = store.getInt("tabWidth");
        return new IStickyLinesProvider.StickyLinesProperties(tabWidth);
    }

    public void viewportChanged(int newVerticalOffset) {
        if (this.verticalOffset == newVerticalOffset) {
            return;
        }
        this.verticalOffset = newVerticalOffset;
        this.throttler.throttledExec();
    }

    private void calculateAndShowStickyLines() {
        List<IStickyLine> stickyLines = Collections.emptyList();
        int startLine = this.sourceViewer.getTopIndex();
        if (startLine > 0) {
            stickyLines = this.stickyLinesProvider.getStickyLines(this.sourceViewer, this.sourceViewer.getTopIndex(), this.stickyLinesProperties);
        }
        if (stickyLines == null) {
            stickyLines = Collections.emptyList();
        }
        stickyLines = this.adaptStickyLinesToVisibleArea(stickyLines, startLine);
        this.stickyScrollingControl.setStickyLines(stickyLines);
    }

    private List<IStickyLine> adaptStickyLinesToVisibleArea(List<IStickyLine> stickyLines, int startLine) {
        if (stickyLines.isEmpty()) {
            return stickyLines;
        }
        LinkedList<IStickyLine> adaptedStickyLines = new LinkedList<IStickyLine>(stickyLines);
        int firstVisibleLine = startLine + adaptedStickyLines.size();
        int numberOfLines = this.sourceViewer.getDocument().getNumberOfLines();
        int i = startLine + 1;
        while (i <= firstVisibleLine && i < numberOfLines) {
            List<IStickyLine> stickyLinesInLineI = this.stickyLinesProvider.getStickyLines(this.sourceViewer, i, this.stickyLinesProperties);
            if (stickyLinesInLineI.size() > adaptedStickyLines.size()) {
                adaptedStickyLines = new LinkedList<IStickyLine>(stickyLinesInLineI);
                firstVisibleLine = startLine + adaptedStickyLines.size();
            }
            while (stickyLinesInLineI.size() < adaptedStickyLines.size() && i < firstVisibleLine) {
                adaptedStickyLines.removeLast();
                --firstVisibleLine;
            }
            ++i;
        }
        return adaptedStickyLines;
    }

    public void uninstall() {
        this.sourceViewer.removeViewportListener((IViewportListener)this);
        this.preferenceStore.removePropertyChangeListener(this.propertyChangeListener);
        this.preferenceStore = null;
        this.throttler = null;
        this.stickyScrollingControl.dispose();
    }
}

