/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.uftrace.core.trace;

import com.google.common.collect.PeekingIterator;
import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.DatEvent;

public class DatParser
implements Iterable<DatEvent> {
    private long fUtcOffset;
    private final File fFile;
    private final long fStart;

    public DatParser(File file) {
        this(file, 0L, 0L);
    }

    public DatParser(File file, long start, long utcOffset) {
        this.fFile = file;
        this.fStart = start;
        this.fUtcOffset = utcOffset;
    }

    @Override
    public PeekingIterator<DatEvent> iterator() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileChannel fc = FileChannel.open(this.fFile.toPath(), StandardOpenOption.READ);){
                final MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, this.fStart, fc.size());
                if (bb == null) {
                    throw new IllegalStateException("cannot create a byte buffer!");
                }
                return new PeekingIterator<DatEvent>(){
                    DatEvent fCurrent = null;

                    public DatEvent next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException("no more data");
                        }
                        this.fCurrent = DatEvent.create(bb, NumberUtils.toInt((String)DatParser.this.fFile.getName().substring(0, DatParser.this.fFile.getName().length() - 4)), DatParser.this.fUtcOffset);
                        return this.fCurrent;
                    }

                    public boolean hasNext() {
                        return bb.remaining() > 16;
                    }

                    public DatEvent peek() {
                        if (this.fCurrent == null && this.hasNext()) {
                            return this.next();
                        }
                        return this.fCurrent;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("can't");
                    }
                };
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setUtcOffset(long utcOffset) {
        this.fUtcOffset = utcOffset;
    }
}

