/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.rocm.core.trace.old.RocmTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class HostThreadIdentifier {
    private final int fApiId;
    private final int fThreadId;
    private final int fCategoryId;

    private HostThreadIdentifier(int apiId, int threadId, int categoryId) {
        this.fApiId = apiId;
        this.fThreadId = threadId;
        this.fCategoryId = categoryId;
    }

    public HostThreadIdentifier() {
        this(0, 0, ROCM_CATEGORY.MEMORY.ordinal());
    }

    public HostThreadIdentifier(int categoryId, KERNEL_CATEGORY category, int gpuId) {
        this(categoryId, category.ordinal(), gpuId + ROCM_CATEGORY.values().length);
    }

    public HostThreadIdentifier(ITmfEvent event, int tid) {
        this(((RocmTrace)event.getTrace()).getApiId(event.getName()), tid, ROCM_CATEGORY.SYSTEM.ordinal());
    }

    public int hashCode() {
        return Objects.hash(this.fApiId, this.fThreadId, this.fCategoryId);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        HostThreadIdentifier that = (HostThreadIdentifier)other;
        return this.fApiId == that.fApiId && this.fThreadId == that.fThreadId && this.fCategoryId == that.fCategoryId;
    }

    public static enum KERNEL_CATEGORY {
        QUEUE,
        STREAM;

    }

    public static enum ROCM_CATEGORY {
        SYSTEM,
        MEMORY;

    }
}

