/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.propertytester;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.sse.core.internal.Logger;

public class StructuredFilePropertyTester
extends PropertyTester {
    private static final String PROPERTY_CONTENT_TYPE_ID = "contentTypeId";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PROPERTY_CONTENT_TYPE_ID.equals(property) && expectedValue != null && receiver instanceof IFile && ((IFile)receiver).exists()) {
            return this.testContentType((IFile)receiver, expectedValue.toString());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean testContentType(IFile file, String contentTypeId) {
        String expectedValue = contentTypeId.trim();
        try {
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription == null) return false;
            IContentType contentType = contentDescription.getContentType();
            while (true) {
                if (contentType == null) {
                    return false;
                }
                if (expectedValue.equals(contentType.getId())) {
                    return true;
                }
                contentType = contentType.getBaseType();
            }
        }
        catch (Exception e) {
            if (!Logger.DEBUG) return false;
            Logger.logException(e);
        }
        return false;
    }
}

