/*
 * Decompiled with CFR 0.152.
 */
package bidi;

import java.text.Bidi;
import java.util.Random;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BenchmarkLevelRuns {
    public static void main(String[] args) {
        Display display = new Display();
        String[] words = new String[]{"International", "Business", "Machines", "\u0634\u0635\u0636\u0637\u0639\u0641\u0650", "\u0640\u0641\u0642\u0643\u0644\u0630\u0646\u0643", "\u0629\u0633\u0645\u0643\u0643\u0649"};
        StringBuffer buffer = new StringBuffer();
        Random rand = new Random();
        int i = 0;
        while (i < 1000) {
            buffer.append(words[rand.nextInt(words.length)] + " ");
            ++i;
        }
        String sentence = buffer.toString();
        BenchmarkLevelRuns.getSWTLevelRuns(sentence);
        BenchmarkLevelRuns.getAWTLevelRuns(sentence);
        long start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 100) {
            BenchmarkLevelRuns.getSWTLevelRuns(sentence);
            ++i2;
        }
        long end = System.currentTimeMillis();
        System.out.println("SWT Ellapsed millis:" + (end - start));
        start = System.currentTimeMillis();
        int i3 = 0;
        while (i3 < 100) {
            BenchmarkLevelRuns.getAWTLevelRuns(sentence);
            ++i3;
        }
        end = System.currentTimeMillis();
        System.out.println("AWT Ellapsed millis:" + (end - start));
        BenchmarkLevelRuns.displayArray(BenchmarkLevelRuns.getSWTLevelRuns(sentence));
        BenchmarkLevelRuns.displayArray(BenchmarkLevelRuns.getAWTLevelRuns(sentence));
        Shell shell = new Shell(display);
        shell.setText("Shell");
        shell.setLayout((Layout)new FillLayout());
        StyledText text = new StyledText((Composite)shell, 64);
        text.setText(sentence);
        shell.setSize(200, 200);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void displayArray(int[] levelRuns) {
        int[] nArray = levelRuns;
        int n = levelRuns.length;
        int n2 = 0;
        while (n2 < n) {
            int levelRun = nArray[n2];
            System.out.print(levelRun + ",");
            ++n2;
        }
        System.out.println();
    }

    private static int[] getAWTLevelRuns(String sentence) {
        Bidi bidi = new Bidi(sentence, 0);
        int[] result = new int[bidi.getRunCount() * 2];
        int i = 0;
        while (i < result.length / 2) {
            result[i * 2] = bidi.getRunStart(i);
            result[i * 2 + 1] = bidi.getRunLevel(i);
            ++i;
        }
        return result;
    }

    private static int[] getSWTLevelRuns(String sentence) {
        int[] levels = new int[15];
        TextLayout layout = new TextLayout(null);
        layout.setText(sentence);
        int j = 0;
        int offset = 0;
        int prevLevel = -1;
        offset = 0;
        while (offset < sentence.length()) {
            int newLevel = layout.getLevel(offset);
            if (newLevel != prevLevel) {
                if (j + 3 > levels.length) {
                    int[] temp = levels;
                    levels = new int[levels.length * 2 + 1];
                    System.arraycopy(temp, 0, levels, 0, temp.length);
                }
                levels[j++] = offset;
                levels[j++] = newLevel;
                prevLevel = newLevel;
            }
            ++offset;
        }
        levels[j++] = offset;
        if (j != levels.length) {
            int[] newLevels = new int[j];
            System.arraycopy(levels, 0, newLevels, 0, j);
            levels = newLevels;
        }
        return levels;
    }
}

