/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.actions;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.LogicPlugin;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;

public class IncrementDecrementAction
extends SelectionAction {
    private static final String INCREMENT_REQUEST = "Increment";
    private static final String DECREMENT_REQUEST = "Decrement";
    public static final String INCREMENT = "Increment";
    public static final String DECREMENT = "Decrement";
    Request request;

    public IncrementDecrementAction(IWorkbenchPart part, boolean increment) {
        super(part);
        if (increment) {
            this.request = new Request((Object)"Increment");
            this.setText(LogicMessages.IncrementDecrementAction_Increment_ActionLabelText);
            this.setId("Increment");
            this.setToolTipText(LogicMessages.IncrementDecrementAction_Increment_ActionToolTipText);
            this.setImageDescriptor(ImageDescriptor.createFromFile(LogicPlugin.class, (String)"icons/plus.gif"));
        } else {
            this.request = new Request((Object)"Decrement");
            this.setText(LogicMessages.IncrementDecrementAction_Decrement_ActionLabelText);
            this.setId("Decrement");
            this.setToolTipText(LogicMessages.IncrementDecrementAction_Decrement_ActionToolTipText);
            this.setImageDescriptor(ImageDescriptor.createFromFile(LogicPlugin.class, (String)"icons/minus.gif"));
        }
        this.setHoverImageDescriptor(this.getImageDescriptor());
    }

    protected boolean calculateEnabled() {
        return this.canPerformAction();
    }

    /*
     * WARNING - void declaration
     */
    private boolean canPerformAction() {
        if (this.getSelectedObjects().isEmpty()) {
            return false;
        }
        List parts = this.getSelectedObjects();
        for (Object o : parts) {
            void part;
            if (!(o instanceof EditPart)) {
                return false;
            }
            EditPart editPart = (EditPart)o;
            if (part.getModel() instanceof LED) continue;
            return false;
        }
        return true;
    }

    private Command getCommand() {
        List editparts = this.getSelectedObjects();
        CompoundCommand cc = new CompoundCommand();
        cc.setDebugLabel("Increment/Decrement LEDs");
        for (Object editpart : editparts) {
            EditPart part = (EditPart)editpart;
            cc.add(part.getCommand(this.request));
        }
        return cc;
    }

    public void run() {
        this.execute(this.getCommand());
    }
}

