/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.ant.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class PreProcessor
extends Task {
    private Vector<FileSet> fFileSets = new Vector();
    private File fDestDir = null;
    private Set<String> fSymbols = new HashSet<String>();
    private FileUtils fUtils = FileUtils.getFileUtils();
    private static final int STATE_OUTSIDE_CONDITION = 0;
    private static final int STATE_TRUE_CONDITION = 1;
    private static final int STATE_FALSE_CONDITION = 2;
    private static final int STATE_POST_TRUE_CONDITION = 3;
    private Matcher IF_DEF_MATCHER = Pattern.compile("#ifdef\\s+\\w+").matcher("");
    private Matcher ELSE_IF_MATCHER = Pattern.compile("#elseif\\s+\\w+").matcher("");
    private Matcher ELSE_MATCHER = Pattern.compile("#else$|#else\\W+").matcher("");
    private Matcher END_MATCHER = Pattern.compile("#endif").matcher("");

    public void addFileset(FileSet set) {
        this.fFileSets.addElement(set);
    }

    public void setDestdir(File destDir) {
        this.fDestDir = destDir;
    }

    public void setSymbols(String symbols) {
        String[] strings = symbols.split(",");
        int i = 0;
        while (i < strings.length) {
            String string = strings[i].trim();
            if (string.length() > 0) {
                this.fSymbols.add(string);
            }
            ++i;
        }
    }

    public void execute() throws BuildException {
        if (this.fSymbols.size() == 0) {
            throw new BuildException("No symbols specified for preprocessor");
        }
        if (this.fFileSets.isEmpty()) {
            throw new BuildException("No filesets specified for processing");
        }
        if (!this.fDestDir.exists()) {
            throw new BuildException("destdir does not exist: " + this.fDestDir.getAbsolutePath());
        }
        StringBuilder buf = new StringBuilder("Symbols: ");
        String[] symbols = this.fSymbols.toArray(new String[this.fSymbols.size()]);
        int i = 0;
        while (i < symbols.length) {
            String symbol = symbols[i];
            buf.append(symbol);
            if (i < symbols.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        this.log(buf.toString());
        for (FileSet fileSet : this.fFileSets) {
            DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
            String[] includedFiles = scanner.getIncludedFiles();
            File baseDir = fileSet.getDir(this.getProject());
            int i2 = 0;
            while (i2 < includedFiles.length) {
                String fileName = includedFiles[i2];
                this.processFile(baseDir, fileName, this.fDestDir);
                ++i2;
            }
        }
    }

    private void processFile(File baseDir, String fileName, File destDir) throws BuildException {
        File destFile = new File(destDir, fileName);
        File srcFile = new File(baseDir, fileName);
        File dir = destFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String contents = null;
        if (fileName.endsWith(".java")) {
            contents = this.preProcessFile(srcFile);
        } else if (fileName.equals("plugin.xml")) {
            contents = this.preProcessFile(srcFile);
        }
        if (contents == null) {
            try {
                this.fUtils.copyFile(srcFile, destFile);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        try {
            FileWriter writer = new FileWriter(destFile);
            writer.write(contents);
            writer.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String preProcessFile(File srcFile) {
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                reader = new BufferedReader(new FileReader(srcFile));
                try {
                    buffer = new StringBuilder();
                    line = reader.readLine();
                    activeSymbol = null;
                    state = 0;
                    changed = false;
                    while (true) {
                        if (line == null) {
                            if (changed != false) return buffer.toString();
                            return null;
                        }
                        ifdef = this.IF_DEF_MATCHER.reset(line).find();
                        elseif = this.ELSE_IF_MATCHER.reset(line).find();
                        elze = this.ELSE_MATCHER.reset(line).find();
                        endif = this.END_MATCHER.reset(line).find();
                        commandLine = ifdef != false || elseif != false || elze != false || endif != false;
                        written = false;
                        switch (state) {
                            case 0: {
                                if (ifdef) {
                                    condition = line.substring(this.IF_DEF_MATCHER.start(), this.IF_DEF_MATCHER.end());
                                    strings = condition.split("\\s+");
                                    activeSymbol = strings[1].trim();
                                    if (this.fSymbols.contains(activeSymbol)) {
                                        state = 1;
                                        break;
                                    }
                                    state = 2;
                                    break;
                                }
                                if (elseif) {
                                    throw new BuildException("#elseif encountered without corresponding #ifdef");
                                }
                                if (elze) {
                                    throw new BuildException("#else encountered without corresponding #ifdef (" + srcFile.getPath() + ")");
                                }
                                if (!endif) break;
                                throw new BuildException("#endif encountered without corresponding #ifdef");
                            }
                            case 1: {
                                if (elze || elseif) {
                                    state = 3;
                                    break;
                                }
                                if (endif) {
                                    state = 0;
                                    break;
                                }
                                if (ifdef) {
                                    throw new BuildException("illegal nested #ifdef");
                                }
                            }
                            case 2: {
                                if (!elseif) ** GOTO lbl55
                                condition = line.substring(this.ELSE_IF_MATCHER.start(), this.ELSE_IF_MATCHER.end());
                                strings = condition.split("\\s+");
                                activeSymbol = strings[1].trim();
                                state = this.fSymbols.contains(activeSymbol) ? 1 : 2;
                                ** GOTO lbl63
lbl55:
                                // 1 sources

                                if (elze) {
                                    state = 1;
                                    break;
                                }
                                if (endif) {
                                    state = 0;
                                    break;
                                }
                                if (ifdef) {
                                    throw new BuildException("illegal nested #ifdef");
                                }
                            }
lbl63:
                            // 4 sources

                            case 3: {
                                if (endif) {
                                    state = 0;
                                    break;
                                }
                                if (!ifdef) break;
                                throw new BuildException("illegal nested #ifdef");
                            }
                        }
                        if (!(commandLine || state != 0 && state != 1)) {
                            if (state == 1) {
                                line = line.replaceFirst("^(\t*)//#", "$1");
                            }
                            buffer.append(line);
                            buffer.append("\n");
                            written = true;
                        }
                        changed = changed != false || written == false;
                        line = reader.readLine();
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable var3_6) {
                if (var2_2 == null) {
                    var2_2 = var3_6;
                    throw var2_2;
                }
                if (var2_2 == var3_6) throw var2_2;
                var2_2.addSuppressed(var3_6);
                throw var2_2;
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static void main(String[] args) {
        PreProcessor processor = new PreProcessor();
        processor.setSymbols("ex2");
        String string = processor.preProcessFile(new File("c:\\eclipse3.1\\dev\\example.debug.core\\src\\example\\debug\\core\\launcher\\PDALaunchDelegate.java"));
        System.out.println(string);
    }
}

