/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.usagestats;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.usagestats.UsageStatInfoCollector;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class PlatformDataCollector
implements UsageStatInfoCollector {
    @Override
    public Map<String, String> collect() {
        Map<String, String> result = this.collectSystemData();
        result.put("plugin_id", "org.eclipse.titan.common");
        this.addBundleVersion(result, "eclipse", "org.eclipse.platform");
        this.addBundleVersion(result, "plugin", "org.eclipse.titan.common");
        try {
            result.put("hostname", InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (Exception e) {
            ErrorReporter.logWarningExceptionStackTrace("While resolving the local host's address", e);
            result.put("hostname", "UNKNOWN");
        }
        return result;
    }

    private Map<String, String> collectSystemData() {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            result.put("user_id", System.getProperty("user.name"));
            result.put("os_name", System.getProperty("os.name"));
            result.put("os_arch", System.getProperty("os.arch"));
            result.put("os_version", System.getProperty("os.version"));
            result.put("java_version", System.getProperty("java.version"));
            result.put("java_vendor", System.getProperty("java.vendor"));
        }
        catch (SecurityException e) {
            ErrorReporter.logWarningExceptionStackTrace("Could not access a system property", e);
            return result;
        }
        return result;
    }

    private void addBundleVersion(Map<String, String> data, String key, String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return;
        }
        Version version = bundle.getVersion();
        String versionString = "" + version.getMajor() + "." + version.getMinor() + "." + version.getMicro();
        data.put(key + "_version", versionString);
        data.put(key + "_version_qualifier", version.getQualifier());
    }
}

