/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanObjectid;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanObjectid_template
extends Base_Template {
    private TitanObjectid single_value;
    private List<TitanObjectid_template> value_list;

    public TitanObjectid_template() {
    }

    public TitanObjectid_template(Base_Template.template_sel otherValue) {
        super(otherValue);
        TitanObjectid_template.check_single_selection(otherValue);
    }

    public TitanObjectid_template(TitanObjectid otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanObjectid(otherValue);
    }

    public TitanObjectid_template(Optional<TitanObjectid> otherValue) {
        switch (otherValue.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
                this.single_value = new TitanObjectid(otherValue.constGet());
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Creating a objid template from an unbound optional field.");
            }
        }
    }

    public TitanObjectid_template(TitanObjectid_template otherValue) {
        this.copy_template(otherValue);
    }

    @Override
    public void clean_up() {
        if (this.template_selection == Base_Template.template_sel.VALUE_LIST || this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST) {
            this.value_list = null;
        } else {
            this.template_selection = Base_Template.template_sel.UNINITIALIZED_TEMPLATE;
        }
    }

    private void copy_template(TitanObjectid_template otherValue) {
        switch (otherValue.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = otherValue.single_value;
                break;
            }
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list = new ArrayList<TitanObjectid_template>(otherValue.value_list.size());
                for (int i = 0; i < otherValue.value_list.size(); ++i) {
                    TitanObjectid_template temp = new TitanObjectid_template(otherValue.value_list.get(i));
                    this.value_list.add(temp);
                }
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported objid template.");
            }
        }
        this.set_selection(otherValue);
    }

    @Override
    public TitanObjectid_template operator_assign(Base_Template.template_sel otherValue) {
        TitanObjectid_template.check_single_selection(otherValue);
        this.clean_up();
        this.set_selection(otherValue);
        return this;
    }

    public TitanObjectid_template operator_assign(TitanObjectid otherValue) {
        otherValue.must_bound("Assignment of an unbound objid value to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanObjectid(otherValue);
        return this;
    }

    public TitanObjectid_template operator_assign(TitanObjectid_template otherValue) {
        if (otherValue != this) {
            this.clean_up();
            this.copy_template(otherValue);
        }
        return this;
    }

    @Override
    public Base_Template operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanObjectid) {
            return this.operator_assign((TitanObjectid)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to objid", otherValue));
    }

    @Override
    public Base_Template operator_assign(Base_Template otherValue) {
        if (otherValue instanceof TitanObjectid_template) {
            return this.operator_assign((TitanObjectid_template)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to objid", otherValue));
    }

    @Override
    public void log_match(Base_Type match_value, boolean legacy) {
        if (match_value instanceof TitanObjectid) {
            this.log_match((TitanObjectid)match_value, legacy);
            return;
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to objid", match_value));
    }

    public boolean match(TitanObjectid otherValue, boolean legacy) {
        if (!otherValue.is_bound()) {
            return false;
        }
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                return this.single_value.operator_equals(otherValue);
            }
            case OMIT_VALUE: {
                return false;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (!this.value_list.get(i).match(otherValue, legacy)) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
        }
        throw new TtcnError("Matching with an uninitialized/unsupported objid template.");
    }

    public boolean match(TitanObjectid otherValue) {
        return this.match(otherValue, false);
    }

    @Override
    public boolean match(Base_Type otherValue, boolean legacy) {
        if (otherValue instanceof TitanObjectid) {
            return this.match((TitanObjectid)otherValue, legacy);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to objid", otherValue));
    }

    @Override
    public TitanObjectid valueof() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Performing a valueof or send operation on a non-specific objid template.");
        }
        return this.single_value;
    }

    public TitanInteger size_of() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                return this.single_value.size_of();
            }
            case OMIT_VALUE: {
                throw new TtcnError("Performing sizeof() operation on an objid template containing omit value.");
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                throw new TtcnError("Performing sizeof() operation on a */? objid template.");
            }
            case VALUE_LIST: {
                if (this.value_list.isEmpty()) {
                    throw new TtcnError("Internal error: Performing sizeof() operation on an objid template containing an empty list.");
                }
                TitanInteger item_size = this.value_list.get(0).size_of();
                for (int i = 1; i < this.value_list.size(); ++i) {
                    if (this.value_list.get(i).size_of().operator_equals(item_size)) continue;
                    throw new TtcnError("Performing sizeof() operation on an objid template containing a value list with different sizes.");
                }
                return item_size;
            }
            case COMPLEMENTED_LIST: {
                throw new TtcnError("Performing sizeof() operation on an objid template containing complemented list.");
            }
        }
        throw new TtcnError("Performing sizeof() operation on an uninitialized/unsupported objid template.");
    }

    @Override
    public void set_type(Base_Template.template_sel template_type, int list_length) {
        if (template_type != Base_Template.template_sel.VALUE_LIST && template_type != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Setting an invalid list type for an objid template.");
        }
        this.clean_up();
        this.set_selection(template_type);
        this.value_list = new ArrayList<TitanObjectid_template>(list_length);
        for (int i = 0; i < list_length; ++i) {
            this.value_list.add(new TitanObjectid_template());
        }
    }

    @Override
    public int n_list_elem() {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list objid template.");
        }
        return this.value_list.size();
    }

    @Override
    public TitanObjectid_template list_item(int list_index) {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list objid template.");
        }
        if (list_index >= this.value_list.size()) {
            throw new TtcnError("Index overflow in an objid value list template.");
        }
        return this.value_list.get(list_index);
    }

    @Override
    public void log() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value.log();
                break;
            }
            case COMPLEMENTED_LIST: {
                TTCN_Logger.log_event_str("complement");
            }
            case VALUE_LIST: {
                TTCN_Logger.log_char('(');
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (i > 0) {
                        TTCN_Logger.log_event_str(", ");
                    }
                    this.value_list.get(i).log();
                }
                TTCN_Logger.log_char(')');
                break;
            }
            default: {
                this.log_generic();
            }
        }
        this.log_ifpresent();
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_TEMPLATE.getValue(), "objid template");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        switch (param.get_type()) {
            case MP_Omit: {
                this.operator_assign(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case MP_Any: {
                this.operator_assign(Base_Template.template_sel.ANY_VALUE);
                break;
            }
            case MP_AnyOrNone: {
                this.operator_assign(Base_Template.template_sel.ANY_OR_OMIT);
                break;
            }
            case MP_List_Template: 
            case MP_ComplementList_Template: {
                TitanObjectid_template temp = new TitanObjectid_template();
                temp.set_type(param.get_type() == Param_Types.Module_Parameter.type_t.MP_List_Template ? Base_Template.template_sel.VALUE_LIST : Base_Template.template_sel.COMPLEMENTED_LIST, param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    temp.list_item(i).set_param(param.get_elem(i));
                }
                this.operator_assign(temp);
                break;
            }
            case MP_Objid: {
                this.operator_assign(new TitanObjectid(param.get_string_size(), (TitanInteger[])param.get_string_data()));
                break;
            }
            default: {
                param.type_error("objid template");
            }
        }
        this.is_ifPresent = param.get_ifpresent();
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        Param_Types.Module_Parameter mp = null;
        switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                mp = new Param_Types.Module_Param_Unbound();
                break;
            }
            case OMIT_VALUE: {
                mp = new Param_Types.Module_Param_Omit();
                break;
            }
            case ANY_VALUE: {
                mp = new Param_Types.Module_Param_Any();
                break;
            }
            case ANY_OR_OMIT: {
                mp = new Param_Types.Module_Param_AnyOrNone();
                break;
            }
            case SPECIFIC_VALUE: {
                mp = this.single_value.get_param(param_name);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                mp = this.template_selection == Base_Template.template_sel.VALUE_LIST ? new Param_Types.Module_Param_List_Template() : new Param_Types.Module_Param_ComplementList_Template();
                for (int i = 0; i < this.value_list.size(); ++i) {
                    mp.add_elem(this.value_list.get(i).get_param(param_name));
                }
                break;
            }
            default: {
                throw new TtcnError("Referencing an uninitialized/unsupported objid template.");
            }
        }
        if (this.is_ifPresent) {
            mp.set_ifpresent();
        }
        return mp;
    }

    public void log_match(TitanObjectid match_value, boolean legacy) {
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity() && TTCN_Logger.get_logmatch_buffer_len() != 0) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event_str(" := ");
        }
        match_value.log();
        TTCN_Logger.log_event_str(" with ");
        this.log();
        if (this.match(match_value)) {
            TTCN_Logger.log_event_str(" matched");
        } else {
            TTCN_Logger.log_event_str(" unmatched");
        }
    }

    @Override
    public boolean match_omit(boolean legacy) {
        if (this.is_ifPresent) {
            return true;
        }
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                if (!legacy) break;
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (!this.value_list.get(i).match_omit()) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
        }
        return false;
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.encode_text_base(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value.encode_text(text_buf);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                text_buf.push_int(this.value_list.size());
                for (int i = 0; i < this.value_list.size(); ++i) {
                    this.value_list.get(i).encode_text(text_buf);
                }
                break;
            }
            default: {
                throw new TtcnError("Text encoder: Encoding an uninitialized/unsupported objid template.");
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.decode_text_base(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value.decode_text(text_buf);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                int size = text_buf.pull_int().get_int();
                this.value_list = new ArrayList<TitanObjectid_template>(size);
                for (int i = 0; i < size; ++i) {
                    TitanObjectid_template temp = new TitanObjectid_template();
                    temp.decode_text(text_buf);
                    this.value_list.add(temp);
                }
                break;
            }
            default: {
                throw new TtcnError("Text decoder: An unknown/unsupported selection was received for an objid template.");
            }
        }
    }

    @Override
    public void check_restriction(Base_Template.template_res restriction, String name, boolean legacy) {
        if (this.template_selection == Base_Template.template_sel.UNINITIALIZED_TEMPLATE) {
            return;
        }
        switch (name != null && restriction == Base_Template.template_res.TR_VALUE ? Base_Template.template_res.TR_OMIT : restriction) {
            case TR_VALUE: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_OMIT: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.OMIT_VALUE && this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_PRESENT: {
                if (this.match_omit(legacy)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new TtcnError(MessageFormat.format("Restriction `{0}'' on template of type {1} violated.", TitanObjectid_template.get_res_name(restriction), name == null ? "objid" : name));
    }
}

