/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.runtime.core.Module_List;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Module;
import org.eclipse.titan.runtime.core.TTCN_Runtime;
import org.eclipse.titan.runtime.core.TTCN_Snapshot;
import org.eclipse.titan.runtime.core.TitanComponent;
import org.eclipse.titan.runtime.core.TitanLoggerApi;
import org.eclipse.titan.runtime.core.TitanPort;
import org.eclipse.titan.runtime.core.TtcnError;
import org.eclipse.titan.runtime.core.cfgparser.CfgAnalyzer;
import org.eclipse.titan.runtime.core.cfgparser.ExecuteSectionHandler;

public final class Runtime_Single_main {
    private Runtime_Single_main() {
    }

    public static int singleMain(String[] args) {
        int returnValue = 0;
        TitanComponent.self.set(new TitanComponent(1));
        TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.SINGLE_CONTROLPART);
        TTCN_Snapshot.initialize();
        TTCN_Logger.initialize_logger();
        TTCN_Logger.set_start_time();
        System.out.println("TTCN-3 Host Controller (single mode)");
        try {
            File config_file;
            TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.executor__start__single__mode);
            Module_List.pre_init_modules();
            File file = config_file = args.length > 0 ? new File(args[0]) : null;
            if (config_file != null) {
                System.err.println(MessageFormat.format("Using configuration file: `{0}''", config_file));
                TTCN_Logger.log_configdata(TitanLoggerApi.ExecutorConfigdata_reason.enum_type.using__config__file, config_file.getName());
                CfgAnalyzer cfgAnalyzer = new CfgAnalyzer();
                boolean config_file_failure = cfgAnalyzer.parse(config_file);
                TTCN_Runtime.set_logger_parameters();
                TTCN_Logger.open_file();
                TTCN_Logger.write_logger_settings();
                if (!config_file_failure) {
                    List<ExecuteSectionHandler.ExecuteItem> executeItems = cfgAnalyzer.getExecuteSectionHandler().getExecuteitems();
                    Module_List.log_param();
                    Module_List.post_init_modules();
                    for (ExecuteSectionHandler.ExecuteItem executeItem : executeItems) {
                        String module = executeItem.getModuleName();
                        String testcase = executeItem.getTestcaseName();
                        if ("*".equals(testcase)) {
                            Module_List.execute_all_testcases(module);
                            continue;
                        }
                        if (testcase == null || "control".equals(testcase)) {
                            Module_List.execute_control(module);
                            continue;
                        }
                        Module_List.execute_testcase(module, testcase);
                    }
                }
            } else {
                TTCN_Runtime.set_logger_parameters();
                TTCN_Logger.open_file();
                TTCN_Logger.write_logger_settings();
                Module_List.post_init_modules();
                for (TTCN_Module module : Module_List.modules) {
                    module.control();
                }
            }
        }
        catch (TtcnError config_file) {
        }
        catch (Throwable e) {
            TTCN_Logger.log_str(TTCN_Logger.Severity.ERROR_UNQUALIFIED, "Fatal error. Aborting execution.");
            StringWriter error = new StringWriter();
            e.printStackTrace(new PrintWriter(error));
            TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
            TTCN_Logger.log_event_str("Dynamic test case error: ");
            TTCN_Logger.log_event_str(error.toString());
            TTCN_Logger.end_event();
            returnValue = -1;
        }
        TTCN_Logger.finish_event();
        TTCN_Runtime.log_verdict_statistics();
        TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.executor__finish__single__mode);
        TTCN_Logger.close_file();
        TitanPort.clear_parameters();
        TitanComponent.clear_component_names();
        TTCN_EncDec.clear_error();
        TTCN_Logger.terminate_logger();
        TTCN_Snapshot.terminate();
        TTCN_Runtime.clean_up();
        return returnValue;
    }
}

