/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import org.eclipse.titan.runtime.core.Text_Buf;

public class NetworkHandler {
    protected NetworkFamily m_family;
    protected InetSocketAddress m_addr;

    public NetworkHandler() {
        this.m_family = NetworkFamily.ipv4;
    }

    public NetworkHandler(NetworkFamily p_family) {
        this.m_family = p_family;
    }

    public NetworkHandler(InetSocketAddress p_addr) {
        this.m_addr = p_addr;
        this.set_family(this.m_addr);
    }

    public void set_family(String p_addr, int tcp_port) {
        if (p_addr == null) {
            this.m_family = NetworkFamily.ipv4;
        } else {
            this.set_family(new InetSocketAddress(p_addr, tcp_port));
        }
    }

    public void set_family(NetworkFamily p_family) {
        this.m_family = p_family;
    }

    public void set_family(InetSocketAddress p_addr) {
        if (p_addr.getAddress() instanceof Inet4Address) {
            this.m_family = NetworkFamily.ipv4;
            this.m_addr = p_addr;
            return;
        }
        if (p_addr.getAddress() instanceof Inet6Address) {
            this.m_family = NetworkFamily.ipv6;
            this.m_addr = p_addr;
            return;
        }
        this.m_family = NetworkFamily.ipv0;
        this.m_addr = p_addr;
    }

    public NetworkFamily get_family() {
        return this.m_family;
    }

    public InetSocketAddress get_addr() {
        return this.m_addr;
    }

    public Socket socket() {
        if (this.m_addr == null) {
            return null;
        }
        try {
            return new Socket(this.m_addr.getAddress(), this.m_addr.getPort());
        }
        catch (IOException e) {
            return null;
        }
    }

    public void clean_up() {
        this.m_family = NetworkFamily.ipv0;
        this.m_addr = null;
    }

    public boolean is_local() {
        if (this.m_addr == null) {
            return false;
        }
        if (this.m_addr.getAddress() instanceof Inet4Address) {
            byte[] ipv4_localhost_bytes = new byte[]{127, 0, 0, 1};
            return Arrays.equals(this.m_addr.getAddress().getAddress(), ipv4_localhost_bytes);
        }
        if (this.m_addr.getAddress() instanceof Inet6Address) {
            byte[] localhost_bytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
            byte[] mapped_ipv4_localhost = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 127, 0, 0, 1};
            return Arrays.equals(this.m_addr.getAddress().getAddress(), localhost_bytes) || Arrays.equals(this.m_addr.getAddress().getAddress(), mapped_ipv4_localhost);
        }
        return false;
    }

    public static class HCNetworkHandler
    extends NetworkHandler {
        private InetSocketAddress m_mc_addr = null;
        private InetSocketAddress m_local_addr = null;

        public boolean set_local_addr(String p_addr, int p_port) {
            if (p_addr == null) {
                return false;
            }
            this.m_local_addr = new InetSocketAddress(p_addr, p_port);
            this.set_family(this.m_local_addr);
            return this.m_local_addr != null;
        }

        public boolean set_mc_addr(String p_addr, int p_port) {
            if (p_addr == null) {
                return false;
            }
            this.m_mc_addr = new InetSocketAddress(p_addr, p_port);
            this.set_family(this.m_mc_addr);
            return this.m_mc_addr != null;
        }

        public SocketChannel bind_local_addr() {
            try {
                return SocketChannel.open().bind(this.m_local_addr);
            }
            catch (IOException e) {
                return null;
            }
        }

        public SocketChannel connect_to_mc() {
            SocketChannel sc;
            try {
                sc = SocketChannel.open();
            }
            catch (IOException e) {
                return null;
            }
            try {
                if (sc.connect(this.m_mc_addr)) {
                    return sc;
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }

        public String get_mc_host_str() {
            return this.m_mc_addr.getHostString();
        }

        public String get_mc_addr_str() {
            return this.m_mc_addr.getAddress().getHostAddress();
        }

        public String get_local_host_str() {
            return this.m_local_addr.getHostString();
        }

        public String get_local_addr_str() {
            return this.m_local_addr.getAddress().getHostAddress();
        }

        public InetSocketAddress get_mc_addr() {
            return this.m_mc_addr;
        }

        public InetSocketAddress get_local_addr() {
            return this.m_local_addr;
        }

        public int get_mc_port() {
            return this.m_mc_addr.getPort();
        }

        public int get_local_port() {
            return this.m_local_addr.getPort();
        }

        @Override
        public void clean_up() {
            this.m_local_addr = null;
            this.m_mc_addr = null;
        }

        public boolean is_local(InetSocketAddress p_addr) {
            if (p_addr == null) {
                return false;
            }
            if (p_addr.getAddress() instanceof Inet4Address) {
                byte[] ipv4_localhost_bytes = new byte[]{127, 0, 0, 1};
                return Arrays.equals(p_addr.getAddress().getAddress(), ipv4_localhost_bytes);
            }
            if (p_addr.getAddress() instanceof Inet6Address) {
                byte[] localhost_bytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
                byte[] mapped_ipv4_localhost = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 127, 0, 0, 1};
                return Arrays.equals(p_addr.getAddress().getAddress(), localhost_bytes) || Arrays.equals(p_addr.getAddress().getAddress(), mapped_ipv4_localhost);
            }
            return false;
        }

        public void push_raw_local_addr(Text_Buf p_buf) {
            if (this.m_local_addr.getAddress() instanceof Inet4Address) {
                p_buf.push_raw(1, new byte[]{2});
                p_buf.push_int(this.m_local_addr.getPort());
                p_buf.push_raw(4, this.m_local_addr.getAddress().getAddress());
                return;
            }
            if (this.m_local_addr.getAddress() instanceof Inet6Address) {
                p_buf.push_raw(1, new byte[]{23});
                p_buf.push_int(this.m_local_addr.getPort());
                p_buf.push_raw(16, this.m_local_addr.getAddress().getAddress());
                p_buf.push_int(this.getIpv6Address(this.m_local_addr.getAddress()).getScopeId());
            }
        }

        public void push_raw_mc_addr(Text_Buf p_buf) {
            if (this.m_mc_addr.getAddress() instanceof Inet4Address) {
                p_buf.push_raw(1, new byte[]{2});
                p_buf.push_int(this.m_mc_addr.getPort());
                p_buf.push_raw(4, this.m_mc_addr.getAddress().getAddress());
                return;
            }
            if (this.m_mc_addr.getAddress() instanceof Inet6Address) {
                p_buf.push_raw(1, new byte[]{23});
                p_buf.push_int(this.m_mc_addr.getPort());
                p_buf.push_raw(16, this.m_mc_addr.getAddress().getAddress());
                p_buf.push_int(this.getIpv6Address(this.m_mc_addr.getAddress()).getScopeId());
            }
        }

        public void pull_raw_local_addr(Text_Buf p_buf) {
            byte[] network_family = new byte[1];
            p_buf.pull_raw(1, network_family);
            if (network_family[0] == 2) {
                int port_number = p_buf.pull_int().get_int();
                byte[] ip_address = new byte[4];
                p_buf.pull_raw(4, ip_address);
                try {
                    this.m_local_addr = new InetSocketAddress(InetAddress.getByAddress(ip_address), port_number);
                    return;
                }
                catch (UnknownHostException e) {
                    this.m_local_addr = null;
                    return;
                }
            }
            if (network_family[0] == 23) {
                int port_number = p_buf.pull_int().get_int();
                byte[] ip_address = new byte[16];
                p_buf.pull_raw(16, ip_address);
                int scope_id = 0;
                if (p_buf.pull_int().is_bound()) {
                    scope_id = p_buf.pull_int().get_int();
                }
                try {
                    if (scope_id == 0) {
                        this.m_local_addr = new InetSocketAddress(InetAddress.getByAddress(ip_address), port_number);
                        return;
                    }
                    this.m_local_addr = new InetSocketAddress(Inet6Address.getByAddress("", ip_address, scope_id), port_number);
                }
                catch (UnknownHostException e) {
                    this.m_local_addr = null;
                    return;
                }
            }
        }

        public void pull_raw_mc_addr(Text_Buf p_buf) {
            byte[] network_family = new byte[1];
            p_buf.pull_raw(1, network_family);
            if (network_family[0] == 2) {
                int port_number = p_buf.pull_int().get_int();
                byte[] ip_address = new byte[4];
                p_buf.pull_raw(4, ip_address);
                try {
                    this.m_mc_addr = new InetSocketAddress(InetAddress.getByAddress(ip_address), port_number);
                    return;
                }
                catch (UnknownHostException e) {
                    this.m_mc_addr = null;
                    return;
                }
            }
            if (network_family[0] == 23) {
                int port_number = p_buf.pull_int().get_int();
                byte[] ip_address = new byte[16];
                p_buf.pull_raw(16, ip_address);
                try {
                    this.m_mc_addr = new InetSocketAddress(InetAddress.getByAddress(ip_address), port_number);
                    return;
                }
                catch (UnknownHostException e) {
                    this.m_mc_addr = null;
                    return;
                }
            }
        }

        private Inet6Address getIpv6Address(InetAddress p_address) {
            return (Inet6Address)p_address;
        }
    }

    public static enum NetworkFamily {
        ipv0,
        ipv4,
        ipv6;

    }
}

