/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences.pages;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Label;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.preferences.data.KeywordColor;
import org.eclipse.titan.log.viewer.preferences.fieldeditors.StringListEditor;
import org.eclipse.titan.log.viewer.preferences.pages.LogViewerPreferenceRootPage;
import org.eclipse.titan.log.viewer.utils.ImportExportUtils;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.ui.IWorkbench;

public class HighlightKeywordsPage
extends LogViewerPreferenceRootPage {
    private StringListEditor highLightEditor;
    private BooleanFieldEditor useHighLight;

    public HighlightKeywordsPage() {
        super(1, false);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("HighlightKeywordsPage.0"));
    }

    @Override
    public void createFieldEditors() {
        new Label(this.getFieldEditorParent(), 0);
        this.useHighLight = new BooleanFieldEditor("org.eclipse.titan.log.viewer_use_highlight_id", Messages.getString("HighlightKeywordsPage.1"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.useHighLight);
        this.highLightEditor = new StringListEditor("org.eclipse.titan.log.viewer_highlight_keyword_id", "", this.getFieldEditorParent(), false, false);
        this.addField(this.highLightEditor);
    }

    @Override
    protected String getPageId() {
        return "org.eclipse.titan.log.viewer.properties.HighlightKeywordsPage";
    }

    private Map<String, String> getCurrentPreferences(String separator) {
        String[] elements;
        HashMap<String, String> currentPrefs = new HashMap<String, String>();
        String highlight = String.valueOf(this.useHighLight.getBooleanValue());
        String keywords = "";
        for (String element : elements = this.highLightEditor.getElements()) {
            keywords = keywords.concat(element + separator);
        }
        currentPrefs.put("org.eclipse.titan.log.viewer_use_highlight_id", highlight);
        currentPrefs.put("org.eclipse.titan.log.viewer_highlight_keyword_id", keywords);
        return currentPrefs;
    }

    private Map<String, Object[]> getCurrentPreferencesSeparated() {
        HashMap<String, Object[]> currentPrefs = new HashMap<String, Object[]>();
        String[] highlight = new String[]{String.valueOf(this.useHighLight.getBooleanValue())};
        currentPrefs.put("org.eclipse.titan.log.viewer_use_highlight_id", highlight);
        String[] listItems = this.highLightEditor.getElements();
        Map<String, RGB> colors = this.highLightEditor.getColors();
        KeywordColor[] values = new KeywordColor[this.highLightEditor.getElements().length];
        for (int i = 0; i < listItems.length; ++i) {
            KeywordColor keywordColor;
            String item = listItems[i];
            RGB color = colors.get(item);
            values[i] = keywordColor = new KeywordColor(item, color);
        }
        currentPrefs.put(this.highLightEditor.getPreferenceName(), values);
        return currentPrefs;
    }

    @Override
    protected void exportPreferences() {
        ImportExportUtils.exportColorSettings(this.getPageId(), this.getCurrentPreferencesSeparated(), true);
    }

    @Override
    protected void importPreferences() {
        Map<String, String> prop = ImportExportUtils.importSettings("org.eclipse.titan.log.viewer.properties.HighlightKeywordsPage");
        if (prop == null) {
            return;
        }
        this.setOldPreferences(this.getCurrentPreferences(File.pathSeparator));
        this.setProperties(prop);
        this.getApplyButton().setEnabled(true);
    }

    @Override
    protected void updatePage() {
        this.useHighLight.loadDefault();
        this.useHighLight.load();
        this.highLightEditor.loadDefault();
        this.highLightEditor.load();
    }

    public void init(IWorkbench workbench) {
    }
}

