/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences.pages;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.preferences.fieldeditors.CheckBoxTreeEditor;
import org.eclipse.titan.log.viewer.preferences.pages.LogViewerPreferenceRootPage;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.utils.ImportExportUtils;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.ui.IWorkbench;

public class FilteredSilentEventPrefPage
extends LogViewerPreferenceRootPage {
    private CheckBoxTreeEditor checkBoxTreeEditor;

    public FilteredSilentEventPrefPage() {
        super(1, true);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("FilteredSilentEventTypes.0"));
    }

    @Override
    public void createFieldEditors() {
        this.checkBoxTreeEditor = new CheckBoxTreeEditor("org.eclipse.titan.log.viewer_filter_silent_event_categories", "", Constants.EVENT_CATEGORIES, this.getFieldEditorParent());
        this.checkBoxTreeEditor.setPreferenceStore(this.getPreferenceStore());
        this.addField(this.checkBoxTreeEditor);
    }

    public void init(IWorkbench workbench) {
    }

    @Override
    protected void performSelectAll() {
        this.checkBoxTreeEditor.selectAll();
        super.performSelectAll();
    }

    @Override
    protected void performDeselectAll() {
        this.checkBoxTreeEditor.deselectAll();
        super.performDeselectAll();
    }

    @Override
    protected String getPageId() {
        return "org.eclipse.titan.log.viewer.properties.FilteredSilentEventsPage";
    }

    private Map<String, String> getCurrentPreferences() {
        HashMap<String, String> currentPrefs = new HashMap<String, String>();
        currentPrefs.put(this.checkBoxTreeEditor.getPreferenceName(), ImportExportUtils.arrayToString(this.checkBoxTreeEditor.getElements(), ";"));
        return currentPrefs;
    }

    private Map<String, String[]> getCurrentPreferencesSeparated() {
        HashMap<String, String[]> currentPrefs = new HashMap<String, String[]>();
        currentPrefs.put(this.checkBoxTreeEditor.getPreferenceName(), this.checkBoxTreeEditor.getElements());
        return currentPrefs;
    }

    @Override
    protected void exportPreferences() {
        ImportExportUtils.exportSettings(this.getPageId(), this.getCurrentPreferencesSeparated(), true);
    }

    @Override
    protected void importPreferences() {
        Map<String, String> prop = ImportExportUtils.importSettings(this.getPageId());
        if (prop == null) {
            return;
        }
        this.setOldPreferences(this.getCurrentPreferences());
        String prefValue = prop.get(this.checkBoxTreeEditor.getPreferenceName());
        if (prefValue == null) {
            this.convertOldSilentEventsToNew(prop);
        }
        this.setProperties(prop);
        this.getApplyButton().setEnabled(true);
    }

    @Override
    protected void updatePage() {
        this.checkBoxTreeEditor.load();
    }

    private void convertOldSilentEventsToNew(Map<String, String> prop) {
        String defaultPrefValue = this.getPreferenceStore().getDefaultString(this.checkBoxTreeEditor.getPreferenceName());
        String[] defaultValues = defaultPrefValue.split(";");
        HashMap<String, String> prefValues = new HashMap<String, String>();
        for (String defaultValue : defaultValues) {
            String[] current = defaultValue.split("=");
            if (current.length != 2) continue;
            prefValues.put(current[0], current[1]);
        }
        this.addImportedValues(prop, prefValues);
        Set keySet = prefValues.keySet();
        StringBuilder builder = new StringBuilder();
        for (String currKey : keySet) {
            if (builder.length() == 0) {
                builder.setLength(0);
                builder.append(currKey).append("=").append((String)prefValues.get(currKey));
                continue;
            }
            builder.append(";").append(currKey).append("=").append((String)prefValues.get(currKey));
        }
        prop.clear();
        prop.put(this.checkBoxTreeEditor.getPreferenceName(), builder.toString());
    }

    private void addImportedValues(Map<String, String> prop, Map<String, String> prefValues) {
        String value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_action");
        if (value != null) {
            prefValues.put("ACTION", value);
            this.updateSubCategories(prefValues, "ACTION", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_debug")) != null) {
            prefValues.put("DEBUG", value);
            this.updateSubCategories(prefValues, "DEBUG", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_deafultop")) != null) {
            prefValues.put("DEFAULTOP", value);
            this.updateSubCategories(prefValues, "DEFAULTOP", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_error")) != null) {
            prefValues.put("ERROR", value);
            this.updateSubCategories(prefValues, "ERROR", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_executor")) != null) {
            prefValues.put("EXECUTOR", value);
            this.updateSubCategories(prefValues, "EXECUTOR", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_function")) != null) {
            prefValues.put("FUNCTION", value);
            this.updateSubCategories(prefValues, "FUNCTION", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_matching")) != null) {
            prefValues.put("MATCHING", value);
            this.updateSubCategories(prefValues, "MATCHING", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_parallel")) != null) {
            prefValues.put("PARALLEL", value);
            this.updateSubCategories(prefValues, "PARALLEL", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_portevent")) != null) {
            prefValues.put("PORTEVENT", value);
            this.updateSubCategories(prefValues, "PORTEVENT", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_statistics")) != null) {
            prefValues.put("STATISTICS", value);
            this.updateSubCategories(prefValues, "STATISTICS", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_testcase")) != null) {
            prefValues.put("TESTCASE", value);
            this.updateSubCategories(prefValues, "TESTCASE", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_timerop")) != null) {
            prefValues.put("TIMEROP", value);
            this.updateSubCategories(prefValues, "TIMEROP", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_unknown")) != null) {
            prefValues.put("UNKNOWN", value);
            this.updateSubCategories(prefValues, "UNKNOWN", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_user")) != null) {
            prefValues.put("USER", value);
            this.updateSubCategories(prefValues, "USER", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_verdictop")) != null) {
            prefValues.put("VERDICTOP", value);
            this.updateSubCategories(prefValues, "VERDICTOP", value);
        }
        if ((value = prop.get("org.eclipse.titan.log.viewer_filter_silentevent_warning")) != null) {
            prefValues.put("WARNING", value);
            this.updateSubCategories(prefValues, "WARNING", value);
        }
    }

    private void updateSubCategories(Map<String, String> prefs, String category, String value) {
        String[] subCategories;
        SortedMap<String, String[]> eventCategories = Constants.EVENT_CATEGORIES;
        for (String subCategory : subCategories = (String[])eventCategories.get(category)) {
            prefs.put(category.concat("_".concat(subCategory)), value);
        }
    }
}

