/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences.fieldeditors;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.utils.preferences.PreferenceUtils;

public class MutableComboFieldEditor
extends FieldEditor {
    private Combo comboBox;
    private Button addButton;
    private Button removeButton;
    private IInputValidator inputValidator = null;
    private final Set<IItemListener> itemListeners = new LinkedHashSet<IItemListener>();

    public MutableComboFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public String[] getItems() {
        return this.comboBox.getItems();
    }

    public int getItemCount() {
        return this.comboBox.getItemCount();
    }

    public int getSelectionIndex() {
        return this.comboBox.getSelectionIndex();
    }

    public String getItem(int index) {
        return this.comboBox.getItem(index);
    }

    public void select(int index) {
        this.comboBox.select(index);
    }

    public void addItem(String item) {
        String[] oldvalue = new String[this.comboBox.getItems().length];
        System.arraycopy(this.comboBox.getItems(), 0, oldvalue, 0, this.comboBox.getItems().length);
        this.comboBox.add(item);
        if (!this.removeButton.getEnabled()) {
            this.removeButton.setEnabled(true);
        }
        this.setPresentsDefaultValue(false);
        this.fireValueChanged("field_editor_value", oldvalue, this.comboBox.getItems());
        this.fireItemAddedListeners(item);
    }

    public void removeItem(int index) {
        if (index < 0 || index >= this.comboBox.getItemCount()) {
            return;
        }
        String[] oldvalue = new String[this.comboBox.getItems().length];
        System.arraycopy(this.comboBox.getItems(), 0, oldvalue, 0, this.comboBox.getItems().length);
        String removedItem = this.comboBox.getItem(index);
        this.comboBox.remove(index);
        if (this.comboBox.getItemCount() == 0) {
            this.removeButton.setEnabled(false);
        }
        this.setPresentsDefaultValue(false);
        this.fireValueChanged("field_editor_value", oldvalue, this.comboBox.getItems());
        this.fireItemRemovedListeners(removedItem);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.comboBox.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.addButton.getLayoutData()).horizontalSpan = 1;
        ((GridData)this.removeButton.getLayoutData()).horizontalSpan = 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        this.comboBox = new Combo(parent, 8);
        this.comboBox.setFont(parent.getFont());
        GridData data = new GridData(768);
        data.horizontalSpan = numColumns;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.comboBox.setLayoutData((Object)data);
        Composite buttons = new Composite(parent, 0);
        GridData buttonsData = new GridData();
        buttonsData.horizontalSpan = numColumns;
        buttonsData.grabExcessHorizontalSpace = true;
        buttonsData.horizontalAlignment = 4;
        buttons.setLayoutData((Object)buttonsData);
        GridLayout gridLayout = new GridLayout(2, false);
        buttons.setLayout((Layout)gridLayout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText("Add");
        this.addButton.setLayoutData((Object)new GridData());
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InputDialog dialog = new InputDialog(new Shell(), "New Item", "", "", MutableComboFieldEditor.this.inputValidator);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    MutableComboFieldEditor.this.addItem(dialog.getValue());
                }
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText("Remove");
        this.removeButton.setLayoutData((Object)new GridData());
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MutableComboFieldEditor.this.removeItem(MutableComboFieldEditor.this.comboBox.getSelectionIndex());
            }
        });
    }

    private void fireItemAddedListeners(String item) {
        for (IItemListener listener : this.itemListeners) {
            listener.itemAdded(item);
        }
    }

    private void fireItemRemovedListeners(String item) {
        for (IItemListener listener : this.itemListeners) {
            listener.itemRemoved(item);
        }
    }

    protected void doLoad() {
        this.comboBox.setItems(PreferenceUtils.deserializeFromString((String)this.getPreferenceStore().getString(this.getPreferenceName())).toArray(new String[0]));
        if (this.comboBox.getItemCount() > 0) {
            this.comboBox.select(0);
        }
    }

    protected void doLoadDefault() {
        this.comboBox.setItems(PreferenceUtils.deserializeFromString((String)this.getPreferenceStore().getDefaultString(this.getPreferenceName())).toArray(new String[0]));
        if (this.comboBox.getItemCount() > 0) {
            this.comboBox.select(0);
        }
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), PreferenceUtils.serializeToString(Arrays.asList(this.comboBox.getItems())));
    }

    public int getNumberOfControls() {
        return 3;
    }

    public void setInputValidator(IInputValidator validator) {
        this.inputValidator = validator;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.comboBox.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.comboBox.removeSelectionListener(listener);
    }

    public void addItemListener(IItemListener listener) {
        this.itemListeners.add(listener);
    }

    public void removeItemListener(IItemListener listener) {
        this.itemListeners.remove(listener);
    }

    public void reload() {
        this.doLoad();
    }

    public static interface IItemListener {
        public void itemAdded(String var1);

        public void itemRemoved(String var1);
    }
}

