/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.factories;

import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.parsers.MessageAnalyser;
import org.eclipse.titan.log.viewer.parsers.MessageAnalyserParallel1;
import org.eclipse.titan.log.viewer.parsers.MessageAnalyserParallel2;
import org.eclipse.titan.log.viewer.parsers.MessageAnalyserSingle1;
import org.eclipse.titan.log.viewer.parsers.MessageAnalyserSingle2;

public final class MessageAnalyserFactory {
    private MessageAnalyserFactory messageAnalyserFactory;

    private MessageAnalyserFactory() {
    }

    public static MessageAnalyser createMessageAnalyser(LogFileMetaData logFileMetaData) throws TechnicalException {
        if (logFileMetaData == null) {
            throw new TechnicalException("logFileMetaData missing");
        }
        if (logFileMetaData.getFileFormat() == 2) {
            if (logFileMetaData.getExecutionMode().equals("SINGLE")) {
                return new MessageAnalyserSingle2();
            }
            if (logFileMetaData.getExecutionMode().equals("PARALLEL") || logFileMetaData.getExecutionMode().equals("PARALLEL_MERGED")) {
                return new MessageAnalyserParallel2();
            }
            throw new TechnicalException("Wrong execution mode");
        }
        if (logFileMetaData.getExecutionMode().equals("SINGLE")) {
            return new MessageAnalyserSingle1();
        }
        if (logFileMetaData.getExecutionMode().equals("PARALLEL") || logFileMetaData.getExecutionMode().equals("PARALLEL_MERGED")) {
            return new MessageAnalyserParallel1();
        }
        throw new TechnicalException("Wrong execution mode");
    }

    public MessageAnalyserFactory getInstance() {
        if (this.messageAnalyserFactory == null) {
            this.messageAnalyserFactory = new MessageAnalyserFactory();
        }
        return this.messageAnalyserFactory;
    }
}

