/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.scope;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titanium.refactoring.scope.ChangeCreator;

public class MinimizeScopeRefactoring
extends Refactoring {
    private final IStructuredSelection fileSelection;
    private final Definition defSelection;
    private final Settings settings;
    private Object[] affectedObjects;

    public MinimizeScopeRefactoring(IStructuredSelection selection, Settings settings) {
        this.defSelection = null;
        this.fileSelection = selection;
        this.settings = settings == null ? new Settings() : settings;
    }

    public MinimizeScopeRefactoring(Definition selection, Settings settings) {
        this.defSelection = selection;
        this.fileSelection = null;
        this.settings = settings == null ? new Settings() : settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Object[] getAffectedObjects() {
        return this.affectedObjects;
    }

    public String getName() {
        return "Minimize scope";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fileSelection != null) {
            CompositeChange cchange = new CompositeChange("MinimizeScopeRefactoring");
            for (Object o : this.fileSelection) {
                if (!(o instanceof IResource)) continue;
                IResource res = (IResource)o;
                ResourceVisitor vis = new ResourceVisitor();
                res.accept((IResourceVisitor)vis);
                cchange.add((Change)vis.getChange());
            }
            this.affectedObjects = cchange.getAffectedObjects();
            return cchange;
        }
        CompositeChange cchange = new CompositeChange("MinimizeScopeRefactoring");
        IResource file = this.defSelection.getLocation().getFile();
        if (!(file instanceof IFile)) {
            ErrorReporter.logError((String)"MinimizeScopeRefactoring.createChange(): File container of defSelection is not an IFile! ");
        }
        ChangeCreator chCreator = new ChangeCreator((IFile)file, this.defSelection, this.settings);
        chCreator.perform();
        Change ch = chCreator.getChange();
        if (ch != null) {
            cchange.add(ch);
            this.affectedObjects = ch.getAffectedObjects();
        } else {
            this.affectedObjects = new Object[0];
        }
        return cchange;
    }

    public static class Settings {
        public static final int MOVE_VARS = 1;
        public static final int MOVE_VARS_IN_CORRECT_SCOPE = 2;
        public static final int REMOVE_UNUSED_VARS = 4;
        public static final int AVOID_MOVING_WHEN_FUNCCALL = 8;
        public static final int AVOID_MOVING_WHEN_UNCHECKED_REF = 16;
        public static final int AVOID_MOVING_MULTIDECLARATIONS = 32;
        private int settings = 0;

        public Settings() {
            this.createDefaultSettings();
        }

        private void createDefaultSettings() {
            this.setSetting(1, true);
            this.setSetting(2, true);
            this.setSetting(4, false);
            this.setSetting(8, true);
            this.setSetting(16, true);
            this.setSetting(32, false);
        }

        public boolean getSetting(int setting) {
            return (this.settings & setting) == setting;
        }

        public void setSetting(int setting, boolean value) {
            boolean prevVal = this.getSetting(setting);
            if (prevVal == value) {
                return;
            }
            this.settings = value ? (this.settings += setting) : (this.settings -= setting);
        }
    }

    private class ResourceVisitor
    implements IResourceVisitor {
        private final CompositeChange change = new CompositeChange("MinimizeScopeRefactoring");

        private CompositeChange getChange() {
            return this.change;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                ChangeCreator chCreator = new ChangeCreator((IFile)resource, MinimizeScopeRefactoring.this.settings);
                chCreator.perform();
                Change ch = chCreator.getChange();
                if (ch != null) {
                    this.change.add(ch);
                }
                return false;
            }
            return true;
        }
    }
}

