/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.movefunction;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titanium.refactoring.movefunction.DataLabelProvider;
import org.eclipse.titanium.refactoring.movefunction.Destination;
import org.eclipse.titanium.refactoring.movefunction.DestinationDataProvider;
import org.eclipse.titanium.refactoring.movefunction.FunctionData;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionMethod;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionRefactoring;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionType;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionWizardFunctionsPage;

public class MoveFunctionWizardDestinationsPage
extends UserInputWizardPage {
    private final MoveFunctionRefactoring refactoring;
    private CheckboxTreeViewer tree;
    protected static boolean displayZeros;
    private Button displayZerosCheckBox;

    MoveFunctionWizardDestinationsPage(String name, MoveFunctionRefactoring refactoring) {
        super(name);
        this.refactoring = refactoring;
        refactoring.getSettings().setType(MoveFunctionType.MODULE);
        refactoring.getSettings().setMethod(MoveFunctionMethod.LENGTH);
        refactoring.getSettings().setExcludedModuleNames(Pattern.compile(".*_types"));
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        this.initializeDialogUnits((Control)top);
        top.setLayout((Layout)new GridLayout(1, false));
        Composite comp = new Composite(top, 0);
        this.initializeDialogUnits((Control)comp);
        comp.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(comp, 0);
        label.setText("Choose method: ");
        Button shortestModule = new Button(comp, 16);
        shortestModule.setText("choose shortest module");
        shortestModule.setSelection(true);
        shortestModule.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().getMethod().equals((Object)MoveFunctionMethod.LENGTH) && !MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().isChanged()) {
                    MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().setChanged(false);
                } else {
                    MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().setMethod(MoveFunctionMethod.LENGTH);
                    MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().setChanged(true);
                }
                MoveFunctionWizardDestinationsPage.this.refreshTree();
            }
        });
        Button leastImports = new Button(comp, 16);
        leastImports.setText("insert the least new imports");
        leastImports.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().getMethod().equals((Object)MoveFunctionMethod.IMPORTS) && !MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().isChanged()) {
                    MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().setChanged(false);
                } else {
                    MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().setMethod(MoveFunctionMethod.IMPORTS);
                    MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().setChanged(true);
                }
                MoveFunctionWizardDestinationsPage.this.refreshTree();
            }
        });
        Button component = new Button(comp, 16);
        component.setText("by component");
        component.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().getMethod().equals((Object)MoveFunctionMethod.COMPONENT) && !MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().isChanged()) {
                    MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().setChanged(false);
                } else {
                    MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().setMethod(MoveFunctionMethod.COMPONENT);
                    MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().setChanged(true);
                }
                MoveFunctionWizardDestinationsPage.this.refreshTree();
            }
        });
        Label excludedModules = new Label(comp, 4);
        excludedModules.setText("Module names to exclude (separate regex expressions with a comma): ");
        final Text excludedModulesField = new Text(comp, 4);
        this.displayZerosCheckBox = new Button(comp, 32);
        this.displayZerosCheckBox.setSelection(displayZeros);
        this.displayZerosCheckBox.setText("Display destinations with 0 value");
        this.displayZerosCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                displayZeros = btn.getSelection();
                MoveFunctionWizardDestinationsPage.this.tree.refresh();
            }
        });
        Label descriptionLabel = new Label(comp, 4);
        descriptionLabel.setText("Destinations for the selected functions:");
        this.displayDestinations(top);
        excludedModulesField.setText(".*_types                              ");
        excludedModulesField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String regex = excludedModulesField.getText().replaceAll(",", "|").replaceAll(" +", " ").trim();
                try {
                    Pattern pattern = Pattern.compile(regex, 2);
                    if (MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().getExcludedModuleNames().equals(pattern) && !MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().isChanged()) {
                        MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().setChanged(false);
                    } else {
                        MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().setExcludedModuleNames(pattern);
                        MoveFunctionWizardDestinationsPage.this.refactoring.getSettings().setChanged(true);
                    }
                    MoveFunctionWizardDestinationsPage.this.refreshTree();
                    MoveFunctionWizardDestinationsPage.this.setErrorMessage(null);
                }
                catch (PatternSyntaxException exception) {
                    MoveFunctionWizardDestinationsPage.this.setErrorMessage("Regex expression is wrong.");
                }
            }
        });
        this.setTreeChecked();
        this.setErrorMessage(null);
    }

    public void displayDestinations(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.initializeDialogUnits((Control)comp);
        comp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        comp.setLayout((Layout)new FillLayout());
        this.refactoring.getDestinations();
        this.tree = new CheckboxTreeViewer(comp, 770);
        this.tree.setContentProvider((IContentProvider)new DestinationDataProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new DataLabelProvider());
        this.tree.setInput(this.refactoring.getFunctions());
        this.tree.expandToLevel(2);
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof FunctionData) {
                    if (event.getChecked()) {
                        MoveFunctionWizardDestinationsPage.this.tree.setChecked(event.getElement(), event.getChecked());
                        ((FunctionData)event.getElement()).setToBeMoved(true);
                    } else {
                        MoveFunctionWizardDestinationsPage.this.tree.setSubtreeChecked(event.getElement(), false);
                        ((FunctionData)event.getElement()).setFinalDestination(null);
                    }
                } else if (event.getElement() instanceof Destination) {
                    Destination dest = (Destination)event.getElement();
                    MoveFunctionWizardDestinationsPage.this.tree.setChecked((Object)dest, event.getChecked());
                    block0: for (Map.Entry<Module, List<FunctionData>> entry : MoveFunctionWizardDestinationsPage.this.refactoring.getFunctions().entrySet()) {
                        if (!entry.getValue().contains(dest.getFunctionData())) continue;
                        for (FunctionData fd : entry.getValue()) {
                            if (!dest.getFunctionData().equals(fd)) continue;
                            if (fd.getFinalDestination() != null && !dest.equals(fd.getFinalDestination())) {
                                MoveFunctionWizardDestinationsPage.this.tree.setChecked((Object)fd.getFinalDestination(), false);
                            }
                            if (event.getChecked()) {
                                fd.setFinalDestination(dest);
                                break block0;
                            }
                            fd.setFinalDestination(null);
                            break block0;
                        }
                    }
                }
                MoveFunctionWizardDestinationsPage.this.setTreeChecked();
            }
        });
        this.setTreeChecked();
    }

    public void refreshTree() {
        this.refactoring.getDestinations();
        this.tree.refresh();
        this.setTreeChecked();
    }

    public void setTreeChecked() {
        boolean hasDestination = false;
        for (List<FunctionData> list : this.refactoring.getFunctions().values()) {
            for (FunctionData fd : list) {
                if (fd.isToBeMoved()) {
                    this.tree.setChecked((Object)fd, true);
                    if (fd.getFinalDestination() == null) continue;
                    hasDestination = true;
                    this.tree.setChecked((Object)fd.getFinalDestination(), true);
                    continue;
                }
                this.tree.setSubtreeChecked((Object)fd, false);
            }
        }
        this.tree.refresh();
        this.setPageComplete(hasDestination);
    }

    public IWizardPage getPreviousPage() {
        IWizardPage page2 = super.getPreviousPage();
        if (page2 instanceof MoveFunctionWizardFunctionsPage) {
            ((MoveFunctionWizardFunctionsPage)page2).refreshTree();
        }
        return page2;
    }
}

