/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.modulepar;

import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.modulepar.ExtractModuleParRefactoring;
import org.eclipse.titanium.refactoring.modulepar.ExtractModuleParWizard;
import org.eclipse.ui.PlatformUI;

public class ExtractModuleParActionFromEditor
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TTCN3Editor targetEditor = Utils.getActiveEditor();
        if (targetEditor == null) {
            return null;
        }
        IFile selectedFile = Utils.getSelectedFileInEditor("ExtractModulePar");
        if (selectedFile == null) {
            return null;
        }
        IProject sourceProj = selectedFile.getProject();
        if (sourceProj == null) {
            ErrorReporter.logError((String)"ExtractModuleParActionFromEditor: Source project is null. ");
            return null;
        }
        HashSet<IProject> projsToUpdate = new HashSet<IProject>();
        projsToUpdate.add(sourceProj);
        Utils.updateASTBeforeRefactoring(projsToUpdate, "ExtractModulePar");
        ExtractModuleParRefactoring refactoring = new ExtractModuleParRefactoring(sourceProj);
        ExtractModuleParWizard wiz = new ExtractModuleParWizard();
        StructuredSelection ssel = new StructuredSelection((Object)sourceProj);
        wiz.init(PlatformUI.getWorkbench(), (IStructuredSelection)ssel);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wiz);
        dialog.open();
        boolean saveModuleParsOption = wiz.getSaveModuleParsOption();
        IProject newProj = wiz.getProject();
        if (newProj == null) {
            ErrorReporter.logError((String)"ExtractModuleParActionFromEditor: Wizard returned a null project. ");
            return null;
        }
        refactoring.setTargetProject(newProj);
        refactoring.setOption_saveModuleParList(saveModuleParsOption);
        ProjectFileHandler pfh = new ProjectFileHandler(sourceProj);
        if (pfh.projectFileExists()) {
            IFile settingsFile = sourceProj.getFile("/.TITAN_properties");
            IFile settingsCopy = newProj.getFile("/.TITAN_properties");
            try {
                if (settingsCopy.exists()) {
                    settingsCopy.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                settingsFile.copy(settingsCopy.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                ErrorReporter.logError((String)"ExtractModuleParActionFromEditor: Copying project settings to new project failed.");
            }
        }
        refactoring.perform();
        WorkspaceJob job = GlobalParser.getProjectSourceParser((IProject)newProj).analyzeAll();
        if (job != null) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        return null;
    }
}

