/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.function;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;

class StatementList
extends ASTNode
implements ILocateableNode {
    protected Location location;
    protected List<Statement> statements;
    protected StatementBlock myStatementBlock;

    protected StatementList(List<Statement> statements) {
        this.statements = statements;
        if (statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        if (!this.statements.isEmpty()) {
            Statement statement = this.statements.get(0);
            this.myStatementBlock = statement.getMyStatementBlock();
            this.location = new Location(statement.getLocation().getFile(), statement.getLocation().getLine(), statement.getLocation().getOffset(), this.statements.get(this.statements.size() - 1).getLocation().getEndOffset());
        }
    }

    protected boolean isEmpty() {
        return this.statements.isEmpty();
    }

    protected int getSize() {
        return this.statements.size();
    }

    protected Statement getStatementByIndex(int ind) {
        return this.statements.get(ind);
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    protected void increaseLocationEndOffset(int incBy) {
        this.location.setEndOffset(this.location.getEndOffset() + incBy);
    }

    public Location getLocation() {
        return this.location;
    }

    protected StatementBlock getMyStatementBlock() {
        return this.myStatementBlock;
    }

    protected boolean memberAccept(ASTVisitor v) {
        for (Statement s : this.statements) {
            if (s.accept(v)) continue;
            return false;
        }
        return true;
    }

    public String createDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExtractToFunctionRefactoring->StatementList debug info:");
        sb.append("\n  Loc: ");
        if (this.location == null) {
            sb.append("null");
        } else {
            sb.append(this.location.getFile().getFullPath());
            sb.append(": ");
            sb.append(this.location.getOffset());
            sb.append("->");
            sb.append(this.location.getEndOffset());
        }
        sb.append("\n  MySB info: ");
        if (this.myStatementBlock == null || this.myStatementBlock.getMyDefinition() == null) {
            sb.append("null");
        } else {
            sb.append(this.myStatementBlock.getMyDefinition().getIdentifier());
        }
        sb.append("\n  Statements: ");
        sb.append("(count: ");
        sb.append(this.statements.size());
        sb.append(") \n");
        for (Statement s : this.statements) {
            sb.append("    ");
            sb.append(s.getStatementName());
            sb.append(", loc: ");
            if (s.getLocation() == null) {
                sb.append("null");
            } else {
                sb.append(s.getLocation().getOffset());
                sb.append("->");
                sb.append(s.getLocation().getEndOffset());
                sb.append(" in line ");
                sb.append(s.getLocation().getLine());
            }
            sb.append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }
}

