/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.function;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.refactoring.function.ArgumentPassingType;
import org.eclipse.titanium.refactoring.function.Param;
import org.eclipse.titanium.refactoring.function.StatementList;

class ParamCollector {
    private final IProject project;
    private final StatementList selectedStatements;
    private final Module selectedModule;
    private List<Param> params;
    private final boolean removeReturnClause = false;
    private final List<RefactoringStatusEntry> warnings;

    ParamCollector(IProject project, StatementList selectedStatements, Module selectedModule) {
        this.selectedStatements = selectedStatements;
        this.selectedModule = selectedModule;
        this.project = project;
        this.warnings = new ArrayList<RefactoringStatusEntry>();
    }

    List<RefactoringStatusEntry> getWarnings() {
        return this.warnings;
    }

    List<Param> getParams() {
        return this.params;
    }

    boolean isRemoveReturnClause() {
        return false;
    }

    void perform() {
        this.params = new ArrayList<Param>();
        ParamFinder visitor = new ParamFinder();
        this.selectedStatements.accept(visitor);
    }

    private String createDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExtractToFunctionRefactoring->ParamCollector debug info: \n");
        for (Param p : this.params) {
            sb.append(p.createDebugInfo());
            sb.append('\n');
        }
        return sb.toString();
    }

    private class ParamFinder
    extends ASTVisitor {
        private static final boolean DEBUG = false;
        private StatementList toVisit;
        private final StringBuilder debugInfo = new StringBuilder();

        private ParamFinder() {
        }

        public int visit(IVisitableNode node) {
            Definition def;
            if (node instanceof StatementList) {
                this.toVisit = (StatementList)node;
            }
            if (node instanceof Undefined_LowerIdentifier_Value) {
                ((Undefined_LowerIdentifier_Value)node).getAsReference();
                return 3;
            }
            if (node instanceof Reference) {
                Reference ref = (Reference)node;
                Assignment as = ref.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                if (as instanceof Definition && this.isGoodDefType((IVisitableNode)as) && !this.isInsideRange(as.getLocation())) {
                    Definition def2 = (Definition)as;
                    if (!def2.isLocal()) {
                        return 3;
                    }
                    Assignment.Assignment_type at = null;
                    if (def2 instanceof FormalParameter) {
                        at = ((FormalParameter)def2).getAssignmentType();
                    }
                    Param p = new Param();
                    p.setDef((Definition)as);
                    p.setDeclaredInside(false);
                    p.setName(as.getIdentifier().toString());
                    if (ParamCollector.this.params.contains(p)) {
                        return 3;
                    }
                    ParamCollector.this.params.add(p);
                    ReferenceFinder refFinder = new ReferenceFinder((Assignment)def2);
                    Map refs = refFinder.findAllReferences(ParamCollector.this.selectedModule, ParamCollector.this.project, null, false);
                    p.setRefs(this.getRefsInRange(ParamCollector.this.selectedModule, refs));
                    boolean refsBeyondSelection = this.isAnyRefsAfterLocation(ParamCollector.this.selectedModule, ParamCollector.this.selectedStatements.getLocation(), refs);
                    if (at == Assignment.Assignment_type.A_PAR_TEMP_INOUT || at == Assignment.Assignment_type.A_PAR_TEMP_OUT || at == Assignment.Assignment_type.A_PAR_VAL_INOUT || at == Assignment.Assignment_type.A_PAR_VAL_OUT || refsBeyondSelection) {
                        p.setPassingType(ArgumentPassingType.INOUT);
                    } else {
                        p.setPassingType(ArgumentPassingType.IN);
                    }
                }
            } else if (node instanceof Definition && this.isGoodDefType((IVisitableNode)(def = (Definition)node))) {
                ReferenceFinder refFinder = new ReferenceFinder((Assignment)def);
                Map refs = refFinder.findAllReferences(ParamCollector.this.selectedModule, ParamCollector.this.project, null, false);
                boolean refsOutside = this.isAnyReferenceOutsideRange(ParamCollector.this.selectedModule, refs);
                if (!refsOutside) {
                    return 3;
                }
                Param p = new Param();
                p.setDef(def);
                p.setDeclaredInside(true);
                p.setName(def.getIdentifier().toString());
                if (ParamCollector.this.params.contains(p)) {
                    return 3;
                }
                ParamCollector.this.params.add(p);
                List<ISubReference> refsInRange = this.getRefsInRange(ParamCollector.this.selectedModule, refs);
                if (this.isDefWithoutInit(def) && refsInRange.isEmpty()) {
                    p.setPassingType(ArgumentPassingType.NONE);
                } else {
                    p.setPassingType(ArgumentPassingType.OUT);
                }
                p.setRefs(refsInRange);
            }
            return 3;
        }

        public String createDebugInfo() {
            StringBuilder sb = new StringBuilder();
            sb.append("ExtractToFunctionRefactoring->ParamCollector debug info: \n");
            sb.append((CharSequence)this.debugInfo);
            return sb.toString();
        }

        private boolean isGoodDefType(IVisitableNode node) {
            return node instanceof Def_Var || node instanceof Def_Const || node instanceof Def_ModulePar || node instanceof FormalParameter || node instanceof Def_Var_Template || node instanceof Def_Timer;
        }

        private boolean isAnyRefsAfterLocation(Module locationModule, Location loc, Map<Module, List<ReferenceFinder.Hit>> refs) {
            for (Map.Entry<Module, List<ReferenceFinder.Hit>> e : refs.entrySet()) {
                if (!e.getKey().equals(locationModule)) continue;
                List<ReferenceFinder.Hit> hs = e.getValue();
                ListIterator<ReferenceFinder.Hit> it = hs.listIterator();
                while (it.hasNext()) {
                    ReferenceFinder.Hit curr = it.next();
                    if (curr.reference.getLocation().getEndOffset() <= loc.getEndOffset()) continue;
                    return true;
                }
            }
            return false;
        }

        private List<ISubReference> getRefsInRange(Module module, Map<Module, List<ReferenceFinder.Hit>> refs) {
            ArrayList<ISubReference> subrefs = new ArrayList<ISubReference>();
            for (Map.Entry<Module, List<ReferenceFinder.Hit>> e : refs.entrySet()) {
                if (!e.getKey().equals(module)) continue;
                List<ReferenceFinder.Hit> hs = e.getValue();
                ListIterator<ReferenceFinder.Hit> it = hs.listIterator();
                while (it.hasNext()) {
                    ReferenceFinder.Hit curr = it.next();
                    if (!this.isInsideRange(curr.reference.getLocation())) continue;
                    Reference r = curr.reference;
                    if (r.getSubreferences().isEmpty()) {
                        ErrorReporter.logError((String)"ParamCollector::getRefsInRange(): No subrefs found in a reference! ");
                        continue;
                    }
                    subrefs.add((ISubReference)r.getSubreferences().get(0));
                }
            }
            return subrefs;
        }

        private boolean isAnyReferenceOutsideRange(Module moduleOfRange, Map<Module, List<ReferenceFinder.Hit>> refs) {
            if (this.toVisit == null) {
                ErrorReporter.logError((String)"ParamFinderVisitor::isAnyReferenceOutsideRange(): StatementList 'toVisit' is null! ");
                return false;
            }
            for (Map.Entry<Module, List<ReferenceFinder.Hit>> e : refs.entrySet()) {
                if (!e.getKey().equals(moduleOfRange)) {
                    return true;
                }
                List<ReferenceFinder.Hit> hs = e.getValue();
                for (ReferenceFinder.Hit h : hs) {
                    if (this.isInsideRange(h.reference.getLocation())) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isInsideRange(Location toCheck) {
            if (this.toVisit == null) {
                ErrorReporter.logError((String)"ParamFinderVisitor::isInsideRange(): StatementList 'toVisit' is null! ");
                return false;
            }
            Location range = this.toVisit.getLocation();
            return toCheck.getOffset() >= range.getOffset() && toCheck.getEndOffset() <= range.getEndOffset();
        }

        private boolean isDefWithoutInit(Definition toCheck) {
            if (toCheck == null) {
                return false;
            }
            return toCheck.getLocation().getEndOffset() == toCheck.getIdentifier().getLocation().getEndOffset();
        }
    }
}

