/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class ReadOnlyLocal {
    private ReadOnlyLocal() {
        throw new AssertionError((Object)"Noninstantiable");
    }

    public static class VarTemplate
    extends BaseModuleCodeSmellSpotter {
        public static final String READONLY = "The {0} seems to be never written, maybe it could be a template";

        public VarTemplate() {
            super(CodeSmellType.READONLY_LOC_VARIABLE);
        }

        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            Def_Var_Template s;
            if (node instanceof Def_Var_Template && !(s = (Def_Var_Template)node).getWritten()) {
                String msg = MessageFormat.format(READONLY, s.getDescription());
                problems.report(s.getIdentifier().getLocation(), msg);
            }
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(Def_Var_Template.class);
            return ret;
        }
    }

    public static class Var
    extends BaseModuleCodeSmellSpotter {
        public static final String READONLY = "The {0} seems to be never written, maybe it could be a constant";

        public Var() {
            super(CodeSmellType.READONLY_LOC_VARIABLE);
        }

        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            Def_Var s;
            if (node instanceof Def_Var && !((s = (Def_Var)node).getMyScope() instanceof ComponentTypeBody) && !s.getWritten()) {
                Value initialValue = s.getInitialValue();
                CompilationTimeStamp ct = CompilationTimeStamp.getBaseTimestamp();
                if (initialValue != null && !initialValue.getIsErroneous(ct) && !initialValue.isUnfoldable(ct)) {
                    String msg = MessageFormat.format(READONLY, s.getDescription());
                    problems.report(s.getIdentifier().getLocation(), msg);
                }
            }
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(Def_Var.class);
            return ret;
        }
    }
}

