/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.error;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.error.ConsoleErrorHandler;
import org.eclipse.titanium.error.ErrorHandler;

public class PrimitiveErrorHandler
implements ErrorHandler {
    public static final String ERROR_PATH = "error.log";
    private ErrorHandler handler;

    public PrimitiveErrorHandler() {
        try {
            File errorLog = new File(ERROR_PATH);
            PrintStream errorStream = new PrintStream(errorLog);
            this.handler = new ConsoleErrorHandler(errorStream, errorStream, errorStream);
        }
        catch (IOException ex) {
            ErrorReporter.logExceptionStackTrace((String)"Error while printing to error.log", (Throwable)ex);
            this.handler = new ConsoleErrorHandler();
        }
    }

    @Override
    public void reportException(String context, Exception exception) {
        this.handler.reportException(context, exception);
    }

    @Override
    public void reportErrorMessage(String text) {
        this.handler.reportErrorMessage(text);
    }

    @Override
    public void reportWarning(String text) {
        this.handler.reportWarning(text);
    }

    @Override
    public void reportInformation(String text) {
        this.handler.reportInformation(text);
    }

    @Override
    public void logError(String message) {
        this.handler.logError(message);
    }

    @Override
    public void logException(Exception exception) {
        this.handler.logException(exception);
    }

    @Override
    public void writeMessageToLog() {
        this.handler.writeMessageToLog();
    }
}

