/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.applications;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.utils.ProjectAnalyzerJob;
import org.eclipse.titanium.utils.SonarDataExporter;

public class ExportDataForSonar
implements IApplication {
    private List<IProject> projectsToExport = new ArrayList<IProject>();

    private boolean checkParameters(String[] args) {
        if (args.length == 0) {
            this.projectsToExport = this.getAllAccessibleProjects();
            return true;
        }
        if (args.length != 2) {
            this.printUsage();
            return false;
        }
        if (!"-p".equals(args[0]) && "--projects".equals(args[0])) {
            this.printUsage();
            return false;
        }
        List<String> projectNames = Arrays.asList(args[1].split(","));
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (String name : projectNames) {
            IProject project = wsRoot.getProject(name);
            if (!project.isAccessible()) {
                System.out.println("Project '" + name + "' is not accessible.");
                return false;
            }
            this.projectsToExport.add(project);
        }
        return true;
    }

    private void printUsage() {
        String applicationName = ExportDataForSonar.class.getCanonicalName();
        System.out.println("Usage: ./eclipse " + applicationName + " [-p project1,project2,...,projectN]");
    }

    private void exportInformationForProject(String[] args, IProject project, IProgressMonitor monitor) {
        SonarDataExporter exporter = new SonarDataExporter(project);
        try {
            exporter.exportDataForProject();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((String)("Error while exporting data for project " + project.getName()), (Throwable)e);
        }
    }

    private List<IProject> getAllAccessibleProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> existingProjects = new ArrayList<IProject>();
        for (IProject project : projects) {
            if (!project.isAccessible()) continue;
            existingProjects.add(project);
        }
        return existingProjects;
    }

    public Object start(IApplicationContext context) throws Exception {
        Platform.getBundle((String)"org.eclipse.titan.designer").start();
        final String[] args = (String[])context.getArguments().get("application.args");
        if (!this.checkParameters(args)) {
            return -1;
        }
        for (IProject project : this.projectsToExport) {
            ProjectAnalyzerJob job = new ProjectAnalyzerJob("Exporting information for project " + project.getName()){

                @Override
                public IStatus doPostWork(IProgressMonitor monitor) {
                    System.out.println("Exporting information for " + this.getProject().getName());
                    ExportDataForSonar.this.exportInformationForProject(args, this.getProject(), monitor);
                    return Status.OK_STATUS;
                }
            }.quickSchedule(project);
            job.join();
        }
        boolean result = true;
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while closing workspace", (Throwable)e);
            result = false;
        }
        if (result) {
            System.out.println("All information is succesfully exported.");
            return EXIT_OK;
        }
        System.err.println("The export wasn't successfull, see zour workspace1s errorlog for details");
        return -1;
    }

    public void stop() {
    }
}

