/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.core.TITANJavaBuilder;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.pages.ConfigurationManagerControl;
import org.eclipse.titan.designer.properties.pages.InternalJavaCreationTab;
import org.eclipse.titan.designer.properties.pages.JavaCreationTab;
import org.eclipse.titan.designer.wizards.projectFormat.TITANAutomaticProjectExporter;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectJavaBuildPropertyPage
extends PropertyPage {
    public static final String BUILDER_IS_ENABLED = "This TITAN project has the TITAN Java builder enabled.";
    public static final String BUILDER_IS_NOT_ENABLED = "This TITAN project has the TITAN Java builder disabled.";
    private Composite pageComposite;
    private Label headLabel;
    private TabFolder makefileOperationsTabFolder;
    private InternalJavaCreationTab internalMakefileCreationTab;
    private JavaCreationTab javaCreationTab;
    private final PreferenceStore tempStorage = new PreferenceStore();
    private IProject projectResource;
    private ConfigurationManagerControl configurationManager;
    private String firstConfiguration;

    public void dispose() {
        this.headLabel.dispose();
        this.javaCreationTab.dispose();
        this.internalMakefileCreationTab.dispose();
        this.makefileOperationsTabFolder.dispose();
        this.pageComposite.dispose();
        super.dispose();
    }

    protected void copyPropertyStore() {
        this.javaCreationTab.copyPropertyStore(this.projectResource, this.tempStorage);
        this.internalMakefileCreationTab.copyPropertyStore(this.projectResource, this.tempStorage);
    }

    protected void copyProjectPersistentProperty(String propertyName) {
        String temp = null;
        try {
            temp = this.projectResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", propertyName));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        if (temp != null) {
            this.tempStorage.setValue(propertyName, temp);
        }
    }

    protected boolean evaluatePersistentProperty(String propertyName) {
        String actualValue = null;
        String copyValue = null;
        try {
            actualValue = this.projectResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", propertyName));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        copyValue = this.tempStorage.getString(propertyName);
        return actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            return;
        }
        if (this.configurationManager != null) {
            this.configurationManager.refresh();
        }
        super.setVisible(visible);
    }

    protected void evaluatePropertyStore() {
        boolean configurationChanged;
        boolean bl = configurationChanged = !this.firstConfiguration.equals(this.configurationManager.getActualSelection());
        if (configurationChanged) {
            PropertyNotificationManager.firePropertyChange((IResource)this.projectResource);
        }
    }

    public void changeConfiguration(String configuration) {
        this.configurationManager.changeActualConfiguration();
        this.copyPropertyStore();
        this.loadProperties();
        this.updateContents();
        this.checkProperties();
        PropertyNotificationManager.firePropertyChange((IResource)this.projectResource);
    }

    protected Control createContents(Composite parent) {
        this.projectResource = (IProject)this.getElement();
        this.pageComposite = new Composite(parent, 0);
        GridLayout pageCompositeLayout = new GridLayout();
        pageCompositeLayout.numColumns = 1;
        this.pageComposite.setLayout((Layout)pageCompositeLayout);
        GridData pageCompositeGridData = new GridData();
        pageCompositeGridData.horizontalAlignment = 4;
        pageCompositeGridData.verticalAlignment = 4;
        pageCompositeGridData.grabExcessHorizontalSpace = true;
        pageCompositeGridData.grabExcessVerticalSpace = true;
        this.pageComposite.setLayoutData((Object)pageCompositeGridData);
        if (TITANJavaBuilder.isBuilderEnabled(this.projectResource)) {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText(BUILDER_IS_ENABLED);
        } else {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText(BUILDER_IS_NOT_ENABLED);
        }
        try {
            String loadLocation = this.projectResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "loadLocation"));
            if (loadLocation == null) {
                this.headLabel.setText(this.headLabel.getText() + "\nWas not yet saved ");
            } else {
                this.headLabel.setText(this.headLabel.getText() + "\nWas loaded from " + loadLocation);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        this.configurationManager = new ConfigurationManagerControl(this.pageComposite, this.projectResource);
        this.configurationManager.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProjectJavaBuildPropertyPage.this.configurationManager.hasConfigurationChanged()) {
                    ProjectJavaBuildPropertyPage.this.changeConfiguration(ProjectJavaBuildPropertyPage.this.configurationManager.getActualSelection());
                }
            }
        });
        this.firstConfiguration = this.configurationManager.getActualSelection();
        this.makefileOperationsTabFolder = new TabFolder(this.pageComposite, 2048);
        GridData makefileOperationsTabFolderGridData = new GridData();
        makefileOperationsTabFolderGridData.horizontalAlignment = 4;
        makefileOperationsTabFolderGridData.verticalAlignment = 4;
        makefileOperationsTabFolderGridData.grabExcessHorizontalSpace = true;
        makefileOperationsTabFolderGridData.grabExcessVerticalSpace = true;
        this.makefileOperationsTabFolder.setLayoutData((Object)makefileOperationsTabFolderGridData);
        this.javaCreationTab = new JavaCreationTab(this.projectResource);
        this.javaCreationTab.createContents(this.makefileOperationsTabFolder);
        this.internalMakefileCreationTab = new InternalJavaCreationTab(this.projectResource);
        this.internalMakefileCreationTab.createContents(this.makefileOperationsTabFolder);
        this.copyPropertyStore();
        this.loadProperties();
        this.updateContents();
        this.checkProperties();
        return this.pageComposite;
    }

    protected void updateContents() {
    }

    protected void performDefaults() {
        this.javaCreationTab.performDefaults(this.projectResource);
        this.internalMakefileCreationTab.performDefaults();
        this.configurationManager.saveActualConfiguration();
    }

    public boolean performOk() {
        if (!this.checkProperties()) {
            return false;
        }
        if (!this.saveProperties()) {
            return false;
        }
        IPreferenceStore pluginPreferenceStore = Activator.getDefault().getPreferenceStore();
        if (!pluginPreferenceStore.isDefault("org.eclipse.titan.designer.temporalTargetExecutable")) {
            pluginPreferenceStore.setToDefault("org.eclipse.titan.designer.temporalTargetExecutable");
        }
        if (!pluginPreferenceStore.isDefault("org.eclipse.titan.designer.temporalMakefileUpdateScript")) {
            pluginPreferenceStore.setToDefault("org.eclipse.titan.designer.temporalMakefileUpdateScript");
        }
        if (!pluginPreferenceStore.isDefault("org.eclipse.titan.designer.temporalMakefileFlags")) {
            pluginPreferenceStore.setToDefault("org.eclipse.titan.designer.temporalMakefileFlags");
        }
        if (!pluginPreferenceStore.isDefault("org.eclipse.titan.designer.temporalWorkingDir")) {
            pluginPreferenceStore.setToDefault("org.eclipse.titan.designer.temporalWorkingDir");
        }
        if (!pluginPreferenceStore.isDefault("org.eclipse.titan.designer.temporalJavaTarget")) {
            pluginPreferenceStore.setToDefault("org.eclipse.titan.designer.temporalJavaTarget");
        }
        this.configurationManager.saveActualConfiguration();
        ProjectDocumentHandlingUtility.saveDocument(this.projectResource);
        TITANAutomaticProjectExporter.saveAllAutomatically(this.projectResource);
        this.evaluatePropertyStore();
        return true;
    }

    public boolean performCancel() {
        this.loadProperties();
        this.evaluatePropertyStore();
        this.configurationManager.clearActualConfiguration();
        return true;
    }

    public void loadProperty(String propertyName, Button button) {
        String temp = "";
        try {
            temp = this.projectResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", propertyName));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        button.setSelection("true".equals(temp));
    }

    public void loadProperties() {
        this.javaCreationTab.loadProperties(this.projectResource);
        this.internalMakefileCreationTab.loadProperties(this.projectResource);
    }

    public boolean saveProperty(String propertyName, Button button) {
        String temp = button.getSelection() ? "true" : "false";
        try {
            this.projectResource.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", propertyName), temp);
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
            return false;
        }
        return true;
    }

    public boolean checkProperties() {
        boolean result = true;
        result &= this.javaCreationTab.checkProperties(this);
        return result &= this.internalMakefileCreationTab.checkProperties(this);
    }

    public boolean saveProperties() {
        boolean success = true;
        success &= this.javaCreationTab.saveProperties(this.projectResource);
        this.setErrorMessage(null);
        return success &= this.internalMakefileCreationTab.saveProperties(this.projectResource);
    }
}

