/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.pages.BaseNamingConventionPropertyPage;
import org.eclipse.titan.designer.properties.pages.ConfigurationManagerControl;
import org.eclipse.titan.designer.properties.pages.PropertyStore;
import org.eclipse.titan.designer.wizards.projectFormat.TITANAutomaticProjectExporter;

public class FolderNamingConventionPropertyPage
extends BaseNamingConventionPropertyPage {
    private static final String DESCRIPTION = "Folder specific naming convention related preferences of the on-the-fly checker.\nAll options use Java regular expressions.";
    private static final String ENABLEFOLDERSPECIFIC = "Enable folder specific settings";
    private ConfigurationManagerControl configurationManager;
    private String firstConfiguration;

    public FolderNamingConventionPropertyPage() {
        super(1);
        this.setDescription(DESCRIPTION);
    }

    @Override
    protected String getPageId() {
        return "org.eclipse.titan.designer.Properties.Folder.NamingConventions";
    }

    public void changeConfiguration(String configuration) {
        this.configurationManager.changeActualConfiguration();
        this.resetPreferenceStore();
        this.initialize();
        PropertyNotificationManager.firePropertyChange((IResource)((IFolder)this.getElement()));
    }

    protected void createFieldEditors() {
        Composite tempParent = this.getFieldEditorParent();
        IFolder folder = (IFolder)this.getElement();
        this.configurationManager = new ConfigurationManagerControl(tempParent, folder.getProject());
        this.configurationManager.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FolderNamingConventionPropertyPage.this.configurationManager.hasConfigurationChanged()) {
                    FolderNamingConventionPropertyPage.this.changeConfiguration(FolderNamingConventionPropertyPage.this.configurationManager.getActualSelection());
                }
            }
        });
        this.firstConfiguration = this.configurationManager.getActualSelection();
        BooleanFieldEditor booleanedit = new BooleanFieldEditor("org.eclipse.titan.designer.enableFolderSpecificNamingConventions", ENABLEFOLDERSPECIFIC, tempParent);
        booleanedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                FolderNamingConventionPropertyPage.this.setChanged(true);
            }
        });
        this.addField((FieldEditor)booleanedit);
        this.createNamingConventionBody(tempParent);
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            return;
        }
        if (this.configurationManager != null) {
            this.configurationManager.refresh();
        }
        super.setVisible(visible);
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.configurationManager.saveActualConfiguration();
    }

    public boolean performCancel() {
        this.configurationManager.clearActualConfiguration();
        this.resetPreferenceStore();
        this.initialize();
        return super.performCancel();
    }

    @Override
    public boolean performOk() {
        boolean configurationChanged;
        IFolder folder = (IFolder)this.getElement();
        boolean result = super.performOk();
        IPreferenceStore store = this.getPreferenceStore();
        if (store instanceof PropertyStore) {
            try {
                ((PropertyStore)store).save();
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        IProject project = folder.getProject();
        this.configurationManager.saveActualConfiguration();
        ProjectDocumentHandlingUtility.saveDocument(project);
        TITANAutomaticProjectExporter.saveAllAutomatically(project);
        boolean bl = configurationChanged = !this.firstConfiguration.equals(this.configurationManager.getActualSelection());
        if (configurationChanged || this.getChanged() && this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.useOnTheFlyParsing")) {
            this.setChanged(false);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning(null, (String)"Naming convention settings changed", (String)"Naming convention settings have changed, the known projects have to be re-analyzed completly.\nThis might take some time.");
                }
            });
            NamingConventionHelper.clearCaches();
            PropertyNotificationManager.firePropertyChange((IResource)project);
        }
        return result;
    }
}

