/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.preferences.PreferenceHandler;
import org.eclipse.titan.designer.preferences.PreferenceInitializer;
import org.eclipse.titan.designer.preferences.pages.SyntaxHighlightColoringElement;
import org.eclipse.titan.designer.preferences.pages.SyntaxHighlightColoringGroup;
import org.eclipse.titan.designer.preferences.pages.SyntaxHighlightContentProvider;
import org.eclipse.titan.designer.preferences.pages.SyntaxhighlightLabelProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class SyntaxHighlightPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String TEMPLATE_CODE = "// TTCN-3 version of \"Hello, world!\"\n/**\n * @desc Demo module\n * @status deprecated\n * @url https://projects.eclipse.org/projects/tools.titan\n * @author AK, MM\n */\nmodule MyExample {\ntype port PCOType message {\n  inout charstring;\n}\n\ntype component MTCType {\n  port PCOType MyPCO_PT;\n}\n\ntype record MyRecord {\n  integer x1,\n  charstring c2\n}\n\ntype enumerated WorkDays { Monday, Tuesday, Wednesday, Thursday, Friday }\n\nmodulepar integer modPar := 9;\nconst integer c_integer := 33;\n\npublic function myFunction(integer x, charstring y) return integer {\n  return x;\n}\n\ntype class BaseClass {\n  private var integer f1;\n  const integer myConst;\n  public var MyRecord myRecord;\n}\n\ntestcase tc_HelloW() runs on MTCType system MTCType {\n  timer TL_T := 15.0;\n  map(mtc:MyPCO_PT, system:MyPCO_PT);\n  MyPCO_PT.send(\"Hello, world!\");\n  TL_T.start;\n  alt {\n    [] MyPCO_PT.receive(\"Hello, TTCN-3!\") { TL_T.stop; setverdict(pass); }\n    [] TL_T.timeout { setverdict(inconc); }\n    [] MyPCO_PT.receive { TL_T.stop; setverdict(fail); }\n  }\n}\n\ncontrol {\n  execute(tc_HelloW());\n}\n}\n";
    private Map<String, List<StyleRange>> rangeMap = new HashMap<String, List<StyleRange>>();
    private static final String ENABLE_SEMANTIC_HIGHLIGHTING = "Enable semantic highlighting (EXPERIMENTAL)";
    private Composite pageComposite;
    private Composite upperHalfComposite;
    private Composite colorEditorsComposite;
    private ColorFieldEditor foregroundColorEditor;
    private ColorFieldEditor backgroundColorEditor;
    private BooleanFieldEditor isEnabled;
    private BooleanFieldEditor useBackgroundColor;
    private BooleanFieldEditor isBold;
    private BooleanFieldEditor isItalic;
    private BooleanFieldEditor isStrikethrough;
    private BooleanFieldEditor isUnderline;
    private TreeViewer treeViewer;
    private StyledText textViewer;
    private SyntaxhighlightLabelProvider labelProvider;
    private Label previewLabel;
    private BooleanFieldEditor enableSemanticHighlighting;
    private PreferenceStore tempstore;
    private final Map<String, String> possiblyChangedPreferences = new HashMap<String, String>();
    private ColorManager colorManager = new ColorManager();
    private SyntaxHighlightColoringElement element = null;
    private SyntaxHighlightColoringGroup ttcn3SemanticGroup = null;
    private final ISelectionChangedListener treeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            if (event.getSelection().isEmpty()) {
                return;
            }
            if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1 && selection.getFirstElement() instanceof SyntaxHighlightColoringElement) {
                SyntaxHighlightPage.this.element = (SyntaxHighlightColoringElement)selection.getFirstElement();
                switch (SyntaxHighlightPage.this.element.getBasePreferenceKey()) {
                    case "org.eclipse.titan.designer.color.ast_constant": 
                    case "org.eclipse.titan.designer.color.ast_deftype": 
                    case "org.eclipse.titan.designer.color.ast_deprecated": 
                    case "org.eclipse.titan.designer.color.ast_unused": 
                    case "org.eclipse.titan.designer.color.ast_variable": {
                        SyntaxHighlightPage.this.isEnabled.setEnabled(true, SyntaxHighlightPage.this.colorEditorsComposite);
                        break;
                    }
                    default: {
                        SyntaxHighlightPage.this.isEnabled.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
                    }
                }
                SyntaxHighlightPage.this.loadIntoTemp(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".enabled");
                SyntaxHighlightPage.this.isEnabled.setPreferenceName(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".enabled");
                SyntaxHighlightPage.this.isEnabled.load();
                SyntaxHighlightPage.this.foregroundColorEditor.setEnabled(true, SyntaxHighlightPage.this.colorEditorsComposite);
                SyntaxHighlightPage.this.loadIntoTemp(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".foreground");
                SyntaxHighlightPage.this.foregroundColorEditor.setPreferenceName(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".foreground");
                SyntaxHighlightPage.this.foregroundColorEditor.load();
                SyntaxHighlightPage.this.useBackgroundColor.setEnabled(true, SyntaxHighlightPage.this.colorEditorsComposite);
                SyntaxHighlightPage.this.loadIntoTemp(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".usebackgroundcolor");
                SyntaxHighlightPage.this.useBackgroundColor.setPreferenceName(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".usebackgroundcolor");
                SyntaxHighlightPage.this.useBackgroundColor.load();
                SyntaxHighlightPage.this.backgroundColorEditor.setEnabled(SyntaxHighlightPage.this.useBackgroundColor.getBooleanValue(), SyntaxHighlightPage.this.colorEditorsComposite);
                SyntaxHighlightPage.this.loadIntoTemp(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".background");
                SyntaxHighlightPage.this.backgroundColorEditor.setPreferenceName(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".background");
                SyntaxHighlightPage.this.backgroundColorEditor.load();
                SyntaxHighlightPage.this.isBold.setEnabled(true, SyntaxHighlightPage.this.colorEditorsComposite);
                SyntaxHighlightPage.this.loadIntoTemp(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".bold");
                SyntaxHighlightPage.this.isBold.setPreferenceName(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".bold");
                SyntaxHighlightPage.this.isBold.load();
                SyntaxHighlightPage.this.isItalic.setEnabled(true, SyntaxHighlightPage.this.colorEditorsComposite);
                SyntaxHighlightPage.this.loadIntoTemp(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".italic");
                SyntaxHighlightPage.this.isItalic.setPreferenceName(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".italic");
                SyntaxHighlightPage.this.isItalic.load();
                SyntaxHighlightPage.this.isStrikethrough.setEnabled(true, SyntaxHighlightPage.this.colorEditorsComposite);
                SyntaxHighlightPage.this.loadIntoTemp(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".strikethrough");
                SyntaxHighlightPage.this.isStrikethrough.setPreferenceName(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".strikethrough");
                SyntaxHighlightPage.this.isStrikethrough.load();
                SyntaxHighlightPage.this.isUnderline.setEnabled(true, SyntaxHighlightPage.this.colorEditorsComposite);
                SyntaxHighlightPage.this.loadIntoTemp(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".underline");
                SyntaxHighlightPage.this.isUnderline.setPreferenceName(SyntaxHighlightPage.this.element.getBasePreferenceKey() + ".underline");
                SyntaxHighlightPage.this.isUnderline.load();
                SyntaxHighlightPage.this.updateStyleRanges();
                return;
            }
            SyntaxHighlightPage.this.isEnabled.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
            SyntaxHighlightPage.this.foregroundColorEditor.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
            SyntaxHighlightPage.this.backgroundColorEditor.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
            SyntaxHighlightPage.this.useBackgroundColor.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
            SyntaxHighlightPage.this.isBold.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
            SyntaxHighlightPage.this.isItalic.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
            SyntaxHighlightPage.this.isStrikethrough.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
            SyntaxHighlightPage.this.isUnderline.setEnabled(false, SyntaxHighlightPage.this.colorEditorsComposite);
        }
    };

    private void loadIntoTemp(String preferenceName) {
        if (!this.possiblyChangedPreferences.containsKey(preferenceName)) {
            this.tempstore.setValue(preferenceName, this.getPreferenceStore().getString(preferenceName));
        }
    }

    private void storeIntoFinal(String preferenceName) {
        this.getPreferenceStore().setValue(preferenceName, this.tempstore.getString(preferenceName));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.tempstore = new PreferenceStore();
        TempPreferenceInitializer initializer = new TempPreferenceInitializer();
        initializer.initializeDefaultPreferences();
    }

    public boolean performOk() {
        for (String changedKey : this.possiblyChangedPreferences.keySet()) {
            this.storeIntoFinal(changedKey);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        String[] preferenceNames;
        for (String preferenceName : preferenceNames = this.tempstore.preferenceNames()) {
            this.tempstore.setValue(preferenceName, this.tempstore.getDefaultString(preferenceName));
            this.possiblyChangedPreferences.put(preferenceName, null);
        }
        if (this.isEnabled != null) {
            this.isEnabled.loadDefault();
        }
        if (this.foregroundColorEditor != null) {
            this.foregroundColorEditor.loadDefault();
        }
        if (this.backgroundColorEditor != null) {
            this.backgroundColorEditor.loadDefault();
        }
        if (this.useBackgroundColor != null) {
            this.useBackgroundColor.loadDefault();
        }
        if (this.isBold != null) {
            this.isBold.loadDefault();
        }
        if (this.isItalic != null) {
            this.isItalic.loadDefault();
        }
        if (this.isStrikethrough != null) {
            this.isStrikethrough.loadDefault();
        }
        if (this.isUnderline != null) {
            this.isUnderline.loadDefault();
        }
        this.enableSemanticHighlighting.loadDefault();
        super.performDefaults();
    }

    public void dispose() {
        this.isEnabled.dispose();
        this.foregroundColorEditor.dispose();
        this.backgroundColorEditor.dispose();
        this.useBackgroundColor.dispose();
        this.isBold.dispose();
        this.isItalic.dispose();
        this.isStrikethrough.dispose();
        this.isUnderline.dispose();
        this.previewLabel.dispose();
        this.textViewer.dispose();
        this.labelProvider.dispose();
        this.colorEditorsComposite.dispose();
        this.upperHalfComposite.dispose();
        this.enableSemanticHighlighting.dispose();
        this.pageComposite.dispose();
        super.dispose();
    }

    private void createTreeViewer(Composite parent) {
        GridLayout treeLayout = new GridLayout();
        treeLayout.numColumns = 2;
        GridData treeData = new GridData();
        treeData.horizontalAlignment = 4;
        treeData.verticalAlignment = 4;
        treeData.grabExcessHorizontalSpace = true;
        treeData.grabExcessVerticalSpace = true;
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.getControl().setLayoutData((Object)treeData);
        this.treeViewer.setContentProvider((IContentProvider)new SyntaxHighlightContentProvider());
        this.labelProvider = new SyntaxhighlightLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setInput((Object)this.initialInput());
        this.treeViewer.addSelectionChangedListener(this.treeListener);
    }

    private void createColorEditors(Composite parent) {
        this.colorEditorsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.colorEditorsComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.colorEditorsComposite.setLayoutData((Object)gridData);
        this.loadIntoTemp("org.eclipse.titan.designer.color.ttcn3_keywords.enabled");
        this.isEnabled = new BooleanFieldEditor("org.eclipse.titan.designer.color.ttcn3_keywords.enabled", "Enable semantic highlighting for this type", 32, this.colorEditorsComposite);
        this.isEnabled.setEnabled(false, this.colorEditorsComposite);
        this.isEnabled.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.isEnabled.setPage((DialogPage)this);
        this.isEnabled.load();
        this.isEnabled.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.isEnabled.getPreferenceName(), null);
                SyntaxHighlightPage.this.isEnabled.store();
                if (SyntaxHighlightPage.this.element != null) {
                    SyntaxHighlightPage.this.updateStyleRanges();
                }
            }
        });
        this.loadIntoTemp("org.eclipse.titan.designer.color.ttcn3_keywords.foreground");
        this.foregroundColorEditor = new ColorFieldEditor("org.eclipse.titan.designer.color.ttcn3_keywords.foreground", "Color:", this.colorEditorsComposite);
        this.foregroundColorEditor.setEnabled(false, this.colorEditorsComposite);
        this.foregroundColorEditor.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.foregroundColorEditor.setPage((DialogPage)this);
        this.foregroundColorEditor.load();
        this.foregroundColorEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.foregroundColorEditor.getPreferenceName(), null);
                SyntaxHighlightPage.this.foregroundColorEditor.store();
                if (SyntaxHighlightPage.this.element != null) {
                    SyntaxHighlightPage.this.updateStyleRanges();
                }
            }
        });
        this.loadIntoTemp("org.eclipse.titan.designer.color.ttcn3_keywords.usebackgroundcolor");
        this.useBackgroundColor = new BooleanFieldEditor("org.eclipse.titan.designer.color.ttcn3_keywords.usebackgroundcolor", "Enable background color", 32, this.colorEditorsComposite);
        this.useBackgroundColor.setEnabled(false, this.colorEditorsComposite);
        this.useBackgroundColor.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.useBackgroundColor.setPage((DialogPage)this);
        this.useBackgroundColor.load();
        this.useBackgroundColor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.useBackgroundColor.getPreferenceName(), null);
                SyntaxHighlightPage.this.useBackgroundColor.store();
                SyntaxHighlightPage.this.backgroundColorEditor.setEnabled(SyntaxHighlightPage.this.useBackgroundColor.getBooleanValue(), SyntaxHighlightPage.this.colorEditorsComposite);
                SyntaxHighlightPage.this.updateStyleRanges();
            }
        });
        this.loadIntoTemp("org.eclipse.titan.designer.color.ttcn3_keywords.background");
        this.backgroundColorEditor = new ColorFieldEditor("org.eclipse.titan.designer.color.ttcn3_keywords.background", "Background color:", this.colorEditorsComposite);
        this.backgroundColorEditor.setEnabled(false, this.colorEditorsComposite);
        this.backgroundColorEditor.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.backgroundColorEditor.setPage((DialogPage)this);
        this.backgroundColorEditor.load();
        this.backgroundColorEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.backgroundColorEditor.getPreferenceName(), null);
                SyntaxHighlightPage.this.backgroundColorEditor.store();
                if (SyntaxHighlightPage.this.element != null) {
                    SyntaxHighlightPage.this.updateStyleRanges();
                }
            }
        });
        this.loadIntoTemp("org.eclipse.titan.designer.color.ttcn3_keywords.bold");
        this.isBold = new BooleanFieldEditor("org.eclipse.titan.designer.color.ttcn3_keywords.bold", "Bold", 32, this.colorEditorsComposite);
        this.isBold.setEnabled(false, this.colorEditorsComposite);
        this.isBold.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.isBold.setPage((DialogPage)this);
        this.isBold.load();
        this.isBold.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.isBold.getPreferenceName(), null);
                SyntaxHighlightPage.this.isBold.store();
                if (SyntaxHighlightPage.this.element != null) {
                    SyntaxHighlightPage.this.updateStyleRanges();
                }
            }
        });
        this.loadIntoTemp("org.eclipse.titan.designer.color.ttcn3_keywords.italic");
        this.isItalic = new BooleanFieldEditor("org.eclipse.titan.designer.color.ttcn3_keywords.italic", "Italic", 32, this.colorEditorsComposite);
        this.isItalic.setEnabled(false, this.colorEditorsComposite);
        this.isItalic.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.isItalic.setPage((DialogPage)this);
        this.isItalic.load();
        this.isItalic.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.isItalic.getPreferenceName(), null);
                SyntaxHighlightPage.this.isItalic.store();
                if (SyntaxHighlightPage.this.element != null) {
                    SyntaxHighlightPage.this.updateStyleRanges();
                }
            }
        });
        this.loadIntoTemp("org.eclipse.titan.designer.color.ttcn3_keywords.strikethrough");
        this.isStrikethrough = new BooleanFieldEditor("org.eclipse.titan.designer.color.ttcn3_keywords.strikethrough", "Striketrough", 32, this.colorEditorsComposite);
        this.isStrikethrough.setEnabled(false, this.colorEditorsComposite);
        this.isStrikethrough.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.isStrikethrough.setPage((DialogPage)this);
        this.isStrikethrough.load();
        this.isStrikethrough.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.isStrikethrough.getPreferenceName(), null);
                SyntaxHighlightPage.this.isStrikethrough.store();
                if (SyntaxHighlightPage.this.element != null) {
                    SyntaxHighlightPage.this.updateStyleRanges();
                }
            }
        });
        this.loadIntoTemp("org.eclipse.titan.designer.color.ttcn3_keywords.underline");
        this.isUnderline = new BooleanFieldEditor("org.eclipse.titan.designer.color.ttcn3_keywords.underline", "Underline", 32, this.colorEditorsComposite);
        this.isUnderline.setEnabled(false, this.colorEditorsComposite);
        this.isUnderline.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.isUnderline.setPage((DialogPage)this);
        this.isUnderline.load();
        this.isUnderline.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.isUnderline.getPreferenceName(), null);
                SyntaxHighlightPage.this.isUnderline.store();
                if (SyntaxHighlightPage.this.element != null) {
                    SyntaxHighlightPage.this.updateStyleRanges();
                }
            }
        });
        GridData wordsGridData = new GridData();
        wordsGridData.horizontalAlignment = 4;
        wordsGridData.verticalAlignment = 4;
        wordsGridData.horizontalSpan = 2;
        this.previewLabel = new Label(this.colorEditorsComposite, 4);
        this.previewLabel.setText("Preview: ");
        this.previewLabel.setVisible(true);
        this.previewLabel.setLayoutData((Object)wordsGridData);
        wordsGridData = new GridData();
        wordsGridData.horizontalAlignment = 4;
        wordsGridData.verticalAlignment = 4;
        wordsGridData.horizontalSpan = 2;
        wordsGridData.grabExcessHorizontalSpace = true;
        wordsGridData.grabExcessVerticalSpace = true;
        this.textViewer = new StyledText(this.colorEditorsComposite, 2634);
        this.textViewer.setEditable(false);
        this.textViewer.setLayoutData((Object)wordsGridData);
        Color bgColor = PreferenceHandler.getEditorBackgroundColor();
        if (bgColor != null) {
            this.textViewer.setBackground(bgColor);
        }
        this.textViewer.setFont(JFaceResources.getTextFont());
        this.fillTemplateText();
        IPreferenceStore defaultStore = Activator.getDefault().getPreferenceStore();
        for (Map.Entry<String, List<StyleRange>> entry : this.rangeMap.entrySet()) {
            String key = entry.getKey();
            this.tempstore.setValue(key + ".enabled", defaultStore.getString(key + ".enabled"));
            this.tempstore.setValue(key + ".foreground", defaultStore.getString(key + ".foreground"));
            this.tempstore.setValue(key + ".background", defaultStore.getString(key + ".background"));
            this.tempstore.setValue(key + ".usebackgroundcolor", defaultStore.getBoolean(key + ".usebackgroundcolor"));
            this.tempstore.setValue(key + ".bold", defaultStore.getBoolean(key + ".bold"));
            this.tempstore.setValue(key + ".italic", defaultStore.getBoolean(key + ".italic"));
            this.tempstore.setValue(key + ".strikethrough", defaultStore.getBoolean(key + ".strikethrough"));
            this.tempstore.setValue(key + ".underline", defaultStore.getBoolean(key + ".underline"));
        }
    }

    private void createSemanticHighlightingCheckbox(Composite parent) {
        this.loadIntoTemp("org.eclipse.titan.designer.enableSemanticHighlighting");
        this.enableSemanticHighlighting = new BooleanFieldEditor("org.eclipse.titan.designer.enableSemanticHighlighting", ENABLE_SEMANTIC_HIGHLIGHTING, 32, parent);
        this.enableSemanticHighlighting.setEnabled(true, parent);
        this.enableSemanticHighlighting.setPreferenceStore((IPreferenceStore)this.tempstore);
        this.enableSemanticHighlighting.setPage((DialogPage)this);
        this.enableSemanticHighlighting.load();
        this.enableSemanticHighlighting.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyntaxHighlightPage.this.possiblyChangedPreferences.put(SyntaxHighlightPage.this.enableSemanticHighlighting.getPreferenceName(), null);
                SyntaxHighlightPage.this.enableSemanticHighlighting.store();
                if (SyntaxHighlightPage.this.ttcn3SemanticGroup != null) {
                    SyntaxHighlightPage.this.ttcn3SemanticGroup.setEnabled(SyntaxHighlightPage.this.enableSemanticHighlighting.getBooleanValue());
                    SyntaxHighlightPage.this.treeViewer.refresh();
                }
                SyntaxHighlightPage.this.updateStyleRanges();
            }
        });
    }

    private void createUpperHalf(Composite parent) {
        this.upperHalfComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.upperHalfComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.upperHalfComposite.setLayoutData((Object)gridData);
        this.createTreeViewer(this.upperHalfComposite);
        this.createColorEditors(this.upperHalfComposite);
    }

    protected Control createContents(Composite parent) {
        this.pageComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.pageComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.pageComposite.setLayoutData((Object)gridData);
        this.createSemanticHighlightingCheckbox(this.pageComposite);
        this.createUpperHalf(this.pageComposite);
        return this.pageComposite;
    }

    private SyntaxHighlightColoringGroup initialInput() {
        SyntaxHighlightColoringGroup root = new SyntaxHighlightColoringGroup("root");
        SyntaxHighlightColoringGroup generalGroup = new SyntaxHighlightColoringGroup("General");
        generalGroup.add(new SyntaxHighlightColoringElement("Plain text", "org.eclipse.titan.designer.color.normalText"));
        generalGroup.add(new SyntaxHighlightColoringElement("Strings", "org.eclipse.titan.designer.color.strings"));
        generalGroup.add(new SyntaxHighlightColoringElement("Integers", "org.eclipse.titan.designer.color.integers"));
        generalGroup.add(new SyntaxHighlightColoringElement("Floats", "org.eclipse.titan.designer.color.floats"));
        root.add(generalGroup);
        SyntaxHighlightColoringGroup asn1Group = new SyntaxHighlightColoringGroup("ASN.1 specific");
        asn1Group.add(new SyntaxHighlightColoringElement("Keywords", "org.eclipse.titan.designer.color.asn1keywords"));
        asn1Group.add(new SyntaxHighlightColoringElement("CMIP verbs", "org.eclipse.titan.designer.color.CMIP_Verb"));
        asn1Group.add(new SyntaxHighlightColoringElement("compare types", "org.eclipse.titan.designer.color.compare_type"));
        asn1Group.add(new SyntaxHighlightColoringElement("Status", "org.eclipse.titan.designer.color.status_type"));
        asn1Group.add(new SyntaxHighlightColoringElement("Tags", "org.eclipse.titan.designer.color.tag"));
        asn1Group.add(new SyntaxHighlightColoringElement("Storage", "org.eclipse.titan.designer.color.storage"));
        asn1Group.add(new SyntaxHighlightColoringElement("Modifier", "org.eclipse.titan.designer.color.modifier"));
        asn1Group.add(new SyntaxHighlightColoringElement("Access types", "org.eclipse.titan.designer.color.access_type"));
        root.add(asn1Group);
        SyntaxHighlightColoringGroup configGroup = new SyntaxHighlightColoringGroup("Configuration specific");
        configGroup.add(new SyntaxHighlightColoringElement("Keywords", "org.eclipse.titan.designer.color.config_keywords"));
        configGroup.add(new SyntaxHighlightColoringElement("Section title", "org.eclipse.titan.designer.color.section_title"));
        configGroup.add(new SyntaxHighlightColoringElement("File and control mask options", "org.eclipse.titan.designer.color.file_and_control_mask_options"));
        configGroup.add(new SyntaxHighlightColoringElement("External command types", "org.eclipse.titan.designer.color.external_command_types"));
        root.add(configGroup);
        SyntaxHighlightColoringGroup ttcn3Group = new SyntaxHighlightColoringGroup("TTCN-3 specific");
        ttcn3Group.add(new SyntaxHighlightColoringElement("Keywords", "org.eclipse.titan.designer.color.ttcn3_keywords"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Preprocessor", "org.eclipse.titan.designer.color.preprocessor"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Visibility modifiers", "org.eclipse.titan.designer.color.visibility_op"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Template match", "org.eclipse.titan.designer.color.template_match"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Type", "org.eclipse.titan.designer.color.type"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Timer operators", "org.eclipse.titan.designer.color.timer_op"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Port operators", "org.eclipse.titan.designer.color.port_op"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Config operators", "org.eclipse.titan.designer.color.config_op"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Verdict operators", "org.eclipse.titan.designer.color.verdict_op"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("System under test related operators", "org.eclipse.titan.designer.color.sut_op"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Function operators", "org.eclipse.titan.designer.color.function_op"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Predefined operators", "org.eclipse.titan.designer.color.predefined_op"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Boolean consts", "org.eclipse.titan.designer.color.boolean_const"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Verdict consts", "org.eclipse.titan.designer.color.ttcn3_verdict_const"));
        ttcn3Group.add(new SyntaxHighlightColoringElement("Other consts", "org.eclipse.titan.designer.color.other_const"));
        root.add(ttcn3Group);
        SyntaxHighlightColoringGroup commentGroup = new SyntaxHighlightColoringGroup("Comments");
        commentGroup.add(new SyntaxHighlightColoringElement("Comment default", "org.eclipse.titan.designer.color.comments"));
        commentGroup.add(new SyntaxHighlightColoringElement("Document comment tag", "org.eclipse.titan.designer.color.commenttag"));
        commentGroup.add(new SyntaxHighlightColoringElement("Nested HTML tag", "org.eclipse.titan.designer.color.htmltag"));
        root.add(commentGroup);
        this.ttcn3SemanticGroup = new SyntaxHighlightColoringGroup("TTCN-3 semantic specific");
        this.ttcn3SemanticGroup.add(new SyntaxHighlightColoringElement("Constants", "org.eclipse.titan.designer.color.ast_constant"));
        this.ttcn3SemanticGroup.add(new SyntaxHighlightColoringElement("Deprecated elements", "org.eclipse.titan.designer.color.ast_deprecated"));
        this.ttcn3SemanticGroup.add(new SyntaxHighlightColoringElement("Type definitions", "org.eclipse.titan.designer.color.ast_deftype"));
        this.ttcn3SemanticGroup.add(new SyntaxHighlightColoringElement("Variables", "org.eclipse.titan.designer.color.ast_variable"));
        this.ttcn3SemanticGroup.add(new SyntaxHighlightColoringElement("Unused definitions", "org.eclipse.titan.designer.color.ast_unused"));
        this.ttcn3SemanticGroup.setEnabled(this.enableSemanticHighlighting.getBooleanValue());
        root.add(this.ttcn3SemanticGroup);
        return root;
    }

    private void addTemplateText(String key, String text) {
        this.addTemplateText(key, text, null);
    }

    private void addTemplateText(String key, String text, String optWhiteSpace) {
        int start = this.textViewer.getText().length();
        this.textViewer.append(text);
        StyleRange range = this.colorManager.createStyleRangeFromPreference(key, Activator.getDefault().getPreferenceStore(), start, text.length());
        this.textViewer.setStyleRange(range);
        ArrayList<StyleRange> list = this.rangeMap.containsKey(key) ? this.rangeMap.get(key) : new ArrayList<StyleRange>();
        list.add(range);
        this.rangeMap.put(key, list);
        if (optWhiteSpace != null) {
            this.textViewer.append(optWhiteSpace);
        }
    }

    private void fillTemplateText() {
        this.addTemplateText("org.eclipse.titan.designer.color.comments", "/**", "\n ");
        this.addTemplateText("org.eclipse.titan.designer.color.comments", " *", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.commenttag", "@desc", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.comments", "Syntax highlighting preview");
        this.addTemplateText("org.eclipse.titan.designer.color.htmltag", "<br>", "\n");
        this.addTemplateText("org.eclipse.titan.designer.color.comments", " */", "\n");
        this.addTemplateText("org.eclipse.titan.designer.color.ttcn3_keywords", "module", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "MyExample", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "{", "\n");
        this.addTemplateText("org.eclipse.titan.designer.color.ttcn3_keywords", "type", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.ttcn3_keywords", "port", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.ast_deftype", "PCOType", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "message", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "{", "\n\t");
        this.addTemplateText("org.eclipse.titan.designer.color.ttcn3_keywords", "inout", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.type", "charstring");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", ";", "\n");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "}", "\n");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "type", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "component", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "MTCType", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "{", "\n\t");
        this.addTemplateText("org.eclipse.titan.designer.color.ttcn3_keywords", "port", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.ast_deftype", "PCOType", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "MyPCO_PT");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", ";", "\n");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "}", "\n");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "type", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "record", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.ast_deftype", "MyRecord", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "{", "\n\t");
        this.addTemplateText("org.eclipse.titan.designer.color.type", "integer", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.ast_variable", "x1");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", ",", "\n\t");
        this.addTemplateText("org.eclipse.titan.designer.color.type", "charstring", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.ast_variable", "c2", "\n");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "}", "\n");
        this.addTemplateText("org.eclipse.titan.designer.color.ttcn3_keywords", "type", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.ttcn3_keywords", "enumerated", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.ast_deftype", "WorkDays", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "{", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "Monday");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", ",", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "Tuesday");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", ",", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "Wednesday");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", ",", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "Thursday");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", ",", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "Friday", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "}", "\n");
        this.addTemplateText("org.eclipse.titan.designer.color.ttcn3_keywords", "const", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.type", "integer", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.ast_constant", "c_integer", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", ":=", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.integers", "33");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", ";", "\n");
        this.addTemplateText("org.eclipse.titan.designer.color.ttcn3_keywords", "var", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.type", "float", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.ast_variable", "dep", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", ":=", " ");
        this.addTemplateText("org.eclipse.titan.designer.color.ast_deprecated", "deprecated_function()");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", ";", "\n");
        this.addTemplateText("org.eclipse.titan.designer.color.normalText", "}");
        this.updateStyleRanges();
    }

    private void updateStyleRanges() {
        try {
            boolean isSemantic = this.enableSemanticHighlighting.getBooleanValue();
            for (Map.Entry<String, List<StyleRange>> entry : this.rangeMap.entrySet()) {
                String base = entry.getKey();
                if (!isSemantic) {
                    switch (entry.getKey()) {
                        case "org.eclipse.titan.designer.color.ast_constant": 
                        case "org.eclipse.titan.designer.color.ast_variable": 
                        case "org.eclipse.titan.designer.color.ast_deftype": 
                        case "org.eclipse.titan.designer.color.ast_deprecated": 
                        case "org.eclipse.titan.designer.color.ast_unused": {
                            base = "org.eclipse.titan.designer.color.normalText";
                            break;
                        }
                    }
                }
                for (StyleRange oldRange : entry.getValue()) {
                    this.textViewer.setStyleRange(this.colorManager.createStyleRangeFromPreference(base, (IPreferenceStore)this.tempstore, oldRange.start, oldRange.length));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    final class TempPreferenceInitializer
    extends PreferenceInitializer {
        TempPreferenceInitializer() {
        }

        @Override
        public IPreferenceStore getPreference() {
            return SyntaxHighlightPage.this.tempstore;
        }
    }
}

