/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.WhiteSpaceDetector;
import org.eclipse.titan.designer.editors.ttcn3editor.CommentTagDetector;
import org.eclipse.titan.designer.editors.ttcn3editor.CommentTextDetector;
import org.eclipse.titan.designer.editors.ttcn3editor.HtmlTagDetectionRule;

public final class CommentScanner
extends RuleBasedScanner {
    public CommentScanner(ColorManager colorManager) {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token keyword = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.commenttag");
        Token comment = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.comments");
        Token htmltag = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.htmltag");
        WordRule wordRule = new WordRule((IWordDetector)new CommentTagDetector(), (IToken)comment);
        for (String element : ICommentable.DOC_COMMENT_TAGS) {
            wordRule.addWord(element, (IToken)keyword);
        }
        rules.add(wordRule);
        rules.add(new HtmlTagDetectionRule((IToken)htmltag));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhiteSpaceDetector()));
        WordRule commentTextRule = new WordRule((IWordDetector)new CommentTextDetector(), (IToken)comment);
        rules.add(commentTextRule);
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }
}

