/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.editors.actions.DeclarationCollectionHelper;

public final class DeclarationCollector {
    private final Reference refrence;
    private final List<DeclarationCollectionHelper> collected;

    public DeclarationCollector(Reference reference) {
        this.refrence = reference;
        this.collected = new ArrayList<DeclarationCollectionHelper>();
    }

    public Reference getReference() {
        return this.refrence;
    }

    public int getCollectionSize() {
        return this.collected.size();
    }

    public List<DeclarationCollectionHelper> getCollected() {
        return this.collected;
    }

    public void addDeclaration(String description, Location location, Scope scope) {
        this.collected.add(new DeclarationCollectionHelper(description, location, scope));
    }

    public void addDeclaration(String description, Location location, ASTNode node) {
        this.collected.add(new DeclarationCollectionHelper(description, location, node));
    }

    public void addDeclaration(Assignment assignment) {
        if (assignment == null) {
            return;
        }
        if (assignment.getIdentifier() == null) {
            this.collected.add(new DeclarationCollectionHelper(assignment.getProposalDescription(), assignment.getLocation(), assignment));
        } else {
            this.collected.add(new DeclarationCollectionHelper(assignment.getProposalDescription(), assignment.getIdentifier().getLocation(), assignment));
        }
    }

    public void addDeclaration(Definition definition) {
        if (definition == null) {
            return;
        }
        StringBuilder description = new StringBuilder();
        description.append(definition.getProposalDescription());
        if (definition.getIdentifier() == null) {
            this.collected.add(new DeclarationCollectionHelper(description.toString(), definition.getLocation(), definition));
        } else {
            this.collected.add(new DeclarationCollectionHelper(description.toString(), definition.getIdentifier().getLocation(), definition));
        }
    }

    public void addDeclaration(Group group) {
        if (group == null) {
            return;
        }
        StringBuilder description = new StringBuilder();
        this.collected.add(new DeclarationCollectionHelper(description.toString(), group.getLocation(), group));
    }
}

