/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.PortScope;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class GetPortReferenceExpression
extends Expression_Value {
    private Port_Type type;

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.GETPORTREFERENCE_OPERATION;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_PORT;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return false;
    }

    @Override
    public String createStringRepresentation() {
        return "getref()";
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp) {
        PortScope portScope = this.myScope.getScopePort();
        if (portScope == null) {
            this.getLocation().reportSemanticError("Operation `port.getref' can only be used in a function with a port clause.");
            this.setIsErroneous(true);
            return;
        }
        this.type = portScope.getPortType();
        if (this.myGovernor != null && this.type != null && !this.type.isIdentical(timestamp, this.myGovernor)) {
            this.getLocation().reportSemanticError(MessageFormat.format("Type mismatch: A value of type `{0}'' was expected instead of `{1}''", this.myGovernor.getTypename(), this.type.getTypename()));
            this.setIsErroneous(true);
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        this.type = null;
        this.checkExpressionOperands(timestamp);
        return this.lastValue;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return false;
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        aData.addCommonLibraryImport("TTCN_Runtime");
        aData.addCommonLibraryImport("TtcnError");
        aData.addBuiltinTypeImport("TitanPort");
        String tempId = aData.getTemporaryVariableName();
        String portName = this.type.getGenNameValue(aData, expression.expression);
        expression.preamble.append(MessageFormat.format("TitanPort {0} = TTCN_Runtime.get_translation_port();\n", tempId));
        expression.preamble.append(MessageFormat.format("if (!({0} instanceof {1})) '{'\n", tempId, portName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Internal error: Conversion of port reference to type `{0}' failed.\");\n", this.type.getTypename()));
        expression.preamble.append("}\n");
        expression.expression.append(MessageFormat.format("({0}) {1}", portName, tempId));
    }
}

